<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDomains;

class AuthorizationCode extends \Google\Model
{
  /**
   * The Authorization Code in ASCII. It can be used to transfer the domain to
   * or from another registrar.
   *
   * @var string
   */
  public $code;

  /**
   * The Authorization Code in ASCII. It can be used to transfer the domain to
   * or from another registrar.
   *
   * @param string $code
   */
  public function setCode($code)
  {
    $this->code = $code;
  }
  /**
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AuthorizationCode::class, 'Google_Service_CloudDomains_AuthorizationCode');
