<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CustomerEngagementSuite;

class Agent extends \Google\Collection
{
  protected $collection_key = 'transferRules';
  protected $afterAgentCallbacksType = Callback::class;
  protected $afterAgentCallbacksDataType = 'array';
  protected $afterModelCallbacksType = Callback::class;
  protected $afterModelCallbacksDataType = 'array';
  protected $afterToolCallbacksType = Callback::class;
  protected $afterToolCallbacksDataType = 'array';
  protected $beforeAgentCallbacksType = Callback::class;
  protected $beforeAgentCallbacksDataType = 'array';
  protected $beforeModelCallbacksType = Callback::class;
  protected $beforeModelCallbacksDataType = 'array';
  protected $beforeToolCallbacksType = Callback::class;
  protected $beforeToolCallbacksDataType = 'array';
  /**
   * Optional. List of child agents in the agent tree. Format:
   * `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
   *
   * @var string[]
   */
  public $childAgents;
  /**
   * Output only. Timestamp when the agent was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Optional. Human-readable description of the agent.
   *
   * @var string
   */
  public $description;
  /**
   * Required. Display name of the agent.
   *
   * @var string
   */
  public $displayName;
  /**
   * Etag used to ensure the object hasn't changed during a read-modify-write
   * operation. If the etag is empty, the update will overwrite any concurrent
   * changes.
   *
   * @var string
   */
  public $etag;
  /**
   * Output only. If the agent is generated by the LLM assistant, this field
   * contains a descriptive summary of the generation.
   *
   * @var string
   */
  public $generatedSummary;
  /**
   * Optional. List of guardrails for the agent. Format:
   * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
   *
   * @var string[]
   */
  public $guardrails;
  /**
   * Optional. Instructions for the LLM model to guide the agent's behavior.
   *
   * @var string
   */
  public $instruction;
  protected $llmAgentType = AgentLlmAgent::class;
  protected $llmAgentDataType = '';
  protected $modelSettingsType = ModelSettings::class;
  protected $modelSettingsDataType = '';
  /**
   * Identifier. The unique identifier of the agent. Format:
   * `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
   *
   * @var string
   */
  public $name;
  protected $remoteDialogflowAgentType = AgentRemoteDialogflowAgent::class;
  protected $remoteDialogflowAgentDataType = '';
  /**
   * Optional. List of available tools for the agent. Format:
   * `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
   *
   * @var string[]
   */
  public $tools;
  protected $toolsetsType = AgentAgentToolset::class;
  protected $toolsetsDataType = 'array';
  protected $transferRulesType = TransferRule::class;
  protected $transferRulesDataType = 'array';
  /**
   * Output only. Timestamp when the agent was last updated.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Optional. The callbacks to execute after the agent is called. The provided
   * callbacks are executed sequentially in the exact order they are given in
   * the list. If a callback returns an overridden response, execution stops and
   * any remaining callbacks are skipped.
   *
   * @param Callback[] $afterAgentCallbacks
   */
  public function setAfterAgentCallbacks($afterAgentCallbacks)
  {
    $this->afterAgentCallbacks = $afterAgentCallbacks;
  }
  /**
   * @return Callback[]
   */
  public function getAfterAgentCallbacks()
  {
    return $this->afterAgentCallbacks;
  }
  /**
   * Optional. The callbacks to execute after the model is called. If there are
   * multiple calls to the model, the callback will be executed multiple times.
   * The provided callbacks are executed sequentially in the exact order they
   * are given in the list. If a callback returns an overridden response,
   * execution stops and any remaining callbacks are skipped.
   *
   * @param Callback[] $afterModelCallbacks
   */
  public function setAfterModelCallbacks($afterModelCallbacks)
  {
    $this->afterModelCallbacks = $afterModelCallbacks;
  }
  /**
   * @return Callback[]
   */
  public function getAfterModelCallbacks()
  {
    return $this->afterModelCallbacks;
  }
  /**
   * Optional. The callbacks to execute after the tool is invoked. If there are
   * multiple tool invocations, the callback will be executed multiple times.
   * The provided callbacks are executed sequentially in the exact order they
   * are given in the list. If a callback returns an overridden response,
   * execution stops and any remaining callbacks are skipped.
   *
   * @param Callback[] $afterToolCallbacks
   */
  public function setAfterToolCallbacks($afterToolCallbacks)
  {
    $this->afterToolCallbacks = $afterToolCallbacks;
  }
  /**
   * @return Callback[]
   */
  public function getAfterToolCallbacks()
  {
    return $this->afterToolCallbacks;
  }
  /**
   * Optional. The callbacks to execute before the agent is called. The provided
   * callbacks are executed sequentially in the exact order they are given in
   * the list. If a callback returns an overridden response, execution stops and
   * any remaining callbacks are skipped.
   *
   * @param Callback[] $beforeAgentCallbacks
   */
  public function setBeforeAgentCallbacks($beforeAgentCallbacks)
  {
    $this->beforeAgentCallbacks = $beforeAgentCallbacks;
  }
  /**
   * @return Callback[]
   */
  public function getBeforeAgentCallbacks()
  {
    return $this->beforeAgentCallbacks;
  }
  /**
   * Optional. The callbacks to execute before the model is called. If there are
   * multiple calls to the model, the callback will be executed multiple times.
   * The provided callbacks are executed sequentially in the exact order they
   * are given in the list. If a callback returns an overridden response,
   * execution stops and any remaining callbacks are skipped.
   *
   * @param Callback[] $beforeModelCallbacks
   */
  public function setBeforeModelCallbacks($beforeModelCallbacks)
  {
    $this->beforeModelCallbacks = $beforeModelCallbacks;
  }
  /**
   * @return Callback[]
   */
  public function getBeforeModelCallbacks()
  {
    return $this->beforeModelCallbacks;
  }
  /**
   * Optional. The callbacks to execute before the tool is invoked. If there are
   * multiple tool invocations, the callback will be executed multiple times.
   * The provided callbacks are executed sequentially in the exact order they
   * are given in the list. If a callback returns an overridden response,
   * execution stops and any remaining callbacks are skipped.
   *
   * @param Callback[] $beforeToolCallbacks
   */
  public function setBeforeToolCallbacks($beforeToolCallbacks)
  {
    $this->beforeToolCallbacks = $beforeToolCallbacks;
  }
  /**
   * @return Callback[]
   */
  public function getBeforeToolCallbacks()
  {
    return $this->beforeToolCallbacks;
  }
  /**
   * Optional. List of child agents in the agent tree. Format:
   * `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
   *
   * @param string[] $childAgents
   */
  public function setChildAgents($childAgents)
  {
    $this->childAgents = $childAgents;
  }
  /**
   * @return string[]
   */
  public function getChildAgents()
  {
    return $this->childAgents;
  }
  /**
   * Output only. Timestamp when the agent was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. Human-readable description of the agent.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Required. Display name of the agent.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Etag used to ensure the object hasn't changed during a read-modify-write
   * operation. If the etag is empty, the update will overwrite any concurrent
   * changes.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Output only. If the agent is generated by the LLM assistant, this field
   * contains a descriptive summary of the generation.
   *
   * @param string $generatedSummary
   */
  public function setGeneratedSummary($generatedSummary)
  {
    $this->generatedSummary = $generatedSummary;
  }
  /**
   * @return string
   */
  public function getGeneratedSummary()
  {
    return $this->generatedSummary;
  }
  /**
   * Optional. List of guardrails for the agent. Format:
   * `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
   *
   * @param string[] $guardrails
   */
  public function setGuardrails($guardrails)
  {
    $this->guardrails = $guardrails;
  }
  /**
   * @return string[]
   */
  public function getGuardrails()
  {
    return $this->guardrails;
  }
  /**
   * Optional. Instructions for the LLM model to guide the agent's behavior.
   *
   * @param string $instruction
   */
  public function setInstruction($instruction)
  {
    $this->instruction = $instruction;
  }
  /**
   * @return string
   */
  public function getInstruction()
  {
    return $this->instruction;
  }
  /**
   * Optional. The default agent type.
   *
   * @param AgentLlmAgent $llmAgent
   */
  public function setLlmAgent(AgentLlmAgent $llmAgent)
  {
    $this->llmAgent = $llmAgent;
  }
  /**
   * @return AgentLlmAgent
   */
  public function getLlmAgent()
  {
    return $this->llmAgent;
  }
  /**
   * Optional. Configurations for the LLM model.
   *
   * @param ModelSettings $modelSettings
   */
  public function setModelSettings(ModelSettings $modelSettings)
  {
    $this->modelSettings = $modelSettings;
  }
  /**
   * @return ModelSettings
   */
  public function getModelSettings()
  {
    return $this->modelSettings;
  }
  /**
   * Identifier. The unique identifier of the agent. Format:
   * `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. The remote
   * [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-
   * conversational-agents) agent to be used for the agent execution. If this
   * field is set, all other agent level properties will be ignored. Note: If
   * the Dialogflow agent is in a different project from the app, you should
   * grant `roles/dialogflow.client` to the CES service agent `service-@gcp-sa-
   * ces.iam.gserviceaccount.com`.
   *
   * @param AgentRemoteDialogflowAgent $remoteDialogflowAgent
   */
  public function setRemoteDialogflowAgent(AgentRemoteDialogflowAgent $remoteDialogflowAgent)
  {
    $this->remoteDialogflowAgent = $remoteDialogflowAgent;
  }
  /**
   * @return AgentRemoteDialogflowAgent
   */
  public function getRemoteDialogflowAgent()
  {
    return $this->remoteDialogflowAgent;
  }
  /**
   * Optional. List of available tools for the agent. Format:
   * `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
   *
   * @param string[] $tools
   */
  public function setTools($tools)
  {
    $this->tools = $tools;
  }
  /**
   * @return string[]
   */
  public function getTools()
  {
    return $this->tools;
  }
  /**
   * Optional. List of toolsets for the agent.
   *
   * @param AgentAgentToolset[] $toolsets
   */
  public function setToolsets($toolsets)
  {
    $this->toolsets = $toolsets;
  }
  /**
   * @return AgentAgentToolset[]
   */
  public function getToolsets()
  {
    return $this->toolsets;
  }
  /**
   * Optional. Agent transfer rules. If multiple rules match, the first one in
   * the list will be used.
   *
   * @param TransferRule[] $transferRules
   */
  public function setTransferRules($transferRules)
  {
    $this->transferRules = $transferRules;
  }
  /**
   * @return TransferRule[]
   */
  public function getTransferRules()
  {
    return $this->transferRules;
  }
  /**
   * Output only. Timestamp when the agent was last updated.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Agent::class, 'Google_Service_CustomerEngagementSuite_Agent');
