<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetAppFiles;

class BlockDevice extends \Google\Collection
{
  /**
   * Unspecified OS Type
   */
  public const OS_TYPE_OS_TYPE_UNSPECIFIED = 'OS_TYPE_UNSPECIFIED';
  /**
   * OS Type is Linux
   */
  public const OS_TYPE_LINUX = 'LINUX';
  /**
   * OS Type is Windows
   */
  public const OS_TYPE_WINDOWS = 'WINDOWS';
  /**
   * OS Type is VMware ESXi
   */
  public const OS_TYPE_ESXI = 'ESXI';
  protected $collection_key = 'hostGroups';
  /**
   * Optional. A list of host groups that identify hosts that can mount the
   * block volume. Format:
   * `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
   * This field can be updated after the block device is created.
   *
   * @var string[]
   */
  public $hostGroups;
  /**
   * Output only. Device identifier of the block volume. This represents
   * `lun_serial_number` for iSCSI volumes.
   *
   * @var string
   */
  public $identifier;
  /**
   * Optional. User-defined name for the block device, unique within the volume.
   * In case no user input is provided, name will be auto-generated in the
   * backend. The name must meet the following requirements: * Be between 1 and
   * 255 characters long. * Contain only uppercase or lowercase letters (A-Z,
   * a-z), numbers (0-9), and the following special characters: "-", "_", "}",
   * "{", ".". * Spaces are not allowed.
   *
   * @var string
   */
  public $name;
  /**
   * Required. Immutable. The OS type of the volume. This field can't be changed
   * after the block device is created.
   *
   * @var string
   */
  public $osType;
  /**
   * Optional. The size of the block device in GiB. Any value provided for the
   * `size_gib` field during volume creation is ignored. The block device's size
   * is system-managed and will be set to match the parent Volume's
   * `capacity_gib`.
   *
   * @var string
   */
  public $sizeGib;

  /**
   * Optional. A list of host groups that identify hosts that can mount the
   * block volume. Format:
   * `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
   * This field can be updated after the block device is created.
   *
   * @param string[] $hostGroups
   */
  public function setHostGroups($hostGroups)
  {
    $this->hostGroups = $hostGroups;
  }
  /**
   * @return string[]
   */
  public function getHostGroups()
  {
    return $this->hostGroups;
  }
  /**
   * Output only. Device identifier of the block volume. This represents
   * `lun_serial_number` for iSCSI volumes.
   *
   * @param string $identifier
   */
  public function setIdentifier($identifier)
  {
    $this->identifier = $identifier;
  }
  /**
   * @return string
   */
  public function getIdentifier()
  {
    return $this->identifier;
  }
  /**
   * Optional. User-defined name for the block device, unique within the volume.
   * In case no user input is provided, name will be auto-generated in the
   * backend. The name must meet the following requirements: * Be between 1 and
   * 255 characters long. * Contain only uppercase or lowercase letters (A-Z,
   * a-z), numbers (0-9), and the following special characters: "-", "_", "}",
   * "{", ".". * Spaces are not allowed.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Required. Immutable. The OS type of the volume. This field can't be changed
   * after the block device is created.
   *
   * Accepted values: OS_TYPE_UNSPECIFIED, LINUX, WINDOWS, ESXI
   *
   * @param self::OS_TYPE_* $osType
   */
  public function setOsType($osType)
  {
    $this->osType = $osType;
  }
  /**
   * @return self::OS_TYPE_*
   */
  public function getOsType()
  {
    return $this->osType;
  }
  /**
   * Optional. The size of the block device in GiB. Any value provided for the
   * `size_gib` field during volume creation is ignored. The block device's size
   * is system-managed and will be set to match the parent Volume's
   * `capacity_gib`.
   *
   * @param string $sizeGib
   */
  public function setSizeGib($sizeGib)
  {
    $this->sizeGib = $sizeGib;
  }
  /**
   * @return string
   */
  public function getSizeGib()
  {
    return $this->sizeGib;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BlockDevice::class, 'Google_Service_NetAppFiles_BlockDevice');
