<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class InstanceGroupManagersRecreateInstancesRequest extends \Google\Collection
{
  protected $collection_key = 'instances';
  /**
   * The URLs of one or more instances to recreate. This can be a full URL or a
   * partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
   *
   * @var string[]
   */
  public $instances;

  /**
   * The URLs of one or more instances to recreate. This can be a full URL or a
   * partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
   *
   * @param string[] $instances
   */
  public function setInstances($instances)
  {
    $this->instances = $instances;
  }
  /**
   * @return string[]
   */
  public function getInstances()
  {
    return $this->instances;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InstanceGroupManagersRecreateInstancesRequest::class, 'Google_Service_Compute_InstanceGroupManagersRecreateInstancesRequest');
