<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class Quota extends \Google\Model
{
  public const METRIC_A2_CPUS = 'A2_CPUS';
  public const METRIC_AFFINITY_GROUPS = 'AFFINITY_GROUPS';
  public const METRIC_AUTOSCALERS = 'AUTOSCALERS';
  public const METRIC_BACKEND_BUCKETS = 'BACKEND_BUCKETS';
  public const METRIC_BACKEND_SERVICES = 'BACKEND_SERVICES';
  public const METRIC_C2D_CPUS = 'C2D_CPUS';
  public const METRIC_C2_CPUS = 'C2_CPUS';
  public const METRIC_C3_CPUS = 'C3_CPUS';
  public const METRIC_COMMITMENTS = 'COMMITMENTS';
  public const METRIC_COMMITTED_A2_CPUS = 'COMMITTED_A2_CPUS';
  public const METRIC_COMMITTED_C2D_CPUS = 'COMMITTED_C2D_CPUS';
  public const METRIC_COMMITTED_C2_CPUS = 'COMMITTED_C2_CPUS';
  public const METRIC_COMMITTED_C3_CPUS = 'COMMITTED_C3_CPUS';
  public const METRIC_COMMITTED_CPUS = 'COMMITTED_CPUS';
  public const METRIC_COMMITTED_E2_CPUS = 'COMMITTED_E2_CPUS';
  public const METRIC_COMMITTED_LICENSES = 'COMMITTED_LICENSES';
  public const METRIC_COMMITTED_LOCAL_SSD_TOTAL_GB = 'COMMITTED_LOCAL_SSD_TOTAL_GB';
  public const METRIC_COMMITTED_M3_CPUS = 'COMMITTED_M3_CPUS';
  public const METRIC_COMMITTED_MEMORY_OPTIMIZED_CPUS = 'COMMITTED_MEMORY_OPTIMIZED_CPUS';
  public const METRIC_COMMITTED_N2A_CPUS = 'COMMITTED_N2A_CPUS';
  public const METRIC_COMMITTED_N2D_CPUS = 'COMMITTED_N2D_CPUS';
  public const METRIC_COMMITTED_N2_CPUS = 'COMMITTED_N2_CPUS';
  public const METRIC_COMMITTED_NVIDIA_A100_80GB_GPUS = 'COMMITTED_NVIDIA_A100_80GB_GPUS';
  public const METRIC_COMMITTED_NVIDIA_A100_GPUS = 'COMMITTED_NVIDIA_A100_GPUS';
  public const METRIC_COMMITTED_NVIDIA_H100_GPUS = 'COMMITTED_NVIDIA_H100_GPUS';
  public const METRIC_COMMITTED_NVIDIA_K80_GPUS = 'COMMITTED_NVIDIA_K80_GPUS';
  public const METRIC_COMMITTED_NVIDIA_L4_GPUS = 'COMMITTED_NVIDIA_L4_GPUS';
  public const METRIC_COMMITTED_NVIDIA_P100_GPUS = 'COMMITTED_NVIDIA_P100_GPUS';
  public const METRIC_COMMITTED_NVIDIA_P4_GPUS = 'COMMITTED_NVIDIA_P4_GPUS';
  public const METRIC_COMMITTED_NVIDIA_T4_GPUS = 'COMMITTED_NVIDIA_T4_GPUS';
  public const METRIC_COMMITTED_NVIDIA_V100_GPUS = 'COMMITTED_NVIDIA_V100_GPUS';
  public const METRIC_COMMITTED_T2A_CPUS = 'COMMITTED_T2A_CPUS';
  public const METRIC_COMMITTED_T2D_CPUS = 'COMMITTED_T2D_CPUS';
  public const METRIC_COMMITTED_Z3_CPUS = 'COMMITTED_Z3_CPUS';
  /**
   * Guest CPUs
   */
  public const METRIC_CPUS = 'CPUS';
  public const METRIC_CPUS_ALL_REGIONS = 'CPUS_ALL_REGIONS';
  public const METRIC_DISKS_TOTAL_GB = 'DISKS_TOTAL_GB';
  public const METRIC_E2_CPUS = 'E2_CPUS';
  public const METRIC_EXTERNAL_MANAGED_FORWARDING_RULES = 'EXTERNAL_MANAGED_FORWARDING_RULES';
  public const METRIC_EXTERNAL_NETWORK_LB_FORWARDING_RULES = 'EXTERNAL_NETWORK_LB_FORWARDING_RULES';
  public const METRIC_EXTERNAL_PROTOCOL_FORWARDING_RULES = 'EXTERNAL_PROTOCOL_FORWARDING_RULES';
  public const METRIC_EXTERNAL_VPN_GATEWAYS = 'EXTERNAL_VPN_GATEWAYS';
  public const METRIC_FIREWALLS = 'FIREWALLS';
  public const METRIC_FORWARDING_RULES = 'FORWARDING_RULES';
  public const METRIC_GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES = 'GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES';
  public const METRIC_GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES = 'GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES';
  public const METRIC_GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES = 'GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES';
  public const METRIC_GLOBAL_INTERNAL_ADDRESSES = 'GLOBAL_INTERNAL_ADDRESSES';
  public const METRIC_GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES = 'GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES';
  public const METRIC_GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES = 'GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES';
  public const METRIC_GPUS_ALL_REGIONS = 'GPUS_ALL_REGIONS';
  public const METRIC_HDB_TOTAL_GB = 'HDB_TOTAL_GB';
  public const METRIC_HDB_TOTAL_IOPS = 'HDB_TOTAL_IOPS';
  public const METRIC_HDB_TOTAL_THROUGHPUT = 'HDB_TOTAL_THROUGHPUT';
  public const METRIC_HEALTH_CHECKS = 'HEALTH_CHECKS';
  public const METRIC_IMAGES = 'IMAGES';
  public const METRIC_INSTANCES = 'INSTANCES';
  public const METRIC_INSTANCE_GROUPS = 'INSTANCE_GROUPS';
  public const METRIC_INSTANCE_GROUP_MANAGERS = 'INSTANCE_GROUP_MANAGERS';
  public const METRIC_INSTANCE_TEMPLATES = 'INSTANCE_TEMPLATES';
  public const METRIC_INTERCONNECTS = 'INTERCONNECTS';
  public const METRIC_INTERCONNECT_ATTACHMENTS_PER_REGION = 'INTERCONNECT_ATTACHMENTS_PER_REGION';
  public const METRIC_INTERCONNECT_ATTACHMENTS_TOTAL_MBPS = 'INTERCONNECT_ATTACHMENTS_TOTAL_MBPS';
  public const METRIC_INTERCONNECT_TOTAL_GBPS = 'INTERCONNECT_TOTAL_GBPS';
  public const METRIC_INTERNAL_ADDRESSES = 'INTERNAL_ADDRESSES';
  public const METRIC_INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES = 'INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES';
  public const METRIC_IN_PLACE_SNAPSHOTS = 'IN_PLACE_SNAPSHOTS';
  public const METRIC_IN_USE_ADDRESSES = 'IN_USE_ADDRESSES';
  public const METRIC_IN_USE_BACKUP_SCHEDULES = 'IN_USE_BACKUP_SCHEDULES';
  public const METRIC_IN_USE_SNAPSHOT_SCHEDULES = 'IN_USE_SNAPSHOT_SCHEDULES';
  public const METRIC_LOCAL_SSD_TOTAL_GB = 'LOCAL_SSD_TOTAL_GB';
  public const METRIC_M1_CPUS = 'M1_CPUS';
  public const METRIC_M2_CPUS = 'M2_CPUS';
  public const METRIC_M3_CPUS = 'M3_CPUS';
  public const METRIC_MACHINE_IMAGES = 'MACHINE_IMAGES';
  public const METRIC_N2A_CPUS = 'N2A_CPUS';
  public const METRIC_N2D_CPUS = 'N2D_CPUS';
  public const METRIC_N2_CPUS = 'N2_CPUS';
  public const METRIC_NETWORKS = 'NETWORKS';
  public const METRIC_NETWORK_ATTACHMENTS = 'NETWORK_ATTACHMENTS';
  public const METRIC_NETWORK_ENDPOINT_GROUPS = 'NETWORK_ENDPOINT_GROUPS';
  public const METRIC_NETWORK_FIREWALL_POLICIES = 'NETWORK_FIREWALL_POLICIES';
  public const METRIC_NET_LB_SECURITY_POLICIES_PER_REGION = 'NET_LB_SECURITY_POLICIES_PER_REGION';
  public const METRIC_NET_LB_SECURITY_POLICY_RULES_PER_REGION = 'NET_LB_SECURITY_POLICY_RULES_PER_REGION';
  public const METRIC_NET_LB_SECURITY_POLICY_RULE_ATTRIBUTES_PER_REGION = 'NET_LB_SECURITY_POLICY_RULE_ATTRIBUTES_PER_REGION';
  public const METRIC_NODE_GROUPS = 'NODE_GROUPS';
  public const METRIC_NODE_TEMPLATES = 'NODE_TEMPLATES';
  public const METRIC_NVIDIA_A100_80GB_GPUS = 'NVIDIA_A100_80GB_GPUS';
  public const METRIC_NVIDIA_A100_GPUS = 'NVIDIA_A100_GPUS';
  public const METRIC_NVIDIA_K80_GPUS = 'NVIDIA_K80_GPUS';
  public const METRIC_NVIDIA_L4_GPUS = 'NVIDIA_L4_GPUS';
  public const METRIC_NVIDIA_P100_GPUS = 'NVIDIA_P100_GPUS';
  public const METRIC_NVIDIA_P100_VWS_GPUS = 'NVIDIA_P100_VWS_GPUS';
  public const METRIC_NVIDIA_P4_GPUS = 'NVIDIA_P4_GPUS';
  public const METRIC_NVIDIA_P4_VWS_GPUS = 'NVIDIA_P4_VWS_GPUS';
  public const METRIC_NVIDIA_T4_GPUS = 'NVIDIA_T4_GPUS';
  public const METRIC_NVIDIA_T4_VWS_GPUS = 'NVIDIA_T4_VWS_GPUS';
  public const METRIC_NVIDIA_V100_GPUS = 'NVIDIA_V100_GPUS';
  public const METRIC_PACKET_MIRRORINGS = 'PACKET_MIRRORINGS';
  public const METRIC_PD_EXTREME_TOTAL_PROVISIONED_IOPS = 'PD_EXTREME_TOTAL_PROVISIONED_IOPS';
  public const METRIC_PREEMPTIBLE_CPUS = 'PREEMPTIBLE_CPUS';
  public const METRIC_PREEMPTIBLE_LOCAL_SSD_GB = 'PREEMPTIBLE_LOCAL_SSD_GB';
  public const METRIC_PREEMPTIBLE_NVIDIA_A100_80GB_GPUS = 'PREEMPTIBLE_NVIDIA_A100_80GB_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_A100_GPUS = 'PREEMPTIBLE_NVIDIA_A100_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_H100_GPUS = 'PREEMPTIBLE_NVIDIA_H100_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_K80_GPUS = 'PREEMPTIBLE_NVIDIA_K80_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_L4_GPUS = 'PREEMPTIBLE_NVIDIA_L4_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_P100_GPUS = 'PREEMPTIBLE_NVIDIA_P100_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_P100_VWS_GPUS = 'PREEMPTIBLE_NVIDIA_P100_VWS_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_P4_GPUS = 'PREEMPTIBLE_NVIDIA_P4_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_P4_VWS_GPUS = 'PREEMPTIBLE_NVIDIA_P4_VWS_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_T4_GPUS = 'PREEMPTIBLE_NVIDIA_T4_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_T4_VWS_GPUS = 'PREEMPTIBLE_NVIDIA_T4_VWS_GPUS';
  public const METRIC_PREEMPTIBLE_NVIDIA_V100_GPUS = 'PREEMPTIBLE_NVIDIA_V100_GPUS';
  public const METRIC_PREEMPTIBLE_TPU_LITE_DEVICE_V5 = 'PREEMPTIBLE_TPU_LITE_DEVICE_V5';
  public const METRIC_PREEMPTIBLE_TPU_LITE_PODSLICE_V5 = 'PREEMPTIBLE_TPU_LITE_PODSLICE_V5';
  public const METRIC_PREEMPTIBLE_TPU_PODSLICE_V4 = 'PREEMPTIBLE_TPU_PODSLICE_V4';
  public const METRIC_PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK = 'PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK';
  public const METRIC_PSC_INTERNAL_LB_FORWARDING_RULES = 'PSC_INTERNAL_LB_FORWARDING_RULES';
  public const METRIC_PUBLIC_ADVERTISED_PREFIXES = 'PUBLIC_ADVERTISED_PREFIXES';
  public const METRIC_PUBLIC_DELEGATED_PREFIXES = 'PUBLIC_DELEGATED_PREFIXES';
  public const METRIC_REGIONAL_AUTOSCALERS = 'REGIONAL_AUTOSCALERS';
  public const METRIC_REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES = 'REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES';
  public const METRIC_REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES = 'REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES';
  public const METRIC_REGIONAL_INSTANCE_GROUP_MANAGERS = 'REGIONAL_INSTANCE_GROUP_MANAGERS';
  public const METRIC_REGIONAL_INTERNAL_LB_BACKEND_SERVICES = 'REGIONAL_INTERNAL_LB_BACKEND_SERVICES';
  public const METRIC_REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES = 'REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES';
  public const METRIC_REGIONAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES = 'REGIONAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES';
  public const METRIC_RESERVATIONS = 'RESERVATIONS';
  public const METRIC_RESOURCE_POLICIES = 'RESOURCE_POLICIES';
  public const METRIC_ROUTERS = 'ROUTERS';
  public const METRIC_ROUTES = 'ROUTES';
  public const METRIC_SECURITY_POLICIES = 'SECURITY_POLICIES';
  public const METRIC_SECURITY_POLICIES_PER_REGION = 'SECURITY_POLICIES_PER_REGION';
  public const METRIC_SECURITY_POLICY_ADVANCED_RULES_PER_REGION = 'SECURITY_POLICY_ADVANCED_RULES_PER_REGION';
  public const METRIC_SECURITY_POLICY_CEVAL_RULES = 'SECURITY_POLICY_CEVAL_RULES';
  public const METRIC_SECURITY_POLICY_RULES = 'SECURITY_POLICY_RULES';
  public const METRIC_SECURITY_POLICY_RULES_PER_REGION = 'SECURITY_POLICY_RULES_PER_REGION';
  public const METRIC_SERVICE_ATTACHMENTS = 'SERVICE_ATTACHMENTS';
  /**
   * The total number of snapshots allowed for a single project.
   */
  public const METRIC_SNAPSHOTS = 'SNAPSHOTS';
  public const METRIC_SSD_TOTAL_GB = 'SSD_TOTAL_GB';
  public const METRIC_SSL_CERTIFICATES = 'SSL_CERTIFICATES';
  public const METRIC_SSL_POLICIES = 'SSL_POLICIES';
  public const METRIC_STATIC_ADDRESSES = 'STATIC_ADDRESSES';
  public const METRIC_STATIC_BYOIP_ADDRESSES = 'STATIC_BYOIP_ADDRESSES';
  public const METRIC_STATIC_EXTERNAL_IPV6_ADDRESS_RANGES = 'STATIC_EXTERNAL_IPV6_ADDRESS_RANGES';
  public const METRIC_SUBNETWORKS = 'SUBNETWORKS';
  public const METRIC_T2A_CPUS = 'T2A_CPUS';
  public const METRIC_T2D_CPUS = 'T2D_CPUS';
  public const METRIC_TARGET_HTTPS_PROXIES = 'TARGET_HTTPS_PROXIES';
  public const METRIC_TARGET_HTTP_PROXIES = 'TARGET_HTTP_PROXIES';
  public const METRIC_TARGET_INSTANCES = 'TARGET_INSTANCES';
  public const METRIC_TARGET_POOLS = 'TARGET_POOLS';
  public const METRIC_TARGET_SSL_PROXIES = 'TARGET_SSL_PROXIES';
  public const METRIC_TARGET_TCP_PROXIES = 'TARGET_TCP_PROXIES';
  public const METRIC_TARGET_VPN_GATEWAYS = 'TARGET_VPN_GATEWAYS';
  public const METRIC_TPU_LITE_DEVICE_V5 = 'TPU_LITE_DEVICE_V5';
  public const METRIC_TPU_LITE_PODSLICE_V5 = 'TPU_LITE_PODSLICE_V5';
  public const METRIC_TPU_PODSLICE_V4 = 'TPU_PODSLICE_V4';
  public const METRIC_URL_MAPS = 'URL_MAPS';
  public const METRIC_VARIABLE_IPV6_PUBLIC_DELEGATED_PREFIXES = 'VARIABLE_IPV6_PUBLIC_DELEGATED_PREFIXES';
  public const METRIC_VPN_GATEWAYS = 'VPN_GATEWAYS';
  public const METRIC_VPN_TUNNELS = 'VPN_TUNNELS';
  public const METRIC_XPN_SERVICE_PROJECTS = 'XPN_SERVICE_PROJECTS';
  /**
   * [Output Only] Quota limit for this metric.
   *
   * @var 
   */
  public $limit;
  /**
   * [Output Only] Name of the quota metric.
   *
   * @var string
   */
  public $metric;
  /**
   * [Output Only] Owning resource. This is the resource on which this quota is
   * applied.
   *
   * @var string
   */
  public $owner;
  /**
   * [Output Only] Current usage of this metric.
   *
   * @var 
   */
  public $usage;

  public function setLimit($limit)
  {
    $this->limit = $limit;
  }
  public function getLimit()
  {
    return $this->limit;
  }
  /**
   * [Output Only] Name of the quota metric.
   *
   * Accepted values: A2_CPUS, AFFINITY_GROUPS, AUTOSCALERS, BACKEND_BUCKETS,
   * BACKEND_SERVICES, C2D_CPUS, C2_CPUS, C3_CPUS, COMMITMENTS,
   * COMMITTED_A2_CPUS, COMMITTED_C2D_CPUS, COMMITTED_C2_CPUS,
   * COMMITTED_C3_CPUS, COMMITTED_CPUS, COMMITTED_E2_CPUS, COMMITTED_LICENSES,
   * COMMITTED_LOCAL_SSD_TOTAL_GB, COMMITTED_M3_CPUS,
   * COMMITTED_MEMORY_OPTIMIZED_CPUS, COMMITTED_N2A_CPUS, COMMITTED_N2D_CPUS,
   * COMMITTED_N2_CPUS, COMMITTED_NVIDIA_A100_80GB_GPUS,
   * COMMITTED_NVIDIA_A100_GPUS, COMMITTED_NVIDIA_H100_GPUS,
   * COMMITTED_NVIDIA_K80_GPUS, COMMITTED_NVIDIA_L4_GPUS,
   * COMMITTED_NVIDIA_P100_GPUS, COMMITTED_NVIDIA_P4_GPUS,
   * COMMITTED_NVIDIA_T4_GPUS, COMMITTED_NVIDIA_V100_GPUS, COMMITTED_T2A_CPUS,
   * COMMITTED_T2D_CPUS, COMMITTED_Z3_CPUS, CPUS, CPUS_ALL_REGIONS,
   * DISKS_TOTAL_GB, E2_CPUS, EXTERNAL_MANAGED_FORWARDING_RULES,
   * EXTERNAL_NETWORK_LB_FORWARDING_RULES, EXTERNAL_PROTOCOL_FORWARDING_RULES,
   * EXTERNAL_VPN_GATEWAYS, FIREWALLS, FORWARDING_RULES,
   * GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES,
   * GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES,
   * GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES, GLOBAL_INTERNAL_ADDRESSES,
   * GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES,
   * GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES, GPUS_ALL_REGIONS,
   * HDB_TOTAL_GB, HDB_TOTAL_IOPS, HDB_TOTAL_THROUGHPUT, HEALTH_CHECKS, IMAGES,
   * INSTANCES, INSTANCE_GROUPS, INSTANCE_GROUP_MANAGERS, INSTANCE_TEMPLATES,
   * INTERCONNECTS, INTERCONNECT_ATTACHMENTS_PER_REGION,
   * INTERCONNECT_ATTACHMENTS_TOTAL_MBPS, INTERCONNECT_TOTAL_GBPS,
   * INTERNAL_ADDRESSES, INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES,
   * IN_PLACE_SNAPSHOTS, IN_USE_ADDRESSES, IN_USE_BACKUP_SCHEDULES,
   * IN_USE_SNAPSHOT_SCHEDULES, LOCAL_SSD_TOTAL_GB, M1_CPUS, M2_CPUS, M3_CPUS,
   * MACHINE_IMAGES, N2A_CPUS, N2D_CPUS, N2_CPUS, NETWORKS, NETWORK_ATTACHMENTS,
   * NETWORK_ENDPOINT_GROUPS, NETWORK_FIREWALL_POLICIES,
   * NET_LB_SECURITY_POLICIES_PER_REGION,
   * NET_LB_SECURITY_POLICY_RULES_PER_REGION,
   * NET_LB_SECURITY_POLICY_RULE_ATTRIBUTES_PER_REGION, NODE_GROUPS,
   * NODE_TEMPLATES, NVIDIA_A100_80GB_GPUS, NVIDIA_A100_GPUS, NVIDIA_K80_GPUS,
   * NVIDIA_L4_GPUS, NVIDIA_P100_GPUS, NVIDIA_P100_VWS_GPUS, NVIDIA_P4_GPUS,
   * NVIDIA_P4_VWS_GPUS, NVIDIA_T4_GPUS, NVIDIA_T4_VWS_GPUS, NVIDIA_V100_GPUS,
   * PACKET_MIRRORINGS, PD_EXTREME_TOTAL_PROVISIONED_IOPS, PREEMPTIBLE_CPUS,
   * PREEMPTIBLE_LOCAL_SSD_GB, PREEMPTIBLE_NVIDIA_A100_80GB_GPUS,
   * PREEMPTIBLE_NVIDIA_A100_GPUS, PREEMPTIBLE_NVIDIA_H100_GPUS,
   * PREEMPTIBLE_NVIDIA_K80_GPUS, PREEMPTIBLE_NVIDIA_L4_GPUS,
   * PREEMPTIBLE_NVIDIA_P100_GPUS, PREEMPTIBLE_NVIDIA_P100_VWS_GPUS,
   * PREEMPTIBLE_NVIDIA_P4_GPUS, PREEMPTIBLE_NVIDIA_P4_VWS_GPUS,
   * PREEMPTIBLE_NVIDIA_T4_GPUS, PREEMPTIBLE_NVIDIA_T4_VWS_GPUS,
   * PREEMPTIBLE_NVIDIA_V100_GPUS, PREEMPTIBLE_TPU_LITE_DEVICE_V5,
   * PREEMPTIBLE_TPU_LITE_PODSLICE_V5, PREEMPTIBLE_TPU_PODSLICE_V4,
   * PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK,
   * PSC_INTERNAL_LB_FORWARDING_RULES, PUBLIC_ADVERTISED_PREFIXES,
   * PUBLIC_DELEGATED_PREFIXES, REGIONAL_AUTOSCALERS,
   * REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES,
   * REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES,
   * REGIONAL_INSTANCE_GROUP_MANAGERS, REGIONAL_INTERNAL_LB_BACKEND_SERVICES,
   * REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES,
   * REGIONAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES, RESERVATIONS,
   * RESOURCE_POLICIES, ROUTERS, ROUTES, SECURITY_POLICIES,
   * SECURITY_POLICIES_PER_REGION, SECURITY_POLICY_ADVANCED_RULES_PER_REGION,
   * SECURITY_POLICY_CEVAL_RULES, SECURITY_POLICY_RULES,
   * SECURITY_POLICY_RULES_PER_REGION, SERVICE_ATTACHMENTS, SNAPSHOTS,
   * SSD_TOTAL_GB, SSL_CERTIFICATES, SSL_POLICIES, STATIC_ADDRESSES,
   * STATIC_BYOIP_ADDRESSES, STATIC_EXTERNAL_IPV6_ADDRESS_RANGES, SUBNETWORKS,
   * T2A_CPUS, T2D_CPUS, TARGET_HTTPS_PROXIES, TARGET_HTTP_PROXIES,
   * TARGET_INSTANCES, TARGET_POOLS, TARGET_SSL_PROXIES, TARGET_TCP_PROXIES,
   * TARGET_VPN_GATEWAYS, TPU_LITE_DEVICE_V5, TPU_LITE_PODSLICE_V5,
   * TPU_PODSLICE_V4, URL_MAPS, VARIABLE_IPV6_PUBLIC_DELEGATED_PREFIXES,
   * VPN_GATEWAYS, VPN_TUNNELS, XPN_SERVICE_PROJECTS
   *
   * @param self::METRIC_* $metric
   */
  public function setMetric($metric)
  {
    $this->metric = $metric;
  }
  /**
   * @return self::METRIC_*
   */
  public function getMetric()
  {
    return $this->metric;
  }
  /**
   * [Output Only] Owning resource. This is the resource on which this quota is
   * applied.
   *
   * @param string $owner
   */
  public function setOwner($owner)
  {
    $this->owner = $owner;
  }
  /**
   * @return string
   */
  public function getOwner()
  {
    return $this->owner;
  }
  public function setUsage($usage)
  {
    $this->usage = $usage;
  }
  public function getUsage()
  {
    return $this->usage;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Quota::class, 'Google_Service_Compute_Quota');
