<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class InventorySourceGroupAssignedTargetingOptionDetails extends \Google\Model
{
  /**
   * Required. ID of the inventory source group. Should refer to the
   * inventory_source_group_id field of an InventorySourceGroup resource.
   *
   * @var string
   */
  public $inventorySourceGroupId;

  /**
   * Required. ID of the inventory source group. Should refer to the
   * inventory_source_group_id field of an InventorySourceGroup resource.
   *
   * @param string $inventorySourceGroupId
   */
  public function setInventorySourceGroupId($inventorySourceGroupId)
  {
    $this->inventorySourceGroupId = $inventorySourceGroupId;
  }
  /**
   * @return string
   */
  public function getInventorySourceGroupId()
  {
    return $this->inventorySourceGroupId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InventorySourceGroupAssignedTargetingOptionDetails::class, 'Google_Service_DisplayVideo_InventorySourceGroupAssignedTargetingOptionDetails');
