<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SaaSServiceManagement;

class Release extends \Google\Collection
{
  protected $collection_key = 'outputVariables';
  /**
   * Optional. Annotations is an unstructured key-value map stored with a
   * resource that may be set by external tools to store and retrieve arbitrary
   * metadata. They are not queryable and should be preserved when modifying
   * objects. More info: https://kubernetes.io/docs/user-guide/annotations
   *
   * @var string[]
   */
  public $annotations;
  protected $blueprintType = Blueprint::class;
  protected $blueprintDataType = '';
  /**
   * Output only. The timestamp when the resource was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @var string
   */
  public $etag;
  protected $inputVariableDefaultsType = UnitVariable::class;
  protected $inputVariableDefaultsDataType = 'array';
  protected $inputVariablesType = UnitVariable::class;
  protected $inputVariablesDataType = 'array';
  /**
   * Optional. The labels on the resource, which can be used for categorization.
   * similar to Kubernetes resource labels.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Identifier. The resource name (full URI of the resource) following the
   * standard naming scheme:
   * "projects/{project}/locations/{location}/releases/{release}"
   *
   * @var string
   */
  public $name;
  protected $outputVariablesType = UnitVariable::class;
  protected $outputVariablesDataType = 'array';
  protected $releaseRequirementsType = ReleaseRequirements::class;
  protected $releaseRequirementsDataType = '';
  /**
   * Output only. The unique identifier of the resource. UID is unique in the
   * time and space for this resource within the scope of the service. It is
   * typically generated by the server on successful creation of a resource and
   * must not be changed. UID is used to uniquely identify resources with
   * resource name reuses. This should be a UUID4.
   *
   * @var string
   */
  public $uid;
  /**
   * Required. Immutable. Reference to the UnitKind this Release corresponds to
   * (required and immutable once created).
   *
   * @var string
   */
  public $unitKind;
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Optional. Annotations is an unstructured key-value map stored with a
   * resource that may be set by external tools to store and retrieve arbitrary
   * metadata. They are not queryable and should be preserved when modifying
   * objects. More info: https://kubernetes.io/docs/user-guide/annotations
   *
   * @param string[] $annotations
   */
  public function setAnnotations($annotations)
  {
    $this->annotations = $annotations;
  }
  /**
   * @return string[]
   */
  public function getAnnotations()
  {
    return $this->annotations;
  }
  /**
   * Optional. Blueprints are OCI Images that contain all of the artifacts
   * needed to provision a unit.
   *
   * @param Blueprint $blueprint
   */
  public function setBlueprint(Blueprint $blueprint)
  {
    $this->blueprint = $blueprint;
  }
  /**
   * @return Blueprint
   */
  public function getBlueprint()
  {
    return $this->blueprint;
  }
  /**
   * Output only. The timestamp when the resource was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Optional. Mapping of input variables to default values. Maximum 100
   *
   * @param UnitVariable[] $inputVariableDefaults
   */
  public function setInputVariableDefaults($inputVariableDefaults)
  {
    $this->inputVariableDefaults = $inputVariableDefaults;
  }
  /**
   * @return UnitVariable[]
   */
  public function getInputVariableDefaults()
  {
    return $this->inputVariableDefaults;
  }
  /**
   * Optional. Output only. List of input variables declared on the blueprint
   * and can be present with their values on the unit spec
   *
   * @param UnitVariable[] $inputVariables
   */
  public function setInputVariables($inputVariables)
  {
    $this->inputVariables = $inputVariables;
  }
  /**
   * @return UnitVariable[]
   */
  public function getInputVariables()
  {
    return $this->inputVariables;
  }
  /**
   * Optional. The labels on the resource, which can be used for categorization.
   * similar to Kubernetes resource labels.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Identifier. The resource name (full URI of the resource) following the
   * standard naming scheme:
   * "projects/{project}/locations/{location}/releases/{release}"
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. Output only. List of output variables declared on the blueprint
   * and can be present with their values on the unit status
   *
   * @param UnitVariable[] $outputVariables
   */
  public function setOutputVariables($outputVariables)
  {
    $this->outputVariables = $outputVariables;
  }
  /**
   * @return UnitVariable[]
   */
  public function getOutputVariables()
  {
    return $this->outputVariables;
  }
  /**
   * Optional. Set of requirements to be fulfilled on the Unit when using this
   * Release.
   *
   * @param ReleaseRequirements $releaseRequirements
   */
  public function setReleaseRequirements(ReleaseRequirements $releaseRequirements)
  {
    $this->releaseRequirements = $releaseRequirements;
  }
  /**
   * @return ReleaseRequirements
   */
  public function getReleaseRequirements()
  {
    return $this->releaseRequirements;
  }
  /**
   * Output only. The unique identifier of the resource. UID is unique in the
   * time and space for this resource within the scope of the service. It is
   * typically generated by the server on successful creation of a resource and
   * must not be changed. UID is used to uniquely identify resources with
   * resource name reuses. This should be a UUID4.
   *
   * @param string $uid
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * Required. Immutable. Reference to the UnitKind this Release corresponds to
   * (required and immutable once created).
   *
   * @param string $unitKind
   */
  public function setUnitKind($unitKind)
  {
    $this->unitKind = $unitKind;
  }
  /**
   * @return string
   */
  public function getUnitKind()
  {
    return $this->unitKind;
  }
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Release::class, 'Google_Service_SaaSServiceManagement_Release');
