<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Setting;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use JWTAuth;
use JWTException;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Validator;

class ApiLoginController extends Controller
{
    // public function login(Request $request)
    // {
    //     return $request;
    // }
    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['login', 'signup','forgotVerifyRequest','forgotVerifyOTP','forgotChangePassword','authWithGoogle','testPushNotification','authWithApple']]);
    }

    public function login(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email',
            'password' => 'required|string',
        ]);
 
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $isExist = User::where("email",$request->email)->first();
        if(empty($isExist)){
            return response()->json([
                "status"=>"error",
                'message' => 'Email address not registered with us. Signup now',
            ], 200);
        }
        if (!Hash::check($request->password, $isExist->password))
        {
            return response()->json([
                "status"=>"error",
                'message' => 'Wrong Password',
            ], 200);
        }
        if(empty($isExist->email_verified_at)){
            $encEmail = Crypt::encrypt($request->email);
            $html = route('email_verify',['email'=>$encEmail]);
            $e_mail = globalMail($request->name,$request->email,"Email Verification",$html);
            if(!$e_mail){
                return response()->json([
                    "status"=>"error",
                    'message' => 'Verification email sent on your registed email verify now.'
                ]);
            } 
        }
        if($isExist->status==0){
            return response()->json([
                "status"=>"error",
                'message' => 'Unauthorized for login',
            ], 200);
        }

        $credentials = $request->only('email', 'password');

        if (! $token = JWTAuth::attempt($credentials)) {
            return response()->json([
                "status"=>"error",
                'message' => 'Unauthorized',
            ], 401);
        }

        $user = Auth::user();
        if(empty($user->dob)){
            $is_first = true;
            $msg = "Welcome, Setup Profile";
        } else {
            $is_first = false;
            $msg = "Login Successfully";
        }
        $user->image = asset('ftj/storage/users')."/default.jpg"; 
        return response()->json([
            "status"=>"success",
            'message' => $msg,
            'user' => $user,
            'is_first'=>$is_first,
            "is_production"=>(boolean)Setting::where('name','is_production')->first()->value??false,
            "is_plans_activate"=>(boolean)Setting::where('name','is_plans_activate')->first()->value??false,
            "android_paid"=>(boolean)Setting::where('name','android_paid')->first()->value??false,
            "ios_paid"=>(boolean)Setting::where('name','ios_paid')->first()->value??false,
            'authorization' => [
                'token' => $token,
                'type' => 'bearer',
            ]
        ]);
    }

    public function signup(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'phone' => 'required',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6',
        ]);
 
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'role'=>'appuser',
            'password' => Hash::make($request->password),
        ]);
        $encEmail = Crypt::encrypt($request->email);
        $html = route('email_verify',['email'=>$encEmail]);
        $e_mail = globalMail($request->name,$request->email,"Email Verification",$html);
        if(!$e_mail){
            return response()->json([
                "status"=>"error",
                'message' => 'Signup pending, Something went wrong When send verification email.'
            ]);
        } 
        return response()->json([
            "status"=>"success",
            'message' => 'Signup pending. Verification email sent on your registed email. Please check & verify to start health journy',
            'user' => $user
        ]);
    }

    public function logout()
    {
        Auth::logout();
        return response()->json([
            "status"=>"success",
            'message' => 'Successfully logged out',
        ]);
    }

    public function refresh()
    {
        return response()->json([
            "status"=>"success",
            'message' => 'Token Refresh Successfully',
            'user' => Auth::user(),
            'authorisation' => [
                'token' => Auth::refresh(),
                'type' => 'bearer',
            ]
        ]);
    }

    public function forgotVerifyRequest(Request $request)
    {
        $email = $request->email;
        if(empty($email)){
            return response()->json(['status'=>'error','message'=>'Email address required','otp'=>false]);
        }
        $user = User::where('email',$email)->first();
        if(!empty($user->forgot_token) && !$request->has('resent')){
            return response()->json(['status'=>'error','message'=>'Verification email address already sent.','otp'=>null]);
        }
        if(!empty($user)){
            $otp = rand(1564,9999);
            $forgot_token = Crypt::encrypt($otp);
            $user->forgot_token = $forgot_token;
            $html = view('mail.email_otp',compact('otp'))->render();

            $e_mail = globalMail($request->name,$request->email,"Forgot Password Verification",$html);
            if(!$e_mail){
                return response()->json([
                    "status"=>"error",
                    'message' => 'Something went wrong when send otp verification email.'
                ]);
            } 
            $user->save();
            return response()->json(['status'=>'success','message'=>'OTP sent to email address.','otp'=>true]);
        }
        return response()->json(['status'=>'error','message'=>'Email not registred with us.','otp'=>false]);
    }

    public function forgotVerifyOTP(Request $request)
    {
        $email = $request->email;
        if(empty($email)){
            return response()->json(['status'=>'error','message'=>'Email address required']);
        }
        $otp = $request->otp;
        if(empty($otp)){
            return response()->json(['status'=>'error','message'=>'OTP required']);
        }
        $user = User::where('email',$email)->first();
        if(empty($user->forgot_token)){
            return response()->json(['status'=>'error','message'=>'Verification otp not sent yet..']);
        }
        $forgot_token = Crypt::decrypt($user->forgot_token);
        if($forgot_token==$otp){
            return response()->json(['status'=>'success','message'=>'OTP verified']);
        }
        return response()->json(['status'=>'error','message'=>'OTP invalid']);
    }

    public function forgotChangePassword(Request $request)
    {
        $email = $request->email;
        if(empty($email)){
            return response()->json(['status'=>'error','message'=>'Email address required']);
        }
        $otp = $request->otp;
        if(empty($otp)){
            return response()->json(['status'=>'error','message'=>'OTP required']);
        }
        $user = User::where('email',$email)->first();
        if(empty($user->forgot_token)){
            return response()->json(['status'=>'error','message'=>'Verification otp not sent yet..']);
        }
        $forgot_token = Crypt::decrypt($user->forgot_token);
        if($forgot_token==$otp){
            $new_password = Hash::make($request->password);
            $user->password = $new_password;
            $user->forgot_token = null;
            $user->save();
            return response()->json(['status'=>'success','message'=>'Password Changed. Login Now']);
        }
        return response()->json(['status'=>'error','message'=>'OTP invalid']);
    }

    public function authWithGoogle(Request $request)
    {
       
        $validator = Validator::make($request->all(), [
            'auth_code' => 'required'
        ]);
 
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $isExist = User::where("auth_code",$request->auth_code)->first();
        if(empty($isExist)){
            return response()->json([
                "status"=>"wait",
                'message' => 'Not Found',
            ], 200);
        }
        
        if($isExist->status==0){
            return response()->json([
                "status"=>"error",
                'message' => 'Unauthorized for login',
            ], 200);
        }

        if($token = JWTAuth::fromUser($isExist)){
            // $user = Auth::user();
            if(empty($isExist->dob)){
                $is_first = true;
                $msg = "Welcome, Setup Profile";
            } else {
                $is_first = false;
                $msg = "Login Successfully";
            }
           
            $isExist->auth_google = null;
            $isExist->auth_code = null;
            $isExist->save();
            $isExist->image = asset('ftj/storage/users')."/default.jpg"; 
            return response()->json([
                "status"=>"success",
                'message' => $msg,
                'user' => $isExist,
                'is_first'=>$is_first,
                "is_production"=>(boolean)Setting::where('name','is_production')->first()->value??false,
                "is_plans_activate"=>(boolean)Setting::where('name','is_plans_activate')->first()->value??false,
                "android_paid"=>(boolean)Setting::where('name','android_paid')->first()->value??false,
                "ios_paid"=>(boolean)Setting::where('name','ios_paid')->first()->value??false,
                'authorization' => [
                    'token' => $token,
                    'type' => 'bearer',
                ]
            ]);
        }

        return response()->json([
            "status"=>"error",
            'message' => 'Something went wrong!',
        ], 401);
        
    }


    public function authWithApple(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'apple_client_id' => 'required'
        ]);
 
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $isExist = User::where("apple_client_id",$request->apple_client_id)->first();
        if(empty($isExist)){
            $user_inv = [
                'name' => $request->name,
                'email' => $request->email,
                'role'=>'appuser',
                'apple_client_id'=>$request->apple_client_id,
                'apple_auth_token'=>$request->apple_auth_token,
                'apple_ref'=>$request->apple_ref,
                'password'=>Hash::make(rand(12546,99999))
            ];  
            $user = User::create($user_inv);
            if($token = JWTAuth::fromUser($user)){
                // $user = Auth::user();
                if(empty($isExist->dob)){
                    $is_first = true;
                    $msg = "Welcome, Setup Profile";
                } else {
                    $is_first = false;
                    $msg = "Login Successfully";
                }
            
                $user->image = asset('ftj/storage/users')."/default.jpg"; 
                return response()->json([
                    "status"=>"success",
                    'message' => $msg,
                    'user' => $user,
                    'is_first'=>$is_first,
                    "is_production"=>(boolean)Setting::where('name','is_production')->first()->value??false,
                    "is_plans_activate"=>(boolean)Setting::where('name','is_plans_activate')->first()->value??false,
                    "android_paid"=>(boolean)Setting::where('name','android_paid')->first()->value??false,
                    "ios_paid"=>(boolean)Setting::where('name','ios_paid')->first()->value??false,
                    'authorization' => [
                        'token' => $token,
                        'type' => 'bearer',
                    ]
                ]);
            }

            return response()->json([
                "status"=>"error",
                'message' => 'Something went wrong!',
            ], 401);
        }
        
        if($isExist->status==0){
            return response()->json([
                "status"=>"error",
                'message' => 'Unauthorized for login',
            ], 200);
        }

        if($token = JWTAuth::fromUser($isExist)){
            // $user = Auth::user();
            if(empty($isExist->dob)){
                $is_first = true;
                $msg = "Welcome, Setup Profile";
            } else {
                $is_first = false;
                $msg = "Login Successfully";
            }
           
            $isExist->image = asset('ftj/storage/users')."/default.jpg"; 
            return response()->json([
                "status"=>"success",
                'message' => $msg,
                'user' => $isExist,
                'is_first'=>$is_first,
                "is_production"=>(boolean)Setting::where('name','is_production')->first()->value??false,
                "is_plans_activate"=>(boolean)Setting::where('name','is_plans_activate')->first()->value??false,
                "android_paid"=>(boolean)Setting::where('name','android_paid')->first()->value??false,
                "ios_paid"=>(boolean)Setting::where('name','ios_paid')->first()->value??false,
                'authorization' => [
                    'token' => $token,
                    'type' => 'bearer',
                ]
            ]);
        }

        return response()->json([
            "status"=>"error",
            'message' => 'Something went wrong!',
        ], 401);
    }

    public function testPushNotification()
        {
           echo 'enter';

             
        }

}
