<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Slide;
use App\Models\Language;
use App\Models\Plan;
use App\Models\ExerciseVideoCategory;
use App\Models\MyReminder;
use App\Models\ExerciseVideos;
use App\Models\MealPicture;
use Illuminate\Support\Facades\Hash;
use App\Models\CallRequest;
use App\Models\ConsultationQuery;
use App\Models\WeeklyUpdateForm;
use App\Models\WeeklyUpdate;
use App\Models\WeightLog;
use App\Models\Meditation;
use App\Models\HelpSupport;
use App\Models\InfoContact;
use App\Models\Country;
use App\Models\City;
use App\Models\State;
use App\Models\User;
use App\Models\Chat;
use App\Models\UserTrainee;
use App\Models\WorkoutDay;
use App\Models\WorkoutPlan;
use App\Models\WorkoutPlanDay;
use App\Models\UserWorkout;
use App\Models\WorkoutLog;
use App\Models\RecipeList;
use App\Models\MeditationCategories;
use App\Models\MeditationList;
use App\Models\Setting;
use App\Models\FormBuilderWorkout;
use App\Models\FormBuilderUpload;
use App\Models\BodyMeasurment;
use App\Models\Physique;
use App\Models\UserFavRecipe;
use App\Models\Notification;
use App\Models\UserRecipeList;
use App\Models\MeditationDeepSleep;
use App\Models\RequestPremium;
use App\Models\RecipeIngredient;
use App\Models\RecipeGuideList;
use App\Models\RecipeCategories;
use App\Models\RecipeLog;
use App\Models\RecipeLogList;
use App\Models\ExerciseMachine;
use App\Models\CustomUpdates;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Str;
use DB;
use Illuminate\Support\Facades\DB as FacadesDB;

class ApiMainController extends Controller
{

    public function __construct()
    {
        date_default_timezone_set("Asia/Kolkata");
        // $this->middleware('auth:api', ['except' => ['login', 'signup']]);
    }



    public function setprofile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'gender' => 'required',
            'dob' => 'required',
            'height' => 'required',
            'weight' => 'required',
            'goal' => 'required',
            'activity_level' => 'required',
            'location' => 'required',
            'language' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $user = User::where('id', Auth::user()->id)->first();
        $user->gender = $request->gender;
        $user->dob = $request->dob;
        $user->height = $request->height;
        $user->weight = $request->weight;
        $user->goal = $request->goal;
        $user->activity_level = $request->activity_level;
        $user->location = $request->location;
        $user->language = $request->language;
        if ($user->save()) {
            return response()->json([
                "status" => "success",
                'message' => 'User profile updated',
                'user' => $user,
                "is_production" => (boolean) Setting::where('name', 'is_production')->first()->value ?? false,
                "is_plans_activate" => (boolean) Setting::where('name', 'is_plans_activate')->first()->value ?? false,
                "android_paid" => (boolean) Setting::where('name', 'android_paid')->first()->value ?? false,
                "ios_paid" => (boolean) Setting::where('name', 'ios_paid')->first()->value ?? false,
            ]);
        }
        return response()->json([
            "status" => "error",
            'message' => 'Something went wrong!'
        ]);
    }

    //Dashboard
    public function Dashboard(Request $request)
    {
        $slides = Slide::active()->orderBy('id', 'desc')->limit(3)->get();
        foreach ($slides as $list) {
            $list->file_path = asset('ftj/storage/appslides') . "/" . $list->file_path;
        }
        $user = $request->user();
        // $user->image = asset('ftj/storage/users')."/default.jpg"; 
        $date = date('Y-m-d');
        if ($request->has('date')) {
            $date = date('Y-m-d', strtotime($request->date));
        }
        $is_meal_picture_uploaded_in_24h = MealPicture::where('user_id', $user->id)->where('date', date('Y-m-d', strtotime('now')))->exists();
        $res = [
            "user" => $user,
            "slides" => $slides,
            "languages" => Language::active()->get(),
            "plans" => Plan::active()->get(),
            "reminders" => MyReminder::active()->user()->get(),
            "is_production" => (boolean) Setting::where('name', 'is_production')->first()->value ?? false,
            "is_plans_activate" => (boolean) Setting::where('name', 'is_plans_activate')->first()->value ?? false,
            "android_paid" => (boolean) Setting::where('name', 'android_paid')->first()->value ?? false,
            "ios_paid" => (boolean) Setting::where('name', 'ios_paid')->first()->value ?? false,
            'today_calories' => getUserCalories($date, $user->id),
            'meal_picture_in_24h' => $is_meal_picture_uploaded_in_24h
        ];
        return response()->json($res);
    }

    //Calculators 
    public function bmrCalc(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'age' => 'required',
            'feet' => 'required',
            'inches' => 'required',
            'weight' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $age = $request->age;
        $feet = $request->feet;
        $inches = $request->inches;
        $weight = $request->weight;
        $exercise = (floatval($request->exercise) ?? 0);


        $totalheight = ($inches + ($feet * 12)) * 2.54;
        $answer = 5 + (((10 * $weight) + (6.25 * $totalheight)) - (5 * $age));
        if ($exercise > 0) {
            $answer = $answer * $exercise;
        }
        return response()->json(round($answer));
    }

    public function calorieCalc(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'age' => 'required',
            'feet' => 'required',
            'inches' => 'required',
            'weight' => 'required',
            'gender' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $age = $request->age;
        $feet = $request->feet;
        $inches = $request->inches;
        $weight = $request->weight;
        $gender = $request->gender;
        $calories = "0.0215183";
        $totalheight = $inches + ($feet * 12);
        $res = array();
        switch ($gender) {
            case 'female':
                $gender = 655 + (9.6 * $weight) + (1.8 * $totalheight) - (4.7 * $age);
                array_push($res, [
                    "<p>Your estimated daily metabolic rate is $gender </p>",
                    "<p>This means that you need rouhgly $gender calories a day to maintain your current weight.</p>"
                ]);

                break;
            case 'male':
                $gender = 66 + (13.7 * $weight) + (5 * $totalheight) - (6.8 * $age);
                array_push($res, [
                    "<p>Your estimated daily metabolic rate is $gender </p>",
                    "<p>This means that you need rouhgly $gender calories a day to maintain your current weight.</p>"
                ]);

        }
        return response()->json(round($gender));
    }



    //Exercise Videos
    public function videoCategories(Request $request)
    {
        $catQry = ExerciseVideoCategory::active();
        if ($request->has('search')) {
            $catQry->where('name', 'like', '%' . $request->search . '%');
        }
        $cat = $catQry->paginate(10);
        foreach ($cat as $list) {
            $list->image = env('APP_URL_STR') . 'exercise_cats/' . $list->image;
            $list->videos_count = ExerciseVideos::where('exercise_video_categories_id', $list->id)->count();
            $list->tags = 'Beginner';
        }
        return response()->json($cat);
    }

    public function exerciseVideos(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'uuid' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $is_exist = ExerciseVideoCategory::where('uuid', $request->uuid)->first();
        if (!empty($is_exist)) {
            $vidQry = ExerciseVideos::where('status', 1)->where('exercise_video_categories_id', $is_exist->id);
            if ($request->has('search')) {
                $vidQry->where('name', 'like', '%' . $request->search . '%');
            }
            $vid = $vidQry->paginate(10);
            foreach ($vid as $list) {
                $list->thumbnail_image = env('APP_URL_STR') . 'exercise_vid_thumb/' . $list->thumbnail_image;
                $list->cat_name = $is_exist->name;
                // $list->tags = 'Beginner';
            }
            return response()->json($vid);
        }
        return response()->json(['message' => 'Exercise video category is not exist!'], 400);
    }

    // Get Plans
    public function browsePlans(Request $request)
    {
        $plans = Plan::active()->get();
        // foreach($plans as $list)
        // {
        //     $list->permissions = json_decode($list->permissions);
        //     $list->features = json_decode($list->features);
        // }
        return response()->json($plans);
    }

    public function activatePlan(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'plan_id' => 'required',
            'payment_id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user();
        if (!empty($user->plan_id)) {
            return response()->json(["status" => "error", "message" => "Another Plan Already Activated."], 200);
        }
        $plan = Plan::where('id', $request->plan_id)->first();
        if ($plan->amount == 0) {
            $user->plan_id = $request->plan_id;
            $user->gateway_ref = json_encode(array(
                'start' => date('Y-m-d', strtotime('now')),
                'end' => date('Y-m-d', strtotime('+' . $plan->days . ' Days'))
            ));
            if ($user->save()) {
                return response()->json(["status" => "success", "message" => "Free Plan Activate Successfully", 'user' => $user], 200);
            }
            return response()->json(["status" => "error", "message" => "Please Contact Support Team"], 200);
        }
        $user->is_subscription = 1;
        $user->plan_id = $request->plan_id;
        $user->gateway_plan_id = $request->payment_id;
        $user->gateway_ref = json_encode(array(
            'start' => date('Y-m-d', strtotime('now')),
            'end' => date('Y-m-d', strtotime('+' . $plan->days . ' Days'))
        ));
        if ($user->save()) {
            return response()->json(["status" => "success", "message" => "Plan Activate Successfully", 'user' => $user], 200);
        }
        return response()->json(["status" => "error", "message" => "Please Contact Support Team"], 200);
    }

    //Manage Meal Picture
    public function missedMeals(Request $request)
    {
        $user = Auth::user()->id;
        $missedDays = array();
        for ($i = 0; $i <= 6; $i++) {
            $day = '-' . $i . ' days';
            $mDate = date('d M Y', strtotime($day));
            $missed = MealPicture::where('user_id', $user)->where('date', date('Y-m-d', strtotime($day)))->whereIsActive(1)->exists();
            if (!$missed) {
                array_push($missedDays, array('date' => $mDate, 'is_missed' => $missed));
            }

        }

        return response()->json(['missed_days' => $missedDays]);
    }

    public function mealHistory(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'to_date' => 'required',
            'from_date' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user()->id;
        $history = MealPicture::where('user_id', $user)->whereBetween('date', [date('Y-m-d', strtotime($request->from_date)), date('Y-m-d', strtotime($request->to_date))])->whereIsActive(1)->get();

        return response()->json($history);
    }

    public function uploadMealPicture(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'meal_picture' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user()->id;
        $existed = MealPicture::where('user_id', $user)->where('date', date('Y-m-d'))->whereIsActive(1)->get();
        if (count($existed) >= 10) {
            return response()->json(["status" => "error", "message" => "Today's Maximum Meal Picture Already Uploaded"]);
        }
        // $file = file_get_contents($request->meal_picture);
        // $safeName = $user.strtotime('now').'.'.'png';
        // $success = file_put_contents(storage_path().'/meal_pictures/'.$safeName, $file);
        $fileName = '';
        if (!empty($request->meal_picture)) {
            ob_start();
            $fileName = md5(time()) . ".png";
            $filepath = storage_path() . '/meal_pictures' . '/' . $fileName;
            $blob = "data:image/png;base64," . $request->meal_picture;
            $blob = file_get_contents($blob);
            $fh = fopen($filepath, 'w');
            fwrite($fh, $blob);
            fclose($fh);
            ob_flush();
        }
        if ($fileName == '') {
            return response()->json([
                "status" => "error",
                "message" => "Something went wrong!"
            ], 200);
        }
        // print $success;
        MealPicture::insert([
            "user_id" => $user,
            "file_path" => $fileName,
            "date" => date('Y-m-d'),
            "description" => $request->description
        ]);
        return response()->json(["status" => "success", "message" => "Meal Picture Uploaded Successfully"]);
    }

    public function retakeMealPicture(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'image_file' => 'required',
            'ref_id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user()->id;
        $existed = MealPicture::where('user_id', $user)->where('id', $request->ref_id)->whereNeedRetake(1)->whereIsActive(1)->exists();
        if ($existed) {
            $meal_detail = MealPicture::where('user_id', $user)->where('id', $request->ref_id)->whereNeedRetake(1)->whereIsActive(1)->first();
            $file = file_get_contents($request->image_file);
            $safeName = $user . strtotime('now') . '.' . 'png';
            $success = file_put_contents(storage_path() . '/meal_pictures/' . $safeName, $file);
            $meal_detail->file_path = $safeName;
            $meal_detail->need_retake = 0;
            if ($meal_detail->save()) {
                return response()->json(["status" => "success", "message" => "Meal Picture Re-Uploaded Successfully"]);
            }
            return response()->json(["status" => "success", "message" => "Error in uploading document"]);
        }
        return response()->json(["status" => "error", "message" => "Re-Upload not available!"]);
    }

    // Manage Requests
    public function requestACallBook(Request $request)
    {
        $user = Auth::user()->id;
        $is_exist = CallRequest::where('user_id', $user)->whereStatus(1)->exists();
        if ($is_exist) {
            return response()->json(["status" => "error", "message" => "Already Existed Call Request"], 400);
        }
        CallRequest::insert(["user_id" => $user, "message" => '']);
        return response()->json(["status" => "success", "message" => "Call Request Added"]);
    }

    public function consultationQuerySend(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'subject' => 'required',
            'message' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user()->id;
        ConsultationQuery::insert([
            "user_id" => $user,
            "subject" => $request->subject,
            "message" => $request->message
        ]);
        return response()->json(["status" => "success", "message" => "Query Submitted"]);
    }

    public function requestHistory(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'request_for' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user()->id;
        if ($request->request_for == "consultation") {
            $consultation = ConsultationQuery::where('user_id', $user)->paginate();
            return response()->json($consultation);
        }
        if ($request->request_for == "callrequest") {
            $callrequest = CallRequest::where('user_id', $user)->whereStatus(1)->paginate();
            return response()->json($callrequest);
        }
        return response()->json(["status" => "error", "message" => "Wrong Request Type"], 400);
    }

    public function weeklyUpdateForm(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'follow_diet' => 'required',
            'follow_traning' => 'required',
            'goal_achieve' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $user = Auth::user()->id;
        $between = $this->x_week_range2(date('Y-m-d'));
        $is_exist = WeeklyUpdateForm::where('user_id', $user)->whereBetween('date', $between)->exists();

        if ($is_exist) {
            return response()->json(["status" => "error", "message" => "Already updated for week " . date('d M Y', strtotime($between[0])) . ' To ' . date('d M Y', strtotime($between[1]))], 200);
        }

        WeeklyUpdateForm::insert([
            "follow_diet" => $request->follow_diet,
            "follow_traning" => $request->follow_traning,
            "heaviest_set" => $request->goal_achieve,
            "face_issue" => "null",
            "user_id" => $user,
            "date" => date('Y-m-d', strtotime('now'))
        ]);

        return response()->json(["status" => "success", "message" => date('d M Y', strtotime($between[0])) . ' To ' . date('d M Y', strtotime($between[1])) . " Form Update Successfully"], 200);
    }

    public function weeklyUpdateFormV2(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'describe_diet' => 'required',
            'describe_workout' => 'required',
            'suggestion' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $user = Auth::user()->id;
        $between = $this->x_week_range2(date('Y-m-d'));
        $is_exist = WeeklyUpdate::where('user_id', $user)->whereBetween('date', $between)->exists();

        if ($is_exist) {
            return response()->json(["status" => "error", "message" => "Already updated for week " . date('d M Y', strtotime($between[0])) . ' To ' . date('d M Y', strtotime($between[1]))], 200);
        }

        WeeklyUpdate::insert([
            "descibe_diet" => $request->describe_diet,
            "describe_workout" => $request->describe_workout,
            "suggestion" => $request->suggestion,
            "weight" => $request->weight,
            "user_id" => $user,
            "date" => date('Y-m-d', strtotime('now'))
        ]);

        WeightLog::insert([
            "weight" => $request->weight,
            "user_id" => $user,
            "date" => date('Y-m-d', strtotime('now'))
        ]);

        return response()->json(["status" => "success", "message" => date('d M Y', strtotime($between[0])) . ' To ' . date('d M Y', strtotime($between[1])) . " Form Update Successfully"], 200);
    }

    public function updateWeight(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'value' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user();
        $user->weight = (string) $request->value . "_kg";
        $user->save();
        WeightLog::insert([
            "weight" => $request->value,
            "user_id" => $user->id,
            "date" => date('Y-m-d', strtotime('now'))
        ]);
        return response()->json(["status" => "success", "message" => " Weight Update Successfully"], 200);
    }

    public function dietFollowWeeklySts(Request $request)
    {
        $currentDateTo = date('Y-m-d');
        if (!empty($request->date)) {
            $currentDateTo = date('Y-m-d', strtotime($request->date ?? 'now'));
        }
        $loggdinUser = Auth::user();
        $between = $this->x_week_range2($currentDateTo);
        //Days Count
        $diet_logs = MealPicture::whereBetween('date', $between)->where('user_id', $loggdinUser->id)->where('is_approved', 1)->distinct('date')->count();
        $total_days = ((strtotime($between[1]) - strtotime($between[0])) / 86400) + 1;
        //Total Stars
        $diet_sum = 0;
        for ($dt = 0; $dt < $total_days; $dt++) {
            $date_d = date('Y-m-d', strtotime("+" . $dt . " days", strtotime($between[0])));
            $day_stars = MealPicture::where('date', $date_d)->where('user_id', $loggdinUser->id)->where('is_approved', 1)->sum('star');
            if ($day_stars < 15) {
                $diet_sum += $day_stars;
            } else {
                $diet_sum += 15;
            }
        }
        // $diet_count = MealPicture::whereBetween('date',$between)->where('user_id',$loggdinUser->id)->where('is_approved',1)->count();

        $diet_count = $total_days * 15;
        $diet_count = $diet_count == 0 ? 100 : $diet_count;

        $custom_updates_diet = CustomUpdates::whereBetween('date', $between)->where('type', 'diet')->where('user_id', $loggdinUser->id)->first();
        if (!empty($custom_updates_diet)) {
            $diet_follow = [
                "follow_days" => $diet_logs,
                "not_follow" => ($total_days - $diet_logs),
                "follow_percent" => $custom_updates_diet->value,//round(($diet_logs/$total_days)*100),
                "not_follow_percent" => ($custom_updates_diet->value - 100),//round((($total_days-$diet_logs)/$total_days)*100),
                "graph" => route('getChart', ['title' => "Diet Follow", "start" => round(($diet_logs / $total_days) * 100), "end" => round((($total_days - $diet_logs) / $total_days) * 100)])
            ];
        } else {
            $diet_follow = [
                "follow_days" => $diet_logs,
                "not_follow" => ($total_days - $diet_logs),
                "follow_percent" => round(($diet_count > 0 ? ($diet_sum / $diet_count) : 0) * 100),//round(($diet_logs/$total_days)*100),
                "not_follow_percent" => (round(($diet_count > 0 ? (($diet_count - $diet_sum) / $diet_count) : 0) * 100)),//round((($total_days-$diet_logs)/$total_days)*100),
                "graph" => route('getChart', ['title' => "Diet Follow", "start" => round(($diet_logs / $total_days) * 100), "end" => round((($total_days - $diet_logs) / $total_days) * 100)])
            ];
        }


        $workout_logs_days = WorkoutLog::whereBetween('created_at', $between)->where('user_id', $loggdinUser->id)->get()->groupBy('created_at')->count();
        $workout_logs = 0;
        for ($dt = 0; $dt < $total_days; $dt++) {
            $date_d = date('Y-m-d', strtotime("+" . $dt . " days", strtotime($between[0])));
            $day_stars = WorkoutLog::whereDate('created_at', $date_d)->distinct('workout_days_uuid')->where('user_id', $loggdinUser->id)->count();
            if ($day_stars < 5) {
                $workout_logs += $day_stars;
            } else {
                $workout_logs += 5;
            }
        }
        $workout_count = $total_days * 5;

        $custom_updates_workout = CustomUpdates::whereBetween('date', $between)->where('type', 'workout')->where('user_id', $loggdinUser->id)->first();
        if (!empty($custom_updates_workout)) {
            $workout_follow = [
                "follow_days" => $workout_logs_days,
                "not_follow" => ($total_days - $workout_logs_days),
                "follow_percent" => $custom_updates_workout->value,
                "not_follow_percent" => ($custom_updates_workout->value - 100),
                "graph" => route('getChart', ['title' => "Workout Follow", "start" => round(($diet_logs / $workout_count) * 100), "end" => round((($workout_count - $workout_logs) / $workout_count) * 100)])
            ];
        } else {
            $workout_follow = [
                "follow_days" => $workout_logs_days,
                "not_follow" => ($total_days - $workout_logs_days),
                "follow_percent" => round(($workout_count > 0 ? ($workout_logs / $workout_count) : 0) * 100),
                "not_follow_percent" => (round(($workout_count > 0 ? (($workout_count - $workout_logs) / $workout_count) : 0) * 100)),
                "graph" => route('getChart', ['title' => "Workout Follow", "start" => round(($diet_logs / $workout_count) * 100), "end" => round((($workout_count - $workout_logs) / $workout_count) * 100)])
            ];
        }


        $lastWeek = WeightLog::where('user_id', $loggdinUser->id)->orderBy('id', 'desc')->first();

        $weekbetween = $this->x_week_range2(date('Y-m-d'));
        $isWeeklyUpdate = WeeklyUpdate::where('user_id', $loggdinUser->id)->whereBetween('created_at', $weekbetween)->exists();

        $final_sts = [
            "date_from" => $between[0],
            "date_to" => $between[1],
            "date_string" => date('d M Y', strtotime($between[0])) . " - " . date('d M Y', strtotime($between[1])),
            "total_days" => $total_days,
            "diet" => $diet_follow,
            "workout" => $workout_follow,
            "last" => ($lastWeek->weight ?? 0),
            "is_weekly_updated" => ($isWeeklyUpdate ?? false)
        ];

        return response()->json($final_sts);
    }

    private function x_week_range2($date)
    {
        $ts = strtotime($date);
        $start = strtotime('monday this week', $ts);
        $end = strtotime('sunday this week', $ts);
        return array(date('Y-m-d', $start), date('Y-m-d', $end));
    }

    public function weeklyUpdateFormHistory(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'to_date' => 'required',
            'from_date' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user()->id;
        $history = WeeklyUpdateForm::where('user_id', $user)->whereBetween('date', [date('Y-m-d', strtotime($request->from_date)), date('Y-m-d', strtotime($request->to_date))])->orderBy('id', 'desc')->get();

        return response()->json($history);
    }

    public function addNewMeditation(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'meditation_type' => 'required',
            'meditation_time' => 'required',
            'remember_before' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $user = Auth::user()->id;
        $is_exist = Meditation::where('type', $request->meditation_type)->where('user_id', $user)->exists();
        if ($is_exist) {
            return response()->json(["status" => "error", "message" => "Already setup this type of meditation"], 400);
        }

        Meditation::insert([
            "type" => $request->meditation_type,
            "time" => $request->meditation_time,
            "threshold" => $request->remember_before,
            "user_id" => $user
        ]);

        return response()->json(["status" => "success", "message" => "Meditation Successfully"], 200);
    }

    public function upcomingMeditation()
    {
        $user = Auth::user()->id;
        $between = [date('H:i', strtotime('now')), date('H:i', strtotime('+12 hours'))];
        $med = Meditation::whereTime('time', '>=', $between[0])->orWhereTime('time', '<=', $between[1])->where('user_id', $user)->get();
        if (empty($med)) {
            return response()->json(["status" => "error", "message" => "Something went wrong"], 400);
        }
        return response()->json(["status" => "success", "time" => $between, 'reminders' => $med], 200);
    }

    public function sendHelpQuery(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'subject' => 'required',
            'message' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $user = Auth::user()->id;

        HelpSupport::insert([
            "type" => "query",
            "subject" => $request->subject,
            "message" => $request->message,
            "user_id" => $user
        ]);

        return response()->json(["status" => "success", "message" => "Query Sent Successfully"], 200);
    }
    public function bookRequestCall(Request $request)
    {

        $user = Auth::user()->id;

        HelpSupport::insert([
            "type" => "call",
            "subject" => "Request Call",
            "message" => "Request Call",
            "user_id" => $user
        ]);

        return response()->json(["status" => "success", "message" => "Call Request Sent Successfully"], 200);
    }
    public function getContactDetails(Request $request)
    {
        $user = Auth::user()->id;
        $cont = InfoContact::where('is_active', 1)->get();
        if (empty($cont)) {
            return response()->json(["status" => "error", "message" => "Something went wrong"], 400);
        }
        return response()->json(["status" => "success", 'contact' => $cont], 200);
    }

    public function getAllCountries(Request $request)
    {
        return Country::select('id', 'name', 'iso3', 'numeric_code')->get();
    }
    public function getSelectedState(Request $request, $cid)
    {
        return State::select('id', 'name', 'iso2')->where('country_id', $cid)->get();
    }
    public function getSelectedCity(Request $request, $cid, $sid)
    {
        return City::select('id', 'name', 'state_code')->where('country_id', $cid)->where('state_id', $sid)->get();
    }

    public function getActiveLanguages(Request $request)
    {
        return Language::where('status', 1)->get();
    }
    //Chat
    public function getChatHome(Request $request)
    {
        $user_id = Auth::user()->id;
        $listChatQr = Chat::select('user_id', 'sender_id')->where('user_id', $user_id)->whereNot('user_id', 0)->orderBy("id", "desc")->distinct()->get();

        $listChat = [];
        foreach ($listChatQr as $list) {
            $list->sender = User::select('name', "image")->where('id', $list->sender_id)->first();
            $listChatDetail = Chat::where('sender_id', $list->sender_id)->where('user_id', $user_id)->orderBy("id", "desc")->first();
            $list->last_message = $listChatDetail ?? array('message' => "Click to start chat");
            ;
            $listChat[] = $list;
        }
        if (count($listChat) == 0) {
            $listChatQr1 = Chat::select('user_id', 'sender_id')->whereNot('user_id', 0)->where('sender_id', $user_id)->orderBy("id", "desc")->distinct()->get();
            foreach ($listChatQr1 as $list) {
                $list->sender = User::select('name', "image")->where('id', $list->user_id)->first();
                $user = $list->user_id;
                $sender = $list->sender_id;
                $list->user_id = $sender;
                $list->sender_id = $user;
                $listChatDetail = Chat::where('sender_id', $list->user_id)->where('sender_id', $user_id)->orderBy("id", "desc")->first();
                $list->last_message = $listChatDetail ?? array('message' => "Click to start chat");
                $listChat[] = $list;
            }
        }


        $assigned_trainee = UserTrainee::where('trainee_user_id', $user_id)->pluck('user_id');
        $trainers = User::whereIn('id', $assigned_trainee)->orderBy('id', 'desc')->get();

        $is_trainer = UserTrainee::where('trainee_user_id', $user_id)->exists('user_id');
        $is_chat = Chat::where('user_id', $user_id)->orWhere('sender_id', $user_id)->exists('user_id');

        $resp = array(
            "list" => $listChat,
            "trainer" => $trainers,
            "is_trainer" => $is_trainer,
            "is_chat" => $is_chat,
            "is_subscriber" => Auth::user()->is_subscription
        );

        return response()->json($resp);
    }

    public function getChatDetail(Request $request, $t_id)
    {
        $user_id = Auth::user()->id;
        $listChatDetail = Chat::where('sender_id', $t_id)->orWhere('sender_id', $user_id)->where('user_id', $t_id)->orWhere('user_id', $user_id)->orderBy("id", "desc")->paginate(10)->reverse()->values();
        $resp = array(
            "sender" => User::find($t_id),
            "chat" => $listChatDetail
        );
        return response()->json($resp);
    }

    public function sendChatMessage(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'to' => 'required',
            'message' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user_id = Auth::user()->id;
        $fileAttached = [];
        if (!empty($request->attached_image)) {
            ob_start();
            $fileName = md5(time()) . ".png";
            $filepath = storage_path() . '/chat_attached' . '/' . $fileName;
            $blob = "data:image/png;base64," . $request->attached_image;
            $blob = file_get_contents($blob);
            $fh = fopen($filepath, 'w');
            fwrite($fh, $blob);
            fclose($fh);
            ob_flush();
            $fileAttached[] = $fileName;
        }

        $save_chat = array(
            "user_id" => $user_id,
            "sender_id" => $request->to,
            "message" => $request->message,
            "is_from_id" => $user_id,
            "is_to_id" => $request->to,
            "attechments" => json_encode($fileAttached)
        );

        Chat::insert($save_chat);

        return response()->json(["status" => "success", "message" => "Message sent successfully"]);
    }
    // My Trainer

    public function workoutList(Request $request)
    {
        $user = Auth::user()->id;
        $assigned_workout = UserWorkout::whereUserId($user)->pluck('workout_uuid');
        $workout_plans = WorkoutPlan::whereNull('user_id')->where('status', 1)->get();
        $myworkoutlist = WorkoutPlan::whereUserId($user)->where('status', 1)->get();

        $getWorkout = array();
        foreach ($workout_plans as $list) {
            $list->list_type = "For All Users";
            $plan_c = WorkoutPlanDay::where('plans_uuid', $list->uuid)->where('status', 1)->count();
            $list->days_count = $plan_c;
            $list->image = env('APP_URL_STR') . 'workout/' . $list->image;
            array_push($getWorkout, $list);
        }
        foreach ($myworkoutlist as $list) {
            $list->list_type = "Assigned";
            $plan_c = WorkoutPlanDay::where('plans_uuid', $list->uuid)->where('status', 1)->count();
            $list->days_count = $plan_c;
            $list->image = env('APP_URL_STR') . 'workout/' . $list->image;
            array_push($getWorkout, $list);
        }
        return response()->json($getWorkout, 200);
    }
    public function workoutFind(Request $request)
    {
        $user = Auth::user()->id;
        // $assigned_workout = UserWorkout::whereUserId($user)->pluck('workout_uuid');
        $workout_plans = WorkoutPlan::whereNull('user_id')->where('title', 'like', '%' . $request->find . "%")->where('status', 1)->get();
        $myworkoutlist = WorkoutPlan::whereUserId($user)->where('title', 'like', '%' . $request->find . "%")->where('status', 1)->get();

        $getWorkout = array();
        foreach ($workout_plans as $list) {
            $list->list_type = "For All Users";
            $plan_c = WorkoutPlanDay::where('plans_uuid', $list->uuid)->where('status', 1)->count();
            $list->days_count = $plan_c;
            $list->image = env('APP_URL_STR') . 'workout/' . $list->image;
            array_push($getWorkout, $list);
        }
        foreach ($myworkoutlist as $list) {
            $list->list_type = "Assigned";
            $plan_c = WorkoutPlanDay::where('plans_uuid', $list->uuid)->where('status', 1)->count();
            $list->days_count = $plan_c;
            $list->image = env('APP_URL_STR') . 'workout/' . $list->image;
            array_push($getWorkout, $list);
        }
        return response()->json($getWorkout, 200);
    }

    public function workoutPlanDays(Request $request, $uuid)
    {
        $user = Auth::user()->id;

        $workout_plans = WorkoutPlan::where('uuid', $uuid)->where('status', 1)->first();

        if (!empty($workout_plans)) {
            $plan = WorkoutPlanDay::where('plans_uuid', $uuid)->where('status', 1)->get();
            $workout_plans->image = env('APP_URL_STR') . 'workout/' . $workout_plans->image;
            foreach ($plan as $list) {
                $list->image = env('APP_URL_STR') . 'workout/' . $list->image;
            }
            return response()->json([
                "status" => "success",
                "message" => "Workout Plan Days",
                "workout" => $workout_plans,
                "days" => $plan
            ], 200);
        }
        return response()->json(["status" => "error", "message" => "Workout Plan Not Found or Disabled"], 500);
    }

    public function workoutDaysDetail(Request $request, $uuid)
    {
        $user = Auth::user()->id;

        $workout_plans = WorkoutDay::where('plan_days_uuid', $uuid)->where('status', 1)->get();

        if (count($workout_plans) > 0) {
            $currentDateTo = date('Y-m-d', strtotime('now'));
            $between = $this->x_week_range2($currentDateTo);
            $workout_plans_day = WorkoutPlanDay::where('uuid', $uuid)->where('status', 1)->first();

            if (!empty($workout_plans_day)) {
                $workout_plans_day->image = env('APP_URL_STR') . 'workout/' . $workout_plans_day->image;
                foreach ($workout_plans as $list) {
                    $list->image = env('APP_URL_STR') . 'workout/' . $list->image;

                    $is_exist = WorkoutLog::where("workout_days_uuid", $list->uuid)->whereBetween('created_at', $between)->where('user_id', $user)->orderBy('id', 'desc')->first();
                    if (!empty($is_exist)) {
                        $is_exist->is_shows_next = (strtotime("+48 hours", strtotime($is_exist->created_at)) <= strtotime('now') ? true : false);
                        $spltNexWeek = explode('_', $is_exist->next_week);
                        $is_exist->is_weight = false;
                        $is_exist->is_reps = false;
                        if (count($spltNexWeek) == 2) {
                            if ($spltNexWeek[0] == "weight") {
                                $is_exist->is_weight = true;
                            } else if ($spltNexWeek[0] == "reps") {
                                $is_exist->is_reps = true;
                            }
                            $is_exist->next_value = $spltNexWeek[1];
                        }
                        $comVal = 1;
                        if ((strtotime("+24 hours", strtotime($is_exist->created_at)) <= strtotime('now') ? true : false)) {
                            $comVal = 0;
                        }
                        $list->is_completed = $comVal;
                        $list->workout_log = $is_exist;
                        $list->is_shows_next = (strtotime("+24 hours", strtotime($is_exist->created_at)) <= strtotime('now') ? true : false);
                    } else {
                        $list->is_completed = 0;
                        $list->workout_log = null;
                        $list->is_shows_next = false;
                    }
                }
                return response()->json([
                    "status" => "success",
                    "message" => "Workout Plan Days",
                    "workout" => $workout_plans,
                    "days" => $workout_plans_day
                ], 200);
            }
            return response()->json(["status" => "error", "message" => "Workout Plan Not Found or Disabled"], 200);
        }

        return response()->json(["status" => "error", "message" => "Workout Day Detail Not Found"], 200);
    }

    public function workoutLogSave(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'uuid' => 'required',
            'difficulty' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $user = Auth::user()->id;

        $workoutLog = array(
            "user_id" => $user,
            "workout_days_uuid" => $request->uuid,
            "weight" => ($request->weight ?? NULL),
            "reps" => ($request->reps ?? NULL),
            "sets" => ($request->sets ?? NULL),
            "time" => ($request->time ?? ''),
            "difficulty" => (int) $request->difficulty
        );
        // return $workoutLog;
        $is_exist = WorkoutLog::where("workout_days_uuid", $request->uuid)->whereDate('created_at', date('Y-m-d'))->where('user_id', $user)->exists();
        if ($is_exist) {
            return response()->json(["status" => "success", "message" => "Workout Record Already Updated"], 200);
        }
        WorkoutLog::create($workoutLog);
        return response()->json(["status" => "success", "message" => "Workout Record Update Successfully"], 200);
    }


    //New
    public function editUserProfile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'gender' => 'required_without_all:dob,height,weight,goal,activity_level,location,language,name',
            'dob' => 'required_without_all:gender,height,weight,goal,activity_level,location,language,name',
            'height' => 'required_without_all:gender,dob,weight,goal,activity_level,location,language,name',
            'weight' => 'required_without_all:gender,dob,height,goal,activity_level,location,language,name',
            'goal' => 'required_without_all:gender,dob,height,weight,activity_level,location,language,name',
            'activity_level' => 'required_without_all:gender,dob,height,weight,goal,location,language,name',
            'location' => 'required_without_all:gender,dob,height,weight,goal,activity_level,language,name',
            'language' => 'required_without_all:gender,dob,height,weight,goal,activity_level,location,name'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $user = User::where('id', Auth::user()->id)->first();

        if (!empty($request->name)) {
            $user->name = $request->name;
        }
        if (!empty($request->gender)) {
            $user->gender = $request->gender;
        }
        if (!empty($request->dob)) {
            $user->dob = $request->dob;
        }
        if (!empty($request->height)) {
            $user->height = $request->height;
        }
        if (!empty($request->weight)) {
            $user->weight = $request->weight;
        }
        if (!empty($request->goal)) {
            $user->goal = $request->goal;
        }
        if (!empty($request->activity_level)) {
            $user->activity_level = $request->activity_level;
        }
        if (!empty($request->location)) {
            $user->location = $request->location;
        }
        if (!empty($request->language)) {
            $user->language = $request->language;
        }
        $fileName = '';
        if (!empty($request->image)) {
            ob_start();
            $fileName = Str::uuid() . ".png";
            $filepath = storage_path() . '/users' . '/' . $fileName;
            $blob = "data:image/png;base64," . $request->image;
            $blob = file_get_contents($blob);
            $fh = fopen($filepath, 'w');
            fwrite($fh, $blob);
            fclose($fh);
            ob_flush();
        }
        if (!empty($fileName)) {
            $user->image = $fileName;
        }
        if ($user->save()) {
            return response()->json([
                "status" => "success",
                'message' => 'User profile updated',
                'user' => $user
            ]);
        }
        return response()->json([
            "status" => "error",
            'message' => 'Something went wrong!'
        ]);
    }
    public function getUserPasswordChange(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'old_password' => 'required',
            'password' => 'required',
            'confirm_password' => 'required'

        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }



        $user = User::where('id', Auth::user()->id)->first();
        if (!Hash::check($request->old_password, $user->password)) {
            return response()->json([
                "status" => "error",
                'message' => 'Old Password Incorrect',
            ], 200);
        }

        if ($request->password != $request->confirm_password) {
            return response()->json([
                "status" => "error",
                'message' => 'Confirm password mismatch!'
            ]);
        }

        $user->password = Hash::make($request->confirm_password);

        if ($user->save()) {
            return response()->json([
                "status" => "success",
                'message' => 'Password updated',
                'user' => $user
            ]);
        }
        return response()->json([
            "status" => "error",
            'message' => 'Something went wrong!'
        ]);
    }
    public function recipeList(Request $request)
    {
        // RecipeList
        $all_fav = UserFavRecipe::where('user_id', Auth::user()->id)->pluck('recipe_id');
        if (!empty($request->tag)) {
            if ($request->tag == "all") {
                if (!empty($request->search)) {
                    $recipe_query = RecipeList::where('name', 'like', '%' . $request->search . '%');
                } else {
                    $recipe_query = RecipeList::whereNotNull('id');
                }
            } else if ($request->tag == "fav") {
                if (!empty($request->search)) {
                    $recipe_query = RecipeList::whereIn('id', $all_fav)->where('name', 'like', '%' . $request->search . '%');
                } else {
                    $recipe_query = RecipeList::whereIn('id', $all_fav);
                }
            } else if ($request->tag == "customized_meal") {
                if (!empty($request->search)) {
                    $recipe_query = RecipeList::whereUserId(Auth::user()->id)->where('name', 'like', '%' . $request->search . '%');
                } else {
                    $recipe_query = RecipeList::whereUserId(Auth::user()->id);
                }
            } else {
                if (!empty($request->search)) {
                    $recipe_query = RecipeList::where('type', $request->tag)->where('name', 'like', '%' . $request->search . '%');
                } else {
                    $recipe_query = RecipeList::where('type', $request->tag);
                }
            }
        } else {
            if (!empty($request->search)) {
                $recipe_query = RecipeList::where('name', 'like', '%' . $request->search . '%');
            } else {
                $recipe_query = RecipeList::whereNotNull('id');
            }
        }
        if (($request->tag ?? '') != "customized_meal") {
            $recipe_list = $recipe_query->whereNull('user_id')->get();
        } else {
            $recipe_list = $recipe_query->get();
        }


        $custom_tag = RecipeList::distinct('type')->pluck('type');
        $recipe_tags = array();
        foreach ($custom_tag as $list) {
            array_push($recipe_tags, $list);
        }

        $is_exist = RecipeList::whereUserId(Auth::user()->id)->exists();
        if ($is_exist) {
            array_push($recipe_tags, 'customized_meal');
        }

        foreach ($recipe_list as $list) {
            if (in_array($list->id, $all_fav->toArray())) {
                $list->is_fav = true;
            } else {
                $list->is_fav = false;
            }
            $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe_ingredients))->get();
            $recipe_ingredients = $ingredients->groupBy('id')->toArray();
            $list->recipe_steps = json_decode($list->recipe_steps);
            $list->recipe_ingredients = $recipe_ingredients;

            $calories = 0;
            $protein = 0;
            $crabs = 0;
            $fats = 0;
            foreach ($list->recipe_steps as $relist) {
                if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                    $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                    $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                    $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                    $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                } else {
                    $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                }

                $calories += $calc;
                $protein += $pro;
                $crabs += $crab;
                $fats += $fat;
            }
            $list->calories = round($calories);
            $list->protein = round($protein);
            $list->crabs = round($crabs);
            $list->fats = round($fats);
        }
        return response()->json([
            "status" => "success",
            "message" => "Recipe List",
            "recipe" => $recipe_list,
            "tags" => $recipe_tags,
            "custom_tag" => $custom_tag,
            "selected_tag" => ($request->tag ?? 'all')
        ], 200);
    }
    public function recipeIngredients(Request $request)
    {
        // RecipeIngredient
        $user_id = Auth::user()->id;

        $all_fav = UserFavRecipe::where('user_id', Auth::user()->id)->pluck('recipe_id');
        if (!empty($request->tag)) {
            if ($request->tag == "all") {
                if (!empty($request->search)) {
                    $recipe_list = RecipeIngredient::where('name', 'like', '%' . $request->search . '%')->whereNull('c_by')->orWhere('c_by', $user_id)->get();
                } else {
                    $recipe_list = RecipeIngredient::whereNull('c_by')->orWhere('c_by', $user_id)->get();
                }
            } else if ($request->tag == "fav") {
                if (!empty($request->search)) {
                    $recipe_list = RecipeIngredient::whereIn('id', $all_fav)->whereNull('c_by')->orWhere('c_by', $user_id)->where('name', 'like', '%' . $request->search . '%')->get();
                } else {
                    $recipe_list = RecipeIngredient::whereIn('id', $all_fav)->whereNull('c_by')->orWhere('c_by', $user_id)->get();
                }
            } else {
                if (!empty($request->search)) {
                    $recipe_list = RecipeIngredient::where('foodtype', $request->tag)->whereNull('c_by')->orWhere('c_by', $user_id)->where('name', 'like', '%' . $request->search . '%')->get();
                } else {
                    $recipe_list = RecipeIngredient::where('foodtype', $request->tag)->whereNull('c_by')->orWhere('c_by', $user_id)->get();
                }
            }
        } else {
            if (!empty($request->search)) {
                $recipe_list = RecipeIngredient::where('name', 'like', '%' . $request->search . '%')->whereNull('c_by')->orWhere('c_by', $user_id)->get();
            } else {
                $recipe_list = RecipeIngredient::whereNull('c_by')->orWhere('c_by', $user_id)->get();
            }
        }

        $recipe_tags = RecipeIngredient::distinct('foodtype')->pluck('foodtype');

        foreach ($recipe_list as $list) {
            if (in_array($list->id, $all_fav->toArray())) {
                $list->is_fav = true;
            } else {
                $list->is_fav = false;
            }
        }
        return response()->json([
            "status" => "success",
            "message" => "Recipe List",
            "recipe" => $recipe_list,
            "tags" => $recipe_tags,
            "selected_tag" => ($request->tag ?? 'all')
        ], 200);
    }

    public function saveRecipeIngredients(Request $request)
    {
        $loggdin_id = Auth::user()->id;
        $recipe_steps = array();
        foreach ($request->ingredient_id as $index => $recipe) {
            $recipeIngredient = RecipeIngredient::where('id', $recipe)->first();
            array_push($recipe_steps, array(
                "id" => $request->ingredient_id[$index],
                "name" => $recipeIngredient->name ?? '',
                "qty" => $request->ingredient_qty[$index],
                "type" => $request->ingredient_type[$index],
                "note" => $request->ingredient_note[$index]
            ));
        }
        $ins_query = array(
            "user_id" => $loggdin_id,
            "name" => $request->recipename,
            "type" => $request->recipetype,
            "description" => $request->recipedesc,
            "recipe_ingredients" => json_encode($request->ingredient_id),
            "recipe_steps" => json_encode($recipe_steps),
        );
        $getRecipeSaved = RecipeList::create($ins_query);
        $is_favorite = $request->chooseMealAsMyMeal == 'favorite' ? true : false;
        $is_breakfast = $request->chooseMealAsMyMeal == 'breakfast' ? true : false;
        $is_lunch = $request->chooseMealAsMyMeal == 'lunch' ? true : false;
        $is_snacks = $request->chooseMealAsMyMeal == 'snacks' ? true : false;
        $is_dinner = $request->chooseMealAsMyMeal == 'dinner' ? true : false;
        UserRecipeList::insert([
            "user_id" => $loggdin_id,
            "recipe_id" => $getRecipeSaved->id,
            "is_favorite" => ($is_favorite ?? 0),
            "is_breakfast" => ($is_breakfast ?? 0),
            "is_lunch" => ($is_lunch ?? 0),
            "is_snacks" => ($is_snacks ?? 0),
            "is_dinner" => ($is_dinner ?? 0)
        ]);
        return response()->json(["status" => "success", "message" => "Recipe Created & Added To Your Meal"], 200);
    }
    public function meditationInfo(Request $request)
    {
        return response()->json([
            "status" => "success",
            "message" => "Meditation Info",
            "title" => "Music For Self Improvement",
            "video" => "YGS4JWP7-5Y",
            "description" => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s,"
        ], 200);
    }
    public function meditationList(Request $request)
    {
        // MeditationList
        $recQry = MeditationList::where('status', 1);

        if ($request->has('category') && !empty($request->category)) {
            $recQry->where('cat_uid', $request->category);
        }
        $res = $recQry->get();

        $categories = MeditationCategories::where('status', 1)->get();
        foreach ($categories as $list) {
            if ($request->has('category') && !empty($request->category)) {
                if ($request->category == $list->uuid) {
                    $list->is_selected = true;
                } else {
                    $list->is_selected = false;
                }
            } else {
                $list->is_selected = false;
            }
        }
        return response()->json([
            "status" => "success",
            "message" => "Meditation List",
            "categories" => $categories,
            "meditations" => $res
        ], 200);
    }

    public function meditationCategories(Request $request)
    {
        // MeditationCategories
        $meditations = MeditationCategories::where('status', 1)->get();
        return response()->json([
            "status" => "success",
            "message" => "Meditation Categories",
            "categories" => $meditations
        ], 200);
    }


    public function meditationDetail(Request $request, $uuid)
    {
        // MeditationDetail
        $meditations = MeditationList::where('status', 1)->where('id', $uuid)->first();
        if (!empty($meditations)) {
            return response()->json([
                "status" => "success",
                "message" => "Meditation List",
                "meditation" => $meditations
            ], 200);
        }
        return response()->json([
            "status" => "error",
            "message" => "Meditation Detail Not Found"
        ], 200);
    }

    public function recipeGuideList(Request $request)
    {
        $recQry = RecipeGuideList::where('status', 1);
        if ($request->has('category') && !empty($request->category)) {
            $recQry->where('cat_uid', $request->category);
        }
        if ($request->has('search')) {
            $recQry->where('title', 'like', '%' . $request->search . '%');
        }

        $recipeCategories = RecipeCategories::where('status', 1)->get();
        foreach ($recipeCategories as $list) {
            if ($request->has('category') && !empty($request->category)) {
                if ($request->category == $list->uuid) {
                    $list->is_selected = true;
                } else {
                    $list->is_selected = false;
                }
            } else {
                $list->is_selected = false;
            }
        }
        $res = $recQry->get();
        return response()->json([
            "status" => "success",
            "message" => "Recipe Guide List",
            "categories" => $recipeCategories,
            "recipe" => $res,
        ], 200);
    }

    public function recipeGuideDetail(Request $request, $uuid)
    {
        $meditations = RecipeGuideList::where('status', 1)->where('id', $uuid)->first();

        $recipe_random = RecipeGuideList::where('id', '<>', $uuid)->inRandomOrder()->limit(3)->get();
        if (!empty($meditations)) {
            return response()->json([
                "status" => "success",
                "message" => "Recipe Guide List",
                "recipe" => $meditations,
                "more" => $recipe_random
            ], 200);
        }
        return response()->json([
            "status" => "error",
            "message" => "Recipe Guide Detail Not Found"
        ], 200);
    }

    public function allReminders(Request $request)
    {
        // MyReminder
        $reminder = MyReminder::where('user_id', Auth::user()->id)->get();
        foreach ($reminder as $list) {
            $list->weekdays = json_decode($list->weekdays);
            $list->time_decode = date('h:i', strtotime($list->time));
            $list->time_set = date('A', strtotime($list->time));
        }
        return response()->json([
            "status" => "success",
            "message" => "Reminder List",
            "reminder" => $reminder
        ], 200);
    }

    public function getSettingData(Request $request, $name)
    {
        $setting = Setting::where('name', $name)->first();
        if (!empty($setting)) {
            return response()->json([
                "status" => "success",
                "message" => "Settings List",
                "setting" => $setting
            ], 200);
        }
        return response()->json([
            "status" => "error",
            "message" => "Setting Not Found"
        ], 200);
    }

    public function formBuilderGuide(Request $request)
    {
        return response()->json([
            "status" => "success",
            "detail" => array(
                "title" => "About From Builder Guide",
                "image" => env('APP_URL_STR') . "formbuilderuploads/form_builder_guide.png",
                "video" => "YGS4JWP7-5Y",
                "description" => "Enhance your workout efficiency with our Form Builder Guide. Learn the proper techniques and forms for various exercises to maximize your results and prevent injuries. Our step-by-step video tutorials and expert tips will help you achieve perfect form every time."
            )
        ], 200);
    }

    public function formBuilderWorkouts(Request $request)
    {
        // FormBuilderWorkout
        $workout = FormBuilderWorkout::where('status', 1)->get();
        foreach ($workout as $list) {
            $list->image = env('APP_URL_STR') . 'exercise_vid_thumb/' . $list->image;
        }
        return response()->json([
            "status" => "success",
            "message" => "Workout List",
            "workout" => $workout
        ], 200);
    }

    public function formBuilderGuideDetail(Request $request, $uuid)
    {
        $setting = FormBuilderWorkout::where('id', $uuid)->first();
        $setting->image = env('APP_URL_STR') . 'exercise_vid_thumb/' . $setting->image;
        if (!empty($setting)) {
            return response()->json([
                "status" => "success",
                "message" => "Settings List",
                "detail" => $setting
            ], 200);
        }
        return response()->json([
            "status" => "error",
            "message" => "Workout Not Found"
        ], 200);
    }

    public function formBuilderUploadVideo(Request $request)
    {
        // return $request->all();
        // $validator = Validator::make($request->all(), [
        //     'form_workout_id' => 'required',
        //     'video' => 'required'
        // ]);

        // if ($validator->fails()) {
        //     return response()->json($validator->errors());
        // }

        $fileName = '';
        if (request()->hasFile('video')) {
            $file = request()->file('video');
            $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
            $file->move(storage_path() . '/formbuilderuploads' . '/', $fileName);
        }

        $info = array(
            "user_id" => Auth::user()->id,
            "video_path" => $fileName,
            "workout_id" => $request->form_workout_id,
            "description" => $request->description
        );

        FormBuilderUpload::insert($info);

        return response()->json([
            "status" => "success",
            "message" => "Video Uploaded Successfully"
        ], 200);
    }
    public function bodyMeasurmentUpdate(Request $request, $type)
    {
        $validator = Validator::make($request->all(), [
            'value' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $isExist = BodyMeasurment::whereUserId(Auth::user()->id)->where('type', $type)->where('date', date('Y-m-d', strtotime('now')))->exists();
        if ($isExist) {
            return response()->json([
                "status" => "error",
                "message" => "Today already updated"
            ], 200);
        }
        $info = array(
            "user_id" => Auth::user()->id,
            "type" => $type,
            "value" => $request->value,
            "date" => date('Y-m-d', strtotime('now'))
        );

        BodyMeasurment::insert($info);

        return response()->json([
            "status" => "success",
            "message" => "Body Measurment Uploaded Successfully"
        ], 200);
    }

    public function updatePhysique(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'image' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $isExist = Physique::whereUserId(Auth::user()->id)->where('date', date('Y-m-d', strtotime('now')))->exists();
        if ($isExist) {
            return response()->json([
                "status" => "error",
                "message" => "Today already updated"
            ], 200);
        }

        $fileName = '';
        if (!empty($request->image)) {
            ob_start();
            $fileName = md5(time()) . ".png";
            $filepath = storage_path() . '/physique_uploads' . '/' . $fileName;
            $blob = "data:image/png;base64," . $request->image;
            $blob = file_get_contents($blob);
            $fh = fopen($filepath, 'w');
            fwrite($fh, $blob);
            fclose($fh);
            ob_flush();
        }
        if ($fileName == '') {
            return response()->json([
                "status" => "error",
                "message" => "Something went wrong!"
            ], 200);
        }

        $info = array(
            "user_id" => Auth::user()->id,
            "image" => $fileName,
            'date' => date('Y-m-d', strtotime('now'))
        );

        Physique::insert($info);

        return response()->json([
            "status" => "success",
            "message" => "Image Uploaded Successfully"
        ], 200);
    }
    public function updatePhysiqueCompare(Request $request)
    {
        $first = Physique::where('user_id', Auth::user()->id)->orderBy('id', 'desc')->first();
        $last = Physique::where('user_id', Auth::user()->id)->orderBy('id', 'asc')->first();
        $first->image = env('APP_URL_STR') . 'physique_uploads' . '/' . $first->image;
        $last->image = env('APP_URL_STR') . 'physique_uploads' . '/' . $last->image;
        return response()->json([
            "status" => "success",
            "message" => "Image Uploaded Successfully",
            "first" => $last,
            "last" => $first
        ], 200);
    }
    public function addReminder(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'weekdays' => 'required',
            'time' => 'required',
            'reminder_type' => 'required',
            'name' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $info = array(
            "user_id" => Auth::user()->id,
            "reminder_type" => $request->reminder_type,
            "name" => $request->name,
            "is_enabled" => 1,
            "time" => date('H:i', strtotime($request->time)),
            "weekdays" => json_encode($request->weekdays),
            "message" => $request->name
        );


        MyReminder::insert($info);

        return response()->json([
            "status" => "success",
            "message" => "Reminder Add Successfully"
        ], 200);
    }


    public function notificationList(Request $request)
    {
        // Notification
        $workout = Notification::where('user_id', Auth::user()->id)->orderBy('id', 'desc')->paginate(15);
        return response()->json($workout, 200);
    }

    public function updateFavRecipe(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'recipe_id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $logdinUser = Auth::user()->id;
        $is_exist = UserFavRecipe::where('user_id', $logdinUser)->where('recipe_id', $request->recipe_id)->first();
        // $recipe_detail = RecipeList::where('id',$request->recipe_id)->first();
        $recipe_detail = RecipeIngredient::where('id', $request->recipe_id)->first();
        if (!empty($is_exist)) {
            $is_exist->delete();
            return response()->json([
                "status" => "error",
                "message" => $recipe_detail->name . " removed from favorite list"
            ], 200);
        }

        $info = UserFavRecipe::insert([
            "user_id" => $logdinUser,
            "recipe_id" => $request->recipe_id
        ]);

        return response()->json([
            "status" => "success",
            "message" => $recipe_detail->name . " added to favorite list"
        ], 200);
    }

    public function saveRecipeReference(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'recipe_id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $logdinUser = Auth::user()->id;

        foreach (explode(',', $request->recipe_id) as $rec_list) {
            $is_exist = UserRecipeList::where('user_id', $logdinUser)->where('recipe_id', $rec_list)->exists();
            if (!$is_exist) {
                $info = UserRecipeList::insert([
                    "user_id" => $logdinUser,
                    "recipe_id" => $rec_list,
                    "is_favorite" => ($request->is_favorite ?? 0),
                    "is_breakfast" => ($request->is_breakfast ?? 0),
                    "is_lunch" => ($request->is_lunch ?? 0),
                    "is_snacks" => ($request->is_snacks ?? 0),
                    "is_dinner" => ($request->is_dinner ?? 0)
                ]);
            }
        }

        return response()->json([
            "status" => "success",
            "message" => "meal list updated"
        ], 200);
    }

    public function getRecipeReference()
    {
        $logdinUser = Auth::user()->id;
        $breakfast_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_breakfast', 1);
        $breakfast = $breakfast_q->get();
        $lunch_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_lunch', 1);
        $lunch = $lunch_q->get();
        $snacks_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_snacks', 1);
        $snacks = $snacks_q->get();
        $dinner_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_dinner', 1);
        $dinner = $dinner_q->get();

        $get_breakfast_cal = 0;
        $get_lunch_cal = 0;
        $get_snacks_cal = 0;
        $get_dinner_cal = 0;

        foreach ($breakfast as $list) {
            $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
            $recipe_ingredients = $ingredients->groupBy('id')->toArray();
            $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
            $list->recipe->recipe_ingredients = $recipe_ingredients;

            $calories = 0;
            $protein = 0;
            $crabs = 0;
            $fats = 0;
            foreach ($list->recipe->recipe_steps as $relist) {
                if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                    $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                    $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                    $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                    $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                } else {
                    $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                }

                $calories += $calc;
                $protein += $pro;
                $crabs += $crab;
                $fats += $fat;
            }
            $list->recipe->calories = round($calories);
            $list->recipe->protein = round($protein);
            $list->recipe->crabs = round($crabs);
            $list->recipe->fats = round($fats);
            $get_breakfast_cal += round($calories);

        }

        foreach ($lunch as $list) {
            $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
            $recipe_ingredients = $ingredients->groupBy('id')->toArray();
            $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
            $list->recipe->recipe_ingredients = $recipe_ingredients;

            $calories = 0;
            $protein = 0;
            $crabs = 0;
            $fats = 0;
            foreach ($list->recipe->recipe_steps as $relist) {
                if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                    $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                    $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                    $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                    $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                } else {
                    $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                }

                $calories += $calc;
                $protein += $pro;
                $crabs += $crab;
                $fats += $fat;
            }
            $list->recipe->calories = round($calories);
            $list->recipe->protein = round($protein);
            $list->recipe->crabs = round($crabs);
            $list->recipe->fats = round($fats);
            $get_lunch_cal += round($calories);

        }
        foreach ($snacks as $list) {
            $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
            $recipe_ingredients = $ingredients->groupBy('id')->toArray();
            $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
            $list->recipe->recipe_ingredients = $recipe_ingredients;

            $calories = 0;
            $protein = 0;
            $crabs = 0;
            $fats = 0;
            foreach ($list->recipe->recipe_steps as $relist) {
                if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                    $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                    $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                    $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                    $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                } else {
                    $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                }

                $calories += $calc;
                $protein += $pro;
                $crabs += $crab;
                $fats += $fat;
            }
            $list->recipe->calories = round($calories);
            $list->recipe->protein = round($protein);
            $list->recipe->crabs = round($crabs);
            $list->recipe->fats = round($fats);

            $get_snacks_cal += round($calories);

        }
        foreach ($dinner as $list) {
            $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
            $recipe_ingredients = $ingredients->groupBy('id')->toArray();
            $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
            $list->recipe->recipe_ingredients = $recipe_ingredients;

            $calories = 0;
            $protein = 0;
            $crabs = 0;
            $fats = 0;
            foreach ($list->recipe->recipe_steps as $relist) {
                if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                    $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                    $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                    $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                    $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                } else {
                    $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                }

                $calories += $calc;
                $protein += $pro;
                $crabs += $crab;
                $fats += $fat;
            }
            $list->recipe->calories = round($calories);
            $list->recipe->protein = round($protein);
            $list->recipe->crabs = round($crabs);
            $list->recipe->fats = round($fats);
            $get_dinner_cal += round($calories);
        }


        return response()->json([
            "status" => "success",
            "message" => "meal list updated",
            "breakfast" => [
                "list" => $breakfast,
                "total_calories" => $get_breakfast_cal
            ],
            "lunch" => [
                "list" => $lunch,
                "total_calories" => $get_lunch_cal
            ],
            "dinner" => [
                "list" => $dinner,
                "total_calories" => $get_dinner_cal
            ],
            "snacks" => [
                "list" => $snacks,
                "total_calories" => $get_snacks_cal
            ]
        ], 200);
    }

    public function specificRecipeList(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'record_type' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $logdinUser = Auth::user()->id;
        if ($request->record_type == "all") {
            $recipe_query = RecipeList::whereNotNull('id');
            $recipe_list = $recipe_query->get();
            foreach ($recipe_list as $list) {
                $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe_ingredients))->get();
                $recipe_ingredients = $ingredients->groupBy('id')->toArray();
                $list->recipe_steps = json_decode($list->recipe_steps);
                $list->recipe_ingredients = $recipe_ingredients;

                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach ($list->recipe_steps as $relist) {
                    if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    }

                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $list->calories = round($calories);
                $list->protein = round($protein);
                $list->crabs = round($crabs);
                $list->fats = round($fats);
            }
            return response()->json([
                "status" => "success",
                "message" => "meal list updated",
                "recipe_list" => $recipe_list,
                "total_calories" => 0
            ], 200);
        } else if ($request->record_type == "fav") {
            $all_fav = UserFavRecipe::where('user_id', Auth::user()->id)->pluck('recipe_id');
            $recipe_query = RecipeList::whereIn('id', $all_fav);
            $recipe_list = $recipe_query->get();
            foreach ($recipe_list as $list) {
                $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe_ingredients))->get();
                $recipe_ingredients = $ingredients->groupBy('id')->toArray();
                $list->recipe_steps = json_decode($list->recipe_steps);
                $list->recipe_ingredients = $recipe_ingredients;

                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach ($list->recipe_steps as $relist) {
                    if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    }

                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $list->calories = round($calories);
                $list->protein = round($protein);
                $list->crabs = round($crabs);
                $list->fats = round($fats);
            }
            return response()->json([
                "status" => "success",
                "message" => "meal list updated",
                "recipe_list" => $recipe_list,
                "total_calories" => 0
            ], 200);
        } else if ($request->record_type == "breakfast") {
            $breakfast_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_breakfast', 1);
            $breakfast = $breakfast_q->get();
            $get_cal = 0;
            foreach ($breakfast as $list) {
                $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
                $recipe_ingredients = $ingredients->groupBy('id')->toArray();
                $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
                $list->recipe->recipe_ingredients = $recipe_ingredients;

                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach ($list->recipe->recipe_steps as $relist) {
                    if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    }

                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $list->recipe->calories = round($calories);
                $list->recipe->protein = round($protein);
                $list->recipe->crabs = round($crabs);
                $list->recipe->fats = round($fats);
                $get_cal += round($calories);

            }
            return response()->json([
                "status" => "success",
                "message" => "meal list updated",
                "recipe_list" => $breakfast,
                "total_calories" => $get_cal
            ], 200);
        } else if ($request->record_type == "lunch") {
            $lunch_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_lunch', 1);
            $lunch = $lunch_q->get();
            $get_cal = 0;
            foreach ($lunch as $list) {
                $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
                $recipe_ingredients = $ingredients->groupBy('id')->toArray();
                $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
                $list->recipe->recipe_ingredients = $recipe_ingredients;

                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach ($list->recipe->recipe_steps as $relist) {
                    if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    }

                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $list->recipe->calories = round($calories);
                $list->recipe->protein = round($protein);
                $list->recipe->crabs = round($crabs);
                $list->recipe->fats = round($fats);
                $get_cal += round($calories);

            }
            return response()->json([
                "status" => "success",
                "message" => "meal list updated",
                "recipe_list" => $lunch,
                "total_calories" => $get_cal
            ], 200);
        } else if ($request->record_type == "dinner") {
            $dinner_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_dinner', 1);
            $dinner = $dinner_q->get();
            $get_cal = 0;
            foreach ($dinner as $list) {
                $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
                $recipe_ingredients = $ingredients->groupBy('id')->toArray();
                $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
                $list->recipe->recipe_ingredients = $recipe_ingredients;

                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach ($list->recipe->recipe_steps as $relist) {
                    if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    }

                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $list->recipe->calories = round($calories);
                $list->recipe->protein = round($protein);
                $list->recipe->crabs = round($crabs);
                $list->recipe->fats = round($fats);
                $get_cal += round($calories);
            }
            return response()->json([
                "status" => "success",
                "message" => "meal list updated",
                "recipe_list" => $dinner,
                "total_calories" => $get_cal
            ], 200);
        } else if ($request->record_type == "snack") {
            $snacks_q = UserRecipeList::where('user_id', $logdinUser)->with('recipe')->where('is_snacks', 1);
            $snacks = $snacks_q->get();
            $get_cal = 0;
            foreach ($snacks as $list) {
                $ingredients = RecipeIngredient::whereIn('id', json_decode($list->recipe->recipe_ingredients))->get();
                $recipe_ingredients = $ingredients->groupBy('id')->toArray();
                $list->recipe->recipe_steps = json_decode($list->recipe->recipe_steps);
                $list->recipe->recipe_ingredients = $recipe_ingredients;

                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach ($list->recipe->recipe_steps as $relist) {
                    if ($recipe_ingredients[$relist->id][0]['qty'] == 'qty') {
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories'] * intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein'] * intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs'] * intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats'] * intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats'] / $recipe_ingredients[$relist->id][0]['qty']) * intval($relist->qty);
                    }

                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $list->recipe->calories = round($calories);
                $list->recipe->protein = round($protein);
                $list->recipe->crabs = round($crabs);
                $list->recipe->fats = round($fats);

                $get_cal += round($calories);

            }
            return response()->json([
                "status" => "success",
                "message" => "meal list updated",
                "recipe_list" => $snacks,
                "total_calories" => $get_cal
            ], 200);
        }
        response()->json(['status' => "error", "message" => "Something went wrong!"]);
    }

    public function deepSleepList(Request $request)
    {
        $logdinUser = Auth::user()->id;
        $list = MeditationDeepSleep::where('status', 1)->get();
        foreach ($list as $i) {
            $i->file_path = env('APP_URL_STR') . 'meditation_deepsleep/' . $i->file_path;
        }
        return response()->json($list);
    }

    public function requestPremium(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'plan_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $logdinUser = Auth::user()->id;
        $is_exist = RequestPremium::where('user_id', $logdinUser)->exists();
        if ($is_exist) {
            return response()->json([
                "status" => "success",
                "message" => "Request received for premium plan. our team contact you asap. thanks"
            ], 200);
        }
        RequestPremium::insert([
            'plan_id' => $request->plan_id,
            'user_id' => $logdinUser
        ]);

        return response()->json([
            "status" => "success",
            "message" => "Request received for premium plan. our team contact you asap. thanks"
        ], 200);
    }

    public function disableReminder(Request $request)
    {
        // MyReminder
        $id = $request->id;
        $getReminder = MyReminder::where('id', $id)->first();
        $getReminder->is_enabled = !$getReminder->is_enabled;
        $getReminder->save();

        $reminder = MyReminder::where('user_id', Auth::user()->id)->get();
        foreach ($reminder as $list) {
            $list->weekdays = json_decode($list->weekdays);
            $list->time_decode = date('h:i', strtotime($list->time));
            $list->time_set = date('A', strtotime($list->time));
        }
        return response()->json([
            "status" => "success",
            "message" => "Reminder Status Changed",
            "reminder" => $reminder
        ], 200);
    }

    public function trashReminder(Request $request)
    {
        // MyReminder
        $id = $request->id;
        $getReminder = MyReminder::where('id', $id)->first();
        $getReminder->is_enabled = !$getReminder->is_enabled;
        $getReminder->delete();


        $reminder = MyReminder::where('user_id', Auth::user()->id)->get();
        foreach ($reminder as $list) {
            $list->weekdays = json_decode($list->weekdays);
            $list->time_decode = date('h:i', strtotime($list->time));
            $list->time_set = date('A', strtotime($list->time));
        }
        return response()->json([
            "status" => "success",
            "message" => "Reminder Deleted",
            "reminder" => $reminder
        ], 200);
    }

    public function updateReminder(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'weekdays' => 'required',
            'time' => 'required',
            'reminder_type' => 'required',
            'name' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $info = array(
            "user_id" => Auth::user()->id,
            "reminder_type" => $request->reminder_type,
            "name" => $request->name,
            "is_enabled" => 1,
            "time" => date('H:i', strtotime($request->time)),
            "weekdays" => json_encode($request->weekdays),
            "message" => $request->name
        );
        MyReminder::where('id', $request->id)->update($info);

        $reminder = MyReminder::where('user_id', Auth::user()->id)->get();
        foreach ($reminder as $list) {
            $list->weekdays = json_decode($list->weekdays);
            $list->time_decode = date('h:i', strtotime($list->time));
            $list->time_set = date('A', strtotime($list->time));
        }
        return response()->json([
            "status" => "success",
            "message" => "Reminder Updated",
            "reminder" => $reminder
        ], 200);
    }

    public function getNotificationSettings(Request $request)
    {
        $user = Auth::user();
        $getData = [];
        foreach ($user->notification_settings as $list) {
            $getData[$list] = true;
        }
        return response()->json($getData, 200);
    }

    public function saveNotificationSettings(Request $request)
    {

        $type = $request->type;
        $user = Auth::user();
        $settings = $user->notification_settings;
        $check = in_array($type, $settings);

        if ($check) {
            $getIndex = array_search($type, $settings);

            if ($getIndex >= 0) {
                unset($settings[$getIndex]);
                $settings = array_values($settings);

            }
        } else {
            array_push($settings, $type);
        }
        $user->notification_settings = json_encode($settings);
        $user->save();
        $getData = [];
        foreach ($user->notification_settings as $list) {
            $getData[$list] = true;
        }
        return response()->json([
            "status" => "success",
            "message" => "Notification Settings Updated",
            "settings" => $getData
        ], 200);
    }
    public function savePushNotificationToken(Request $request)
    {
        $user = Auth::user();
        if ($request->key == 'install_id') {
            $user->wonderpush_install_id = $request->value;
        }
        if ($request->key == 'token') {
            $user->wonderpush_token = $request->value;
        }
        $user->save();
        return 'done';
    }
    public function getMyDietPlan(Request $request)
    {
        $user = Auth::user();
        return response()->json(['html' => $user->diet_plan], 200);
    }

    public function getChart(Request $request, $title, $start, $end)
    {
        $label1 = "Pending";
        $label2 = "Completed";
        $title = $title;
        $values = [(int) $end, (int) $start];
        header("Content-Type: image/png");
        return view('chart.pie', compact('label1', 'label2', 'title', 'values'))->render();
    }



    //MyCalories
    public function getMyCalories(Request $request)
    {
        $userDetail = Auth::user();

        // $takenCalories = MealPicture::whereDate('date',date('Y-m-d',strtotime('now')))->where('is_approved',1)->where('user_id',$userDetail->id)->sum('calories');
        $takenCalories = getUserCalories(date('Y-m-d', strtotime('now')), $userDetail->id);

        $getbmr = getCurrentBMR($userDetail->id);
        return response()->json(['total' => $getbmr, 'pending' => $takenCalories]);
    }

    public function recordTodayMeal(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'meals' => 'required',//meal ids 
            'record_as' => 'required',//Breakfast,Lunch
            'is_add_to_fav' => 'required'//true\false
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $userDetail = Auth::user();

        $recipelog = [
            "recipes" => json_encode($request->meals),
            "user_id" => $userDetail->id,
            "date" => date('Y-m-d'),
            "log_as" => $request->record_as
        ];

        RecipeLog::insert($recipelog);

        return response()->json(["status" => "success", "message" => "Recipe Log Successfully"]);
    }

    public function todayCaloriesInsights(Request $request)
    {
        $date = date('Y-m-d', strtotime('now'));
        if ($request->has('date')) {
            $date = date('Y-m-d', strtotime($request->date));
        }
        $userDetail = Auth::user();
        $takenCalories = getUserCalories($date, $userDetail->id, true);
        $getbmr = getCurrentBMR($userDetail->id);
        $protien = $getbmr * 0.3;
        $crab = $getbmr * 0.5;
        $fat = $getbmr * 0.2;
        $fiber = round($getbmr * 0.014);

        $pendingCalories = [
            'calories' => $getbmr - $takenCalories['calories'],
            'protein' => $protien - $takenCalories['protein'],
            'crabs' => $crab - $takenCalories['crabs'],
            'fats' => $fat - $takenCalories['fats']
        ];

        $completedPercent = [
            'calories' => round(($takenCalories['calories'] / $getbmr) * 100),
            'protein' => round(($takenCalories['protein'] / $protien) * 100),
            'crabs' => round(($takenCalories['crabs'] / $crab) * 100),
            'fats' => round(($takenCalories['fats'] / $fat) * 100),
            "fiber" => 0,
        ];

        $totalCalories = [
            "bmr" => $getbmr,
            "protien" => $protien,
            "crab" => $crab,
            "fat" => $fat,
            "fiber" => $fiber,
        ];

        $resp = [
            "date" => $date,
            "date_string" => date('d F Y', strtotime($date)),
            "taken_calories" => $takenCalories,
            "pending_calories" => $pendingCalories,
            "total_calories" => $totalCalories,
            "percent" => $completedPercent
        ];
        return $resp;
    }

    public function getSettings(Request $request, $name)
    {
        $settings = Setting::where('name', $name)->first();
        if (!empty($settings)) {
            return response()->json(["status" => "success", "data" => $settings]);
        }
        return response()->json(["status" => "error", "message" => "Setting Not Found"]);
    }
    public function getWeightTracker(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'time_type' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $type = $request->time_type;
        $date_str = [];
        if ($type == "week") {
            $date = date('Y-m-d', strtotime('now'));
            $date_str = $this->x_week_range2($date);
        }

        if ($type == "month") {
            $date = date('Y-m-d', strtotime('now'));
            $ts = strtotime($date);
            $start = strtotime('first day of this month', $ts);
            $end = strtotime('last day of this month', $ts);
            $date_str = [date('Y-m-d', $start), date('Y-m-d', $end)];
        }

        if ($type == "six_month") {
            $date1 = date('Y-m-d', strtotime('now'));
            $ts1 = strtotime($date1);
            $end1 = strtotime('last day of this month', $ts1);
            $start1 = strtotime('first day of -6 month', $end1);
            $date_str = [date('Y-m-d', $start1), date('Y-m-d', $end1)];
        }

        if ($type == "custom") {
            if ($request->has('fromdate') && $request->has('todate')) {
                $fromdate = date('Y-m-d', strtotime($request->fromdate));
                $todate = date('Y-m-d', strtotime($request->todate));
                $date_str = [$fromdate, $todate];
            }
        }
        if (count($date_str) == 0) {
            return 'time_type required';
        }
        $getUser = Auth::user()->id;
        $weeklyUpdateQuery = WeightLog::whereBetween('date', $date_str)->where('user_id', $getUser);
        $getChartValue = $weeklyUpdateQuery->pluck('weight')->toArray();
        $dateshartValue = $weeklyUpdateQuery->pluck('date');
        $newDates = [];
        foreach ($dateshartValue as $list) {
            $newDates[] = $list == null ? null : date('d M Y', strtotime($list));
        }
        // $currentWeight = count($getChartValue)==0?0:last($getChartValue);
        $weightChange = last($getChartValue) - current($getChartValue);
        $valPlus = "plus";
        if ($weightChange < 0) {
            $valPlus = "minus";
        }
        $getList = WeightLog::where('user_id', $getUser)->orderBy('id', 'desc')->limit(5)->pluck('id');
        $getListWithLastIDs = WeightLog::whereIn('id', $getList)->orderBy('id', 'asc')->get();
        foreach ($getListWithLastIDs as $indx => $list) {
            $list->weight_change = $list->weight - ($indx == 0 ? 0 : $getListWithLastIDs[$indx - 1]->weight);
            $valPlus = "plus";
            if ($list->weight_change < 0) {
                $valPlus = "minus";
            }
            $list->weight_change_as = $valPlus;
        }

        $getListWithLastIDs = array_reverse($getListWithLastIDs->toArray());
        $lastIDofREC = WeightLog::where('user_id', $getUser)->orderBy('id', 'desc')->first();
        $currentWeight = ($lastIDofREC->weight ?? 0);
        $resp = [
            "request_dates" => $date_str,
            "chart" => $getChartValue,
            "chart_dates" => $newDates,
            "current_weight" => $currentWeight,
            "weight_change" => abs($weightChange),
            "weight_change_countas" => $valPlus,
            "logs" => $getListWithLastIDs
        ];

        return $resp;
    }

    public function getMeasurementTracker(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'time_type' => 'required',
            'measurement_type' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $type = $request->time_type;
        $date_str = [];
        if ($type == "week") {
            $date = date('Y-m-d', strtotime('now'));
            $date_str = $this->x_week_range2($date);
        }

        if ($type == "month") {
            $date = date('Y-m-d', strtotime('now'));
            $ts = strtotime($date);
            $start = strtotime('first day of this month', $ts);
            $end = strtotime('last day of this month', $ts);
            $date_str = [date('Y-m-d', $start), date('Y-m-d', $end)];
        }

        if ($type == "six_month") {
            $date1 = date('Y-m-d', strtotime('now'));
            $ts1 = strtotime($date1);
            $end1 = strtotime('last day of this month', $ts1);
            $start1 = strtotime('first day of -6 month', $end1);
            $date_str = [date('Y-m-d', $start1), date('Y-m-d', $end1)];
        }

        if ($type == "custom") {
            if ($request->has('fromdate') && $request->has('todate')) {
                $fromdate = date('Y-m-d', strtotime($request->fromdate));
                $todate = date('Y-m-d', strtotime($request->todate));
                $date_str = [$fromdate, $todate];
            }
        }
        if (count($date_str) == 0) {
            return 'time_type value mismatch';
        }

        $getUser = Auth::user()->id;
        $weeklyUpdateQuery = BodyMeasurment::whereBetween('date', $date_str)->where('type', $request->measurement_type)->where('user_id', $getUser);
        $getChartValue = $weeklyUpdateQuery->pluck('value')->toArray();
        $dateshartValue = $weeklyUpdateQuery->pluck('date');
        $weightChange = last($getChartValue) - current($getChartValue);
        $valPlus = "plus";
        if ($weightChange < 0) {
            $valPlus = "minus";
        }
        $getList = BodyMeasurment::where('user_id', $getUser)->where('type', $request->measurement_type)->orderBy('id', 'desc')->limit(5)->pluck('id');
        ;
        $getListWithLastIDs = BodyMeasurment::whereIn('id', $getList)->orderBy('id', 'asc')->get();
        foreach ($getListWithLastIDs as $indx => $list) {
            $list->weight_change = (int) $list->value - (int) ($indx == 0 ? 0 : $getListWithLastIDs[$indx - 1]->value);
            $valPlus = "plus";
            if ($list->weight_change < 0) {
                $valPlus = "minus";
            }
            $list->weight_change_as = $valPlus;
        }

        $getListWithLastIDs = array_reverse($getListWithLastIDs->toArray());
        $lastIDofREC = BodyMeasurment::where('user_id', $getUser)->where('type', $request->measurement_type)->orderBy('id', 'desc')->first();
        $currentWeight = ($lastIDofREC->value ?? 0);
        $resp = [
            "request_dates" => $date_str,
            "chart" => $getChartValue,
            "chart_dates" => $dateshartValue,
            "current_value" => $currentWeight,
            "value_change" => abs($weightChange),
            "value_change_countas" => $valPlus,
            "logs" => $getListWithLastIDs
        ];

        return $resp;
    }

    public function getStrengthTracker(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'time_type' => 'required',
            'strength_type' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $type = $request->time_type;
        $date_str = [];
        if ($type == "week") {
            $date = date('Y-m-d', strtotime('now'));
            $date_str = $this->x_week_range2($date);
        }

        if ($type == "month") {
            $date = date('Y-m-d', strtotime('now'));
            $ts = strtotime($date);
            $start = strtotime('first day of this month', $ts);
            $end = strtotime('last day of this month', $ts);
            $date_str = [date('Y-m-d', $start), date('Y-m-d', $end)];
        }

        if ($type == "six_month") {
            $date1 = date('Y-m-d', strtotime('now'));
            $ts1 = strtotime($date1);
            $end1 = strtotime('last day of this month', $ts1);
            $start1 = strtotime('first day of -6 month', $end1);
            $date_str = [date('Y-m-d', $start1), date('Y-m-d', $end1)];
        }

        if ($type == "custom") {
            if ($request->has('fromdate') && $request->has('todate')) {
                $fromdate = date('Y-m-d', strtotime($request->fromdate));
                $todate = date('Y-m-d', strtotime($request->todate));
                $date_str = [$fromdate, $todate];
            }
        }
        if (count($date_str) == 0) {
            return 'time value mismatch';
        }

        $getUser = Auth::user()->id;
        $workoutDay = WorkoutDay::where('exercise_machine', $request->strength_type)->get('uuid');
        $workoutLog = WorkoutLog::whereDate('created_at', '>=', $date_str[0])->whereDate('created_at', "<=", $date_str[1])->whereIn('workout_days_uuid', $workoutDay)->where('user_id', $getUser);
        $getChartValue = [];
        $dateshartValue = [];
        $getWorkoutList = $workoutLog->get();
        foreach ($getWorkoutList as $list) {
            $formula = ($list->weight ?? 0) * (1 + (0.0333 * $list->reps));
            $getChartValue[] = round($formula);
            $dateshartValue[] = date("Y-m-d", strtotime($list->created_at));
        }

        // $dateshartValue = $workoutLog->pluck('created_at');
        $currentWeight = last($getChartValue);
        $weightChange = last($getChartValue) - current($getChartValue);
        $valPlus = "plus";
        if ($weightChange < 0) {
            $valPlus = "minus";
        }
        $getList = WorkoutLog::where('user_id', $getUser)->whereIn('workout_days_uuid', $workoutDay)->orderBy('id', 'desc')->limit(5)->pluck('id');
        $getListWithLastIDs = WorkoutLog::whereIn('id', $getList)->orderBy('id', 'asc')->get();
        foreach ($getListWithLastIDs as $list) {
            $formula = ($list->weight ?? 0) * (1 + (0.0333 * ($list->reps ?? 0)));
            $list->formula = round($formula);
        }
        foreach ($getListWithLastIDs as $indx => $list) {
            $list->weight_change = (int) $list->formula - (int) ($indx == 0 ? 0 : $getListWithLastIDs[$indx - 1]->formula);
            $valPlus = "plus";
            if ($list->weight_change < 0) {
                $valPlus = "minus";
            }
            $list->weight_change_as = $valPlus;
        }

        $getListWithLastIDs = array_reverse($getListWithLastIDs->toArray());
        $lastIDofREC = WorkoutLog::where('user_id', $getUser)->whereIn('workout_days_uuid', $workoutDay)->orderBy('id', 'desc')->first();
        $currentWeight = ($lastIDofREC->value ?? 0);


        $machines = ExerciseMachine::where('uuid', $request->strength_type)->first();
        $resp = [
            "request_dates" => $date_str,
            "chart" => $getChartValue,
            "chart_dates" => $dateshartValue,
            "current_value" => $currentWeight,
            "value_change" => abs($weightChange),
            "value_change_countas" => $valPlus,
            "logs" => $getListWithLastIDs,
            "machines" => $machines->name ?? "N/A"
        ];

        return $resp;
    }

    public function getStrengthTypes(Request $request)
    {
        return generateStrengthTypes();
    }

    public function storeRecipeIngredients(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'recipetype' => 'required',
            'recipename' => 'required',
            'calories' => 'required',
            'protein' => 'required',
            'crabs' => 'required',
            'fats' => 'required',
            'qty' => 'required',
            'description' => 'required',
            'foodtype' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }
        $loggdin_id = Auth::user()->id;

        $ins_query = array(
            "c_by" => $loggdin_id,
            'type' => $request->recipetype,
            'name' => $request->recipename,
            'calories' => $request->calories,
            'protein' => $request->protein,
            'crabs' => $request->crabs,
            'fats' => $request->fats,
            'qty' => $request->qty,
            'description' => $request->description,
            'foodtype' => $request->foodtype
        );

        RecipeIngredient::insert($ins_query);

        return response()->json(["status" => "success", "message" => "Recipe Item Created"], 200);
    }

    public function logFoodFromIngredients(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ingredient_ids' => 'required',
            'ingredient_weight' => 'required',
            'is_added_to_my_meal' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        if ($request->is_added_to_my_meal == 'true') {
            $validator = Validator::make($request->all(), [
                'recipename' => 'required',
                'which_time' => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json($validator->errors());
            }
        }
        // Optional Fields
        //recipename
        //which_time
        if (!is_array($request->ingredient_ids)) {
            $ids = json_decode($request->ingredient_ids);
        } else {
            $ids = $request->ingredient_ids;
        }

        $ingredients = RecipeIngredient::whereIn('id', $ids)->get()->groupBy('id')->toArray();

        $calories = 0;
        $protein = 0;
        $crabs = 0;
        $fats = 0;
        if (!is_array($request->ingredient_weight)) {
            $weight_int = json_decode($request->ingredient_weight);
        } else {
            $weight_int = $request->ingredient_weight;
        }
        // foreach($ids as $index => $ingIdx){
        //     $getIngredient = $ingredients[$ingIdx][0];
        //     if($getIngredient['qty']=='qty'){
        //         $calc = $getIngredient['calories']*intval($weight_int[$index]);
        //         $pro = $getIngredient['protein']*intval($weight_int[$index]);
        //         $crab = $getIngredient['crabs']*intval($weight_int[$index]);
        //         $fat = $getIngredient['fats']*intval($weight_int[$index]);
        //     } else {
        //         $calc = ($getIngredient['calories']/$getIngredient['qty'])*intval($weight_int[$index]);
        //         $pro = ($getIngredient['protein']/$getIngredient['qty'])*intval($weight_int[$index]);
        //         $crab = ($getIngredient['crabs']/$getIngredient['qty'])*intval($weight_int[$index]);
        //         $fat = ($getIngredient['fats']/$getIngredient['qty'])*intval($weight_int[$index]);
        //     }
        //     $calories += $calc;
        //     $protein += $pro;
        //     $crabs += $crab;
        //     $fats += $fat;
        // }

        // $getResp = [
        //     "calories" => round($calories),
        //     "protein" => round($protein),
        //     "crabs" => round($crabs),
        //     "fats" => round($fats),
        // ];

        // return $getResp;
        if ($request->is_added_to_my_meal == 'true') {
            $loggdin_id = Auth::user()->id;
            $recipe_steps = array();
            foreach ($ids as $index => $recipe) {
                $recipeIngredient = RecipeIngredient::where('id', $recipe)->first();
                array_push($recipe_steps, array(
                    "id" => $ids[$index],
                    "name" => ($recipeIngredient->name ?? ''),
                    "qty" => $weight_int[$index],
                    "type" => ($recipeIngredient->type ?? ''),
                    "note" => ($recipeIngredient->description ?? '')
                ));
            }
            $ins_query = array(
                "user_id" => $loggdin_id,
                "name" => $request->recipename,
                "recipe_ingredients" => json_encode($ids),
                "recipe_steps" => json_encode($recipe_steps),
            );
            $getRecipeSaved = RecipeList::create($ins_query);
            if (!empty($getRecipeSaved)) {
                $recipelog = [
                    "recipes" => '[' . $getRecipeSaved->id . ']',
                    "user_id" => $loggdin_id,
                    "date" => date('Y-m-d'),
                    "log_as" => $request->record_as,
                    "log_type" => 1
                ];
                RecipeLog::insert($recipelog);
            }
            $is_favorite = $request->which_time == 'favorite' ? true : false;
            $is_breakfast = $request->which_time == 'breakfast' ? true : false;
            $is_lunch = $request->which_time == 'lunch' ? true : false;
            $is_snacks = $request->which_time == 'snacks' ? true : false;
            $is_dinner = $request->which_time == 'dinner' ? true : false;
            UserRecipeList::insert([
                "user_id" => $loggdin_id,
                "recipe_id" => $getRecipeSaved->id,
                "is_favorite" => ($is_favorite ?? 0),
                "is_breakfast" => ($is_breakfast ?? 0),
                "is_lunch" => ($is_lunch ?? 0),
                "is_snacks" => ($is_snacks ?? 0),
                "is_dinner" => ($is_dinner ?? 0)
            ]);
            return response()->json(["status" => "success", "message" => "Meal Logged & Added To Your Meal"], 200);
        }
        $loggdin_id = Auth::user()->id;
        $recipe_steps = array();
        foreach ($ids as $index => $recipe) {
            $recipeIngredient = RecipeIngredient::where('id', $recipe)->first();
            array_push($recipe_steps, array(
                "id" => $ids[$index],
                "name" => ($recipeIngredient->name ?? ''),
                "qty" => $weight_int[$index],
                "type" => ($recipeIngredient->type ?? ''),
                "note" => ($recipeIngredient->description ?? '')
            ));
        }
        $ins_query = array(
            "user_id" => $loggdin_id,
            "name" => $request->recipename,
            "date" => date('Y-m-d'),
            "recipe_ingredients" => json_encode($ids),
            "recipe_steps" => json_encode($recipe_steps),
        );
        $getRecipeSaved = RecipeLogList::create($ins_query);
        if (!empty($getRecipeSaved)) {
            $recipelog = [
                "recipes" => '[' . $getRecipeSaved->id . ']',
                "user_id" => $loggdin_id,
                "date" => date('Y-m-d'),
                "log_as" => $request->record_as,
                "log_type" => 2
            ];
            RecipeLog::insert($recipelog);
            return response()->json(["status" => "success", "message" => "Recipe Log Successfully."], 200);
        }
        return response()->json(["status" => "error", "message" => "Something went wrong!"], 200);
    }

    public function logMealFromMealList(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'meal_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors());
        }

        $isRecipeExist = RecipeList::where('id', $request->meal_id)->exists();
        if (!$isRecipeExist) {
            return response()->json(["status" => "error", "message" => "Recipe Not Found."], 200);
        }
        $loggdin_id = Auth::user()->id;
        $isRecipeSavedInMeals = UserRecipeList::where('recipe_id', $request->meal_id)->where('user_id', $loggdin_id)->exists();
        if (!$isRecipeSavedInMeals) {
            return response()->json(["status" => "error", "message" => "Recipe not saved to my meal."], 200);
        }

        $recipelog = [
            "recipes" => '[' . $request->meal_id . ']',
            "user_id" => $loggdin_id,
            "date" => date('Y-m-d')
        ];
        RecipeLog::insert($recipelog);
        return response()->json(["status" => "success", "message" => "Recipe Log Successfully."], 200);
    }

    public function getMachineType()
    {
        $workoutLogs = WorkoutLog::distinct('workout_days_uuid')->pluck('workout_days_uuid');
        if (!empty($workoutLogs)) {
            $workoutDays = WorkoutDay::whereIn('uuid', $workoutLogs)->distinct('exercise_machine')->pluck('exercise_machine');
            if (!empty($workoutDays)) {
                $machines = ExerciseMachine::whereIn('uuid', $workoutDays)->get();
                if (count($machines) > 0) {
                    return response()->json(['status' => "success", "machines" => $machines]);
                }
            }
        }

        $machines = ExerciseMachine::get();
        return response()->json(['status' => "success", "machines" => $machines]);
    }
    // recipeIngredients
    //storeRecipeIngredients
    //logFoodFromIngredients

    // public function storeRecipeIngredients(Request $request)
    //     {
    //         $loggdin_id = Auth::user()->id;
    //         $recipe_steps = array();
    //         foreach($request->ingredient_id as $index => $recipe){
    //             $recipeIngredient = RecipeIngredient::where('id',$recipe)->first();
    //             array_push($recipe_steps,array(
    //                 "id"=>$request->ingredient_id[$index],
    //                 "name"=>$recipeIngredient->name??'',
    //                 "qty"=>$request->ingredient_qty[$index],
    //                 "type"=>$request->ingredient_type[$index],
    //                 "note"=>$request->ingredient_note[$index]
    //             ));
    //         }
    //         $ins_query = array(
    //             "user_id"=>$loggdin_id,
    //             "name"=>$request->recipename,
    //             "type"=>$request->recipetype,
    //             "description"=>$request->recipedesc,
    //             "recipe_ingredients"=>json_encode($request->ingredient_id),
    //             "recipe_steps"=>json_encode($recipe_steps),
    //         );
    //         $getRecipeSaved = RecipeList::create($ins_query);
    //         $is_favorite = $request->chooseMealAsMyMeal=='favorite'?true:false; 
    //         $is_breakfast = $request->chooseMealAsMyMeal=='breakfast'?true:false; 
    //         $is_lunch = $request->chooseMealAsMyMeal=='lunch'?true:false;
    //         $is_snacks = $request->chooseMealAsMyMeal=='snacks'?true:false;
    //         $is_dinner = $request->chooseMealAsMyMeal=='dinner'?true:false;
    //         UserRecipeList::insert([
    //             "user_id"=>$loggdin_id,
    //             "recipe_id"=>$getRecipeSaved->id,
    //             "is_favorite"=>($is_favorite??0),
    //             "is_breakfast"=>($is_breakfast??0),
    //             "is_lunch"=>($is_lunch??0),
    //             "is_snacks"=>($is_snacks??0),
    //             "is_dinner"=>($is_dinner??0)
    //         ]);
    //         return response()->json(["status"=>"success","message"=>"Recipe Created & Added To Your Meal"],200);
    //     }
}
