<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use App\Models\Plan;
use App\Models\Slide;
use App\Models\Language;
use App\Models\MealPicture;
use App\Models\ExerciseVideoCategory;
use App\Models\ExerciseVideos;
use App\Models\ConsultationQuery;
use App\Models\CallRequest;
use App\Models\WeeklyUpdateForm;
use App\Models\HelpSupport;
use App\Models\WeightLog;
use App\Models\InfoContact;
use App\Models\UserTrainee;
use App\Models\Chat;
use App\Models\Meditation;
use App\Models\CustomUpdates;
use App\Models\RecipeGuideList;
use \Google_Client;
use Google_Service_Fitness;
use App\Models\RecipeCategories;

use Google_Service_Oauth2;

use App\Models\WorkoutDay;
use App\Models\WorkoutPlan;
use App\Models\WorkoutPlanDay;
use App\Models\RecipeList;
use App\Models\UserFavRecipe;
use App\Models\MeditationList;
use App\Models\FormBuilderWorkout;
use App\Models\MeditationDeepSleep;
use App\Models\Role;
use App\Models\City;
use App\Models\UserrAlter;
use App\Models\Permission;
use App\Models\RequestPremium;
use App\Models\MyReminder;
use App\Models\FormBuilderGuide;
use App\Models\UserWorkout;
use App\Models\FormBuilderUpload;
use App\Models\WorkoutLog;
use App\Models\Physique;
use App\Models\RecipeIngredient;
use App\Models\BodyMeasurment;
use App\Models\ChatBroadcast;
use App\Models\BroadcastMessage;
use App\Models\RecipeLog;
use App\Models\RecipeLogList;
use App\Models\WeeklyUpdate;
use App\Models\ExerciseMachine;
use App\Models\MeditationCategories;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use File;
use Symfony\Component\Mime\MimeTypes;
class MainController extends Controller
{
    // if(permission('app_users','read')){
    // }
    // return redirect(route('dashboard'))->with('error',"Unauthorized");
    public function adminUsersView()
    {
        if (permission('admin_users', 'read')) {
            $user = User::whereNotIn('role', ['appuser'])->orderBy('id', 'desc')->paginate(10);
            $role = Role::whereNot('name', 'admin')->get();
            return view('admin.users', compact('user', 'role'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function appUsersView()
    {
        if (permission('app_users', 'read')) {
            $plans = Plan::active()->get();
            // $user = User::whereIn('role',['appuser'])->orderBy('id','desc')->paginate(10);
            return view('admin.app-users', compact('plans'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function appPlansView()
    {
        if (permission('plans', 'read')) {
            $plans = Plan::paginate(10);
            // foreach($plans as $list)
            // {
            //     $list->permissions = json_decode($list->permissions);
            //     $list->features = json_decode($list->features);
            //     $list->final_price = $list->amount * ( (100-$list->discount) / 100 );
            // }
            return view('admin.plans', compact('plans'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");

    }

    public function appSlidesView()
    {
        if (permission('slides', 'read')) {
            $slides = Slide::orderBy('id', 'desc')->paginate(10);
            return view('admin.app-slides', compact('slides'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function appLanguagesView()
    {
        if (permission('language', 'read')) {
            $language = Language::paginate(10);
            return view('admin.app-language', compact('language'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function storeNewAdminUser(Request $request)
    {
        if (permission('admin_users', 'create')) {
            $is_exist = User::where('email', $request->my_email)->exists();
            if ($is_exist) {
                return redirect(route("admin-users"))->with("error", "Email Already Registed with us");
            }
            $ins_query = [
                "name" => $request->myname,
                "email" => $request->my_email,
                "password" => Hash::make($request->confirm_password),
                "dob" => $request->dob,
                "role" => $request->role,
                "phone" => $request->mobile_no
            ];
            User::insert($ins_query);

            return redirect(route("admin-users"))->with("success", "User Added");
        }
        return redirect(route('admin-users'))->with('error', "Unauthorized");
    }

    public function updateNewAdminUser(Request $request)
    {
        if (permission('admin_users', 'create')) {
            $is_exist = User::where('id', '<>', $request->id)->where('email', $request->my_email)->exists();
            if ($is_exist) {
                return redirect(route("admin-users"))->with("error", "Email Already Assigned to Another User");
            }
            $getRec = User::where('id', $request->id)->first();
            if ($request->has('my_email')) {
                $getRec->email = $request->my_email;
            }
            if ($request->has('myname')) {
                $getRec->name = $request->myname;
            }
            if ($request->has('dob')) {
                $getRec->dob = $request->dob;
            }
            if ($request->has('role')) {
                $getRec->role = $request->role;
            }
            if ($request->has('mobile_no')) {
                $getRec->phone = $request->mobile_no;
            }
            $getRec->save();

            return redirect(route("admin-users"))->with("success", "User Details Updated");
        }
        return redirect(route('admin-users'))->with('error', "Unauthorized");
    }

    public function storeAppAdminUser(Request $request)
    {
        if (permission('app_users', 'create')) {
            $is_exist = User::where('email', $request->email)->exists();
            if ($is_exist) {
                return redirect(route("app-users"))->with("error", "Email Already Registed with us");
            }
            $is_sub = 0;
            $plan = Plan::find($request->paid_plan);
            $final_price = $plan->amount * ((100 - $plan->discount) / 100);
            if ($final_price > 0) {
                $is_sub = 1;
            }
            $ins_query = [
                "name" => $request->myname,
                "email" => $request->email,
                "password" => Hash::make($request->confirm_password),
                "dob" => $request->dob,
                "role" => 'appuser',
                "mobile_no" => $request->mobileno,
                "plan_id" => $request->paid_plan,
                "is_subscription" => $is_sub
            ];
            User::insert($ins_query);

            return redirect(route("app-users"))->with("success", "User Added");
        }
        return redirect(route('app-users'))->with('error', "Unauthorized");
    }

    public function exerciseCategories()
    {
        if (permission('exercise_category', 'read')) {
            $categories = ExerciseVideoCategory::orderBy('id', 'desc')->paginate(10);
            return view('admin.exercise.exercise-categories', compact('categories'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function exerciseVideos()
    {
        if (permission('exercise_videos', 'read')) {
            $videos = ExerciseVideos::with('exercise_video_category')->paginate(10);
            foreach ($videos as $list) {
                $list->cat = ExerciseVideoCategory::find($list->exercise_video_categories_id);
            }
            $cat = ExerciseVideoCategory::orderBy('id', 'desc')->where('is_active', 1)->get();
            return view('admin.exercise.exercise-videos', compact('videos', 'cat'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function consultationRequests()
    {
        if (permission('consultation_request', 'read')) {
            $query = ConsultationQuery::where('status', '<>', '2')->with('user')->paginate(10);
            return view('admin.requests.consultation_request', compact('query'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function callRequests()
    {
        if (permission('call_request', 'read')) {
            $query = CallRequest::where('status', '<>', '3')->with('user')->orderBy('id', 'desc')->paginate(10);
            return view('admin.requests.call_request', compact('query'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function mealPictures()
    {
        if (permission('meal_picture', 'read')) {
            $users = User::select('id', 'name', 'email')->where('role', 'appuser')->get();
            return view('admin.meal.meal_picture', compact('users'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function saveSliderImage(Request $request)
    {
        if (permission('slides', 'create')) {
            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/appslides/', $fileName);
            }
            Slide::insert([
                "title" => $request->title,
                "file_path" => $fileName,
                "status" => 2
            ]);

            return redirect()->back()
                ->with('success', 'You have successfully upload slider image.');
        }

    }
    // exercise_cats
    public function saveExerciseCategory(Request $request)
    {
        if (permission('exercise_category', 'create')) {
            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/exercise_cats/', $fileName);
            }
            $uuid = Str::uuid()->toString();
            ExerciseVideoCategory::insert([
                "name" => $request->myname,
                "image" => $fileName,
                "is_active" => 2,
                "uuid" => $uuid
            ]);

            return redirect()->back()
                ->with('success', 'Exercise category add successfully.');
        }

    }
    public function saveExerciseVideos(Request $request)
    {
        if (permission('exercise_videos', 'create')) {
            $fileName = '';
            if (request()->hasFile('thumb_img')) {
                $file = request()->file('thumb_img');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/exercise_vid_thumb/', $fileName);
            }

            ExerciseVideos::insert([
                "name" => $request->name,
                "desc" => $request->desc,
                "duration" => $request->duration,
                "video_type" => $request->videotype,
                "thumbnail_image" => $fileName,
                "file_path" => $request->url,
                "status" => 2,
                "exercise_video_categories_id" => $request->cat
            ]);

            return redirect()->back()
                ->with('success', 'Exercise videos add successfully.');
        }

    }

    public function mealPicturesChangeStatus(Request $request, $status, $uid)
    {
        if (permission('meal_picture', 'update')) {

            $picture = MealPicture::where('id', $uid)->with('user')->first();
            if (empty($picture)) {
                return redirect()->back()->with('error', "Something went wrong");
            }
            switch ($status) {
                case 'approve':
                    $picture->is_active = 1;
                    $picture->is_approved = 1;
                    break;
                case 'retake':
                    $picture->is_active = 1;
                    $picture->is_approved = 0;
                    $picture->need_retake = 1;
                    notify_user($picture->uuid, "Need To Be Retake Meal Picture", "Meal Picture not accepted or blur, retake image.");
                    break;
                case 'reject':
                    $picture->is_active = 2;
                    break;
                default:
                    return redirect(route('meal-picture'))->with('error', "Something went wrong");
                    break;
            }

            if ($picture->save()) {
                return redirect()->back()->with('success', "Meal Picture Status Changed Successfully");
            }
            return redirect()->back()->with('error', "Something went wrong");

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function mealPicturesApprove(Request $request, $status, $uid)
    {
        if (permission('meal_picture', 'update')) {

            $picture = MealPicture::where('id', $uid)->with('user')->first();
            if (empty($picture)) {
                return response()->json(['status' => 'error', "message" => "Something went wrong"]);
            }

            // $values = json_decode($request->val);
            // $picture->calories = $values->calories;
            // $picture->protein = $values->protein;
            // $picture->crabs = $values->crabs;
            // $picture->fat = $values->fat;


            switch ($status) {
                case 'approve':
                    $picture->is_active = 1;
                    $picture->is_approved = 1;
                    break;
                case 'retake':
                    $picture->is_active = 1;
                    $picture->is_approved = 0;
                    $picture->need_retake = 1;
                    notify_user($picture->uuid, "Need To Be Retake Meal Picture", "Meal Picture not accepted or blur, retake image.");
                    break;
                case 'reject':
                    $picture->is_active = 2;
                    break;
                default:
                    return response()->json(['status' => 'error', "message" => "Something went wrong"]);
                    break;
            }
            $picture->star = $request->star;
            if ($picture->save()) {
                return response()->json(['status' => 'success', "message" => "Meal Picture Status Changed Successfully"]);
            }
            return response()->json(['status' => 'error', "message" => "Something went wrong"]);

        }
        return response()->json(['status' => 'error', "message" => "Unauthroized"]);
    }

    public function callRequestsChangeStatus(Request $request, $status, $uid)
    {
        if (permission('call_request', 'update')) {

            $picture = CallRequest::where('id', $uid)->with('user')->first();
            if (empty($picture)) {
                return redirect(route('call-request'))->with('error', "Something went wrong");
            }
            switch ($status) {
                case 'complete':
                    $picture->status = 2;
                    break;
                case 'delete':
                    $picture->status = 3;
                    break;
                default:
                    return redirect(route('call-request'))->with('error', "Something went wrong");
                    break;
            }

            if ($picture->save()) {
                return redirect(route('call-request'))->with('success', "Status Changed Successfully");
            }
            return redirect(route('call-request'))->with('error', "Something went wrong");

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function consultationRequestsChangeStatus(Request $request, $status, $uid)
    {
        if (permission('consultation_request', 'update')) {

            $picture = ConsultationQuery::where('id', $uid)->with('user')->first();
            if (empty($picture)) {
                return redirect(route('consultation-request'))->with('error', "Something went wrong");
            }
            switch ($status) {
                case 'complete':
                    $picture->status = 1;
                    break;
                case 'delete':
                    $picture->status = 2;
                    break;
                default:
                    return redirect(route('consultation-request'))->with('error', "Something went wrong");
                    break;
            }

            if ($picture->save()) {
                return redirect(route('consultation-request'))->with('success', "Status Changed Successfully");
            }
            return redirect(route('consultation-request'))->with('error', "Something went wrong");

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function weeklyUpdates()
    {
        if (permission('weekly_update', 'read')) {
            // $query = WeeklyUpdate::with('user')->orderBy('id','desc')->paginate(10);
            $users = User::select('id', 'name', 'email')->where('role', 'appuser')->get();
            return view('admin.updates.weekly_update', compact('users'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function weeklyUpdatesChangeStatus(Request $request, $status, $uid)
    {
        if (permission('weekly_update', 'update')) {

            $picture = WeeklyUpdateForm::where('id', $uid)->with('user')->first();
            if (empty($picture)) {
                return redirect()->back()->with('error', "Something went wrong");
            }
            switch ($status) {
                case 'complete':
                    $picture->status = 1;
                    break;
                case 'delete':
                    $picture->status = 2;
                    break;
                default:
                    return redirect()->back()->with('error', "Something went wrong");
                    break;
            }

            if ($picture->save()) {
                return redirect()->back()->with('success', "Weekly Form Status Changed Successfully");
            }
            return redirect()->back()->with('error', "Something went wrong");

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }


    public function helpQueries()
    {
        if (permission('help_queries', 'read')) {
            $query = HelpSupport::where('status', '<>', '3')->with('user')->orderBy('id', 'desc')->paginate(10);
            return view('admin.help.query', compact('query'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function contactInfo()
    {
        if (permission('contact_info', 'read')) {
            $cont = InfoContact::where('is_active', '<>', '3')->orderBy('id', 'desc')->paginate(10);
            return view('admin.help.contact_info', compact('cont'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function storeContactInfo(Request $request)
    {
        if (permission('contact_info', 'create')) {
            $ins_query = [
                "html" => $request->html
            ];
            InfoContact::insert($ins_query);
            return redirect(route("contact-info"))->with("success", "Contact Information Added");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function deleteContactInfo(Request $request, $id)
    {
        if (permission('contact_info', 'delete')) {
            $info = InfoContact::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("contact-info"))->with("success", "Contact Information Deleted");
            } else {
                return redirect(route("contact-info"))->with("error", "Contact information not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function statusContactInfo(Request $request, $id)
    {
        if (permission('contact_info', 'update')) {
            $info = InfoContact::whereId($id)->first();
            if (!empty($info)) {
                if ($info->is_active == 0) {
                    $info->is_active = 1;
                } else {
                    $info->is_active = 0;
                }

                $info->save();
                return redirect(route("contact-info"))->with("success", "Contact Information Status Changed");
            } else {
                return redirect(route("contact-info"))->with("error", "Contact information not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function updateContactInfo(Request $request, $id)
    {
        if (permission('contact_info', 'update')) {
            $info = InfoContact::whereId($id)->first();
            if (!empty($info)) {
                $info->html = $request->html;
                $info->save();
                return redirect(route("contact-info"))->with("success", "Contact Information Updated");
            } else {
                return redirect(route("contact-info"))->with("error", "Contact information not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function helpQueriesChangeStatus(Request $request, $status, $uid)
    {
        if (permission('help_queries', 'update')) {

            $qry = HelpSupport::where('id', $uid)->with('user')->first();
            if (empty($qry)) {
                return redirect(route('help-queries'))->with('error', "Something went wrong");
            }
            switch ($status) {
                case 'complete':
                    $qry->status = 1;
                    break;
                case 'delete':
                    $qry->status = 2;
                    break;
                default:
                    return redirect(route('help-queries'))->with('error', "Something went wrong");
                    break;
            }

            if ($qry->save()) {
                return redirect(route('help-queries'))->with('success', "Status Changed Successfully");
            }
            return redirect(route('help-queries'))->with('error', "Something went wrong");

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function statusExerciseVideos(Request $request, $id)
    {
        if (permission('exercise_videos', 'update')) {
            $info = ExerciseVideos::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect(route("exercise-videos"))->with("success", "Exercise Video Status Changed");
            } else {
                return redirect(route("exercise-videos"))->with("error", "Exercise Video not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteExerciseVideos(Request $request, $id)
    {
        if (permission('exercise_videos', 'delete')) {
            $info = ExerciseVideos::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("exercise-videos"))->with("success", "Exercise Video Deleted");
            } else {
                return redirect(route("exercise-videos"))->with("error", "Exercise Video not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function updateExerciseVideos(Request $request, $id)
    {
        if (permission('exercise_videos', 'update')) {
            $info = ExerciseVideos::whereId($id)->first();
            if (!empty($info)) {
                $fileName = '';
                if (request()->hasFile('thumb_img')) {
                    $file = request()->file('thumb_img');
                    $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                    $file->move(storage_path() . '/exercise_vid_thumb/', $fileName);
                    $info->thumbnail_image = $fileName;
                }
                $info->name = $request->name;
                $info->desc = $request->desc;
                $info->duration = $request->duration;
                $info->file_path = $request->url;
                $info->exercise_video_categories_id = $request->cat;
                $info->video_type = $request->videotype;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Exercise videos update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Exercise videos not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteExerciseCategory(Request $request, $id)
    {
        if (permission('exercise_category', 'delete')) {
            $vid = ExerciseVideos::where('exercise_video_categories_id', $id)->first();
            if (!empty($vid)) {
                return redirect(route("exercise-categories"))->with("error", "Exercise categories assgin to exercise videos");
            }
            $info = ExerciseVideoCategory::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("exercise-categories"))->with("success", "Exercise Categories Deleted");
            } else {
                return redirect(route("exercise-categories"))->with("error", "Exercise Categories not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateExerciseCategory(Request $request, $id)
    {
        if (permission('exercise_category', 'update')) {

            $info = ExerciseVideoCategory::whereId($id)->first();
            if (!empty($info)) {
                $fileName = '';
                if (request()->hasFile('image')) {
                    $file = request()->file('image');
                    $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                    $file->move(storage_path() . '/exercise_cats/', $fileName);
                    $info->image = $fileName;
                }
                $info->name = $request->myname;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Exercise categories update successfully.');

            } else {
                return redirect()->back()
                    ->with("error", "Exercise categories not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function statusExerciseCategory(Request $request, $id)
    {
        if (permission('exercise_category', 'update')) {
            $info = ExerciseVideoCategory::whereId($id)->first();
            if (!empty($info)) {
                if ($info->is_active == 0) {
                    $vid = ExerciseVideos::where('exercise_video_categories_id', $id)->first();
                    if (!empty($vid)) {
                        return redirect(route("exercise-categories"))->with("error", "Exercise categories assgin to exercise videos");
                    }
                    $info->is_active = 1;
                } else if ($info->is_active == 2) {
                    $info->is_active = 1;
                } else {
                    $info->is_active = 0;
                }

                $info->save();
                return redirect(route("exercise-categories"))->with("success", "Exercise Video Status Changed");
            } else {
                return redirect(route("exercise-categories"))->with("error", "Exercise Video not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function statusAppLanguage(Request $request, $id)
    {
        if (permission('language', 'update')) {
            $info = Language::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect(route("app-languages"))->with("success", "Language Status Changed");
            } else {
                return redirect(route("app-languages"))->with("error", "Language not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function storeAppLanguage(Request $request)
    {
        if (permission('language', 'create')) {
            $fileName = '';
            if (request()->hasFile('lang_file')) {
                $file = request()->file('lang_file');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/lang_file' . '/', $fileName);

            }
            $ins_query = [
                "name" => $request->name,
                "file_path" => $fileName
            ];
            Language::insert($ins_query);
            return redirect(route("app-languages"))->with("success", "Language File Added");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateAppLanguage(Request $request, $id)
    {
        if (permission('language', 'update')) {
            $info = Language::whereId($id)->first();
            if (!empty($info)) {
                $fileName = '';
                if (request()->hasFile('thumb_img')) {
                    $file = request()->file('lang_file');
                    $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                    $file->move(storage_path() . '/lang_file' . '/', $fileName);
                    $info->file_path = $fileName;
                }
                $info->name = $request->name;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Language update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Language not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function statusAppSlides(Request $request, $id)
    {
        if (permission('slides', 'update')) {
            $info = Slide::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect(route("app-slides"))->with("success", "Slides Status Changed");
            } else {
                return redirect(route("app-slides"))->with("error", "Slides not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function deleteAppSlides(Request $request, $id)
    {
        if (permission('slides', 'delete')) {
            $info = Slide::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("app-slides"))->with("success", "Slide Deleted");
            } else {
                return redirect(route("app-slides"))->with("error", "Slide not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateAppSlides(Request $request, $id)
    {
        if (permission('slides', 'update')) {
            $info = Slide::whereId($id)->first();
            if (!empty($info)) {
                $fileName = '';
                if (request()->hasFile('image')) {
                    $file = request()->file('image');
                    $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                    $file->move(storage_path() . '/appslides' . '/', $fileName);
                    $info->file_path = $fileName;
                }
                $info->title = $request->title;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Slide update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Slide not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function appPlansDisable(Request $request, $id)
    {
        if (permission('plans', 'disable')) {
            $plan = Plan::whereId($id)->first();
            if (!empty($plan)) {
                $plan->status = !$plan->status;
                $plan->save();

                return redirect()->back()
                    ->with('success', 'Plan status successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Plan not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function appPlansUpdate(Request $request, $id)
    {
        if (permission('plans', 'update')) {
            $info = Plan::whereId($id)->first();

            if (!empty($info)) {
                $permissions = json_decode($info->permissions);
                $info->name = $request->name;
                $info->amount = $request->price;
                $info->discount = $request->discount;
                $info->description = $request->description;
                $per = "{";
                foreach ($permissions as $idx => $list) {
                    $myTrue = false;
                    foreach ($request->permissions as $slist) {
                        if ($idx == $slist) {
                            $myTrue = true;
                        }
                    }
                    if ($myTrue) {
                        $per .= '"' . $idx . '":true,';
                    } else {
                        $per .= '"' . $idx . '":false,';
                    }
                }
                $per = substr($per, 0, -1);
                $per .= "}";
                $info->permissions = $per;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Plan update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Plan not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function appUsersDisable(Request $request, $id)
    {
        if (permission('app_users', 'update')) {
            $user = user::whereId($id)->first();
            if (!empty($user)) {
                $user->status = !$user->status;
                $user->save();

                return redirect()->back()
                    ->with('success', 'User status updated.');
            } else {
                return redirect()->back()
                    ->with("error", "User not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function appUsersDelete(Request $request, $id)
    {
        if (permission('app_users', 'update')) {
            $user = user::whereId($id)->first();
            if (!empty($user)) {
                $user->delete();
                return redirect()->back()
                    ->with('success', 'User Deleted.');
            } else {
                return redirect()->back()
                    ->with("error", "User not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function usersDisable(Request $request, $id)
    {
        if (permission('admin_users', 'update')) {
            $user = user::whereId($id)->first();
            if (!empty($user)) {
                $user->status = !$user->status;
                $user->save();

                return redirect()->back()
                    ->with('success', 'User status updated.');
            } else {
                return redirect()->back()
                    ->with("error", "User not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function usersDelete(Request $request, $id)
    {
        if (permission('admin_users', 'update')) {
            $user = user::whereId($id)->first();
            if (!empty($user)) {
                $user->delete();
                return redirect()->back()
                    ->with('success', 'User Deleted.');
            } else {
                return redirect()->back()
                    ->with("error", "User not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function usersPassword(Request $request)
    {
        if (permission('admin_users', 'update')) {
            $user = User::whereId($request->id)->first();
            if (!empty($user)) {
                $user->password = Hash::make($request->password);
                $user->save();
                return response()->json(['message' => 'User password changed.', 'type' => 'success']);
            } else {
                return response()->json(['message' => 'User not found', 'type' => 'error']);
            }
        }
        return response()->json(['message' => 'Unauthorized']);
    }
    public function assignedUsers(Request $request, $id)
    {
        if (permission('admin_users', 'trainee')) {
            if ($id == 'own' || Auth::user()->role == 'user') {
                $m_id = Auth::user()->id;
            } else {
                $m_id = $id;
            }
            $assigned_trainee = UserTrainee::where('user_id', $m_id)->pluck('trainee_user_id');
            $user = User::where('role', 'appuser')->whereIn('id', $assigned_trainee)->where('is_subscription', 1)->orderBy('id', 'desc')->paginate(10);
            $isolated_trainee = User::where('role', 'appuser')->where('is_subscription', 1)->whereNotIn('id', UserTrainee::distinct('trainee_user_id')->pluck('trainee_user_id')->all())->where('status', 1)->orderBy('id', 'desc')->get();
            $iod = $id;
            return view('admin.trainer.trainee-list', compact('user', 'isolated_trainee', 'iod'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function addAssignedUsers(Request $request, $id)
    {
        if (permission('admin_users', 'trainee')) {
            if ($id == 'own' || Auth::user()->role == 'user') {
                $m_id = Auth::user()->id;
            } else {
                $m_id = $id;
            }
            foreach ($request->assignuser as $list) {
                UserTrainee::insert([
                    "user_id" => $m_id,
                    "trainee_user_id" => $list
                ]);
            }
            return redirect(route('assigned-users', ['id' => $id]))->with('success', "Selected User Assigned");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function unassignUsers(Request $request, $id)
    {
        if (permission('admin_users', 'trainee')) {
            if ($id == 'own') {
                $m_id = Auth::user()->id;
            } else {
                $m_id = $id;
            }
            $userID = base64_decode($request->ids);
            UserTrainee::where('user_id', $m_id)->where('trainee_user_id', $userID)->delete();
            return redirect(route('assigned-users', ['id' => $id]))->with('success', "User Unassigned");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function appUsersSts(Request $request, $id)
    {
        if (permission('app_users', 'sts')) {
            $m_id = Auth::user()->id;
            $is_exist = UserTrainee::where('user_id', $m_id)->where('trainee_user_id', $id)->exists();
            // if(!empty($is_exist) || Auth::user()->role=="admin"){
            $userDetail = User::where('id', $id)->with('plan')->first();

            if ($userDetail->role != "appuser") {
                return redirect(route('app-users', ['id' => $id]))->with('error', "Internal Users not shows app users statistics");
            }
            if (empty($userDetail->plan_id)) {
                $userDetail->plan = Plan::where('amount', 0)->first();
            }
            if (!empty($userDetail->language)) {
                $userLanguage = Language::find($userDetail->language);
                $userDetail->lang = $userLanguage;
            }
            if (!empty($userDetail->location)) {
                $getDecodeLoc = explode('|', $userDetail->location);
                if (count($getDecodeLoc) > 0) {
                    if ($getDecodeLoc[0] == 'country') {
                        $getCityDecode = explode('^', $userDetail->location);
                        if (count($getCityDecode) == 3) {
                            $getCountry = City::where('id', $getCityDecode[2])->with('state.country')->first();
                            $userDetail->city = $getCountry;
                        }
                    } else if ($getDecodeLoc[0] == 'latitude') {
                        $getCityDecode = explode('^', $getDecodeLoc[1]);
                        if (count($getCityDecode) == 2) {
                            $getCountry = "lat:" . $getCityDecode[0] . " long:" . $getCityDecode[1];
                            $userDetail->latitude = $getCountry;
                        }
                    }
                }
            }
            //    return $userDetail;
            $allplans = Plan::where('status', 1)->get();
            $between = [date('H:i', strtotime('now')), date('H:i', strtotime('+12 hours'))];
            $myReminder = MyReminder::where('user_id', $id)->get();
            $missedDays = array();
            for ($i = 0; $i <= 6; $i++) {
                $day = '-' . $i . ' days';
                $mDate = date('d M Y', strtotime($day, strtotime('now')));
                $missed = MealPicture::where('user_id', $id)->where('date', date('Y-m-d', strtotime($day)))->whereIsActive(1)->exists();
                if (!$missed) {
                    array_push($missedDays, array('date' => $mDate, 'is_missed' => $missed));
                }
            }

            //Assgined Workouts
            $assignedWorkouts = WorkoutPlan::where('user_id', $id)->get();

            //Form Uploaded
            $formBuilderUpload = FormBuilderUpload::where('user_id', $id)->get();
            foreach ($formBuilderUpload as $list) {
                $list->workoutplan = WorkoutPlan::find($list->workout_id);
            }
            //Meal Picture Approval
            $mealPictureApproval = MealPicture::where('user_id', $id)->where("is_active", 1)->where("is_approved", 0)->get();

            //Weekly Update
            $weeklyUpdateForm = WeeklyUpdate::where('user_id', $id)->get();

            //Workout Logs
            $workoutLog = WorkoutLog::where('user_id', $id)->limit(5)->orderBy('id', 'desc')->get();
            foreach ($workoutLog as $list) {
                $list->workout_days_uuid = WorkoutDay::where('uuid', $list->workout_days_uuid)->first();
                $list->plan_days_uuid = WorkoutPlanDay::where('uuid', $list->workout_days_uuid->plan_days_uuid)->first();
                $list->plans_uuid = WorkoutPlan::where('uuid', ($list->plan_days_uuid->plans_uuid ?? ''))->first();
            }

            //Physique
            $first = Physique::where('user_id', $id)->orderBy('id', 'asc')->first();
            $last = Physique::where('user_id', $id)->orderBy('id', 'desc')->first();
            if (!empty($first->image)) {
                $first->image = env('APP_URL_STR') . 'physique_uploads' . '/' . $first->image;
            }
            if (!empty($last->image)) {
                $last->image = env('APP_URL_STR') . 'physique_uploads' . '/' . $last->image;
            }

            $sts = [
                'admin_users' => User::whereIn('role', ['admin', 'user', 'subadmin'])->count(),
                'app_users' => User::where('role', 'appuser')->count(),
                'free_users' => User::where('role', 'appuser')->where('is_subscription', 0)->count(),
                'active_reminders' => count($myReminder),
                'missed_meal_7day' => count($missedDays),
                'help_support' => HelpSupport::where('user_id', $id)->where('status', 1)->count(),
                'consultation_query' => ConsultationQuery::where('user_id', $id)->where('status', 0)->count(),
                'call_request' => CallRequest::where('user_id', $id)->where('status', 1)->count(),
                'meal_picture' => count($mealPictureApproval),
                'weekly_update' => count($weeklyUpdateForm),
                'meditation' => Meditation::whereTime('time', '>=', $between[0])->orWhereTime('time', '<=', $between[1])->where('user_id', $id)->count()
            ];

            //Body Measurements
            $body_me = BodyMeasurment::where('user_id', $id)->distinct('type')->orderBy('id', 'desc')->get()->groupBy('date');

            //Is Trainer Assigned
            $is_trainer = UserTrainee::where('trainee_user_id', $id)->with('user')->first();


            //User Diet & Workout Follow Graph
            $currentDateTo = date('Y-m-d');
            // if(!empty($request->date)){
            //     $currentDateTo = date('Y-m-d',strtotime($request->date??'now'));
            // }

            $between = $this->x_week_range2($currentDateTo);
            //Days Count
            $diet_logs = MealPicture::whereBetween('date', $between)->where('user_id', $id)->where('is_approved', 1)->distinct('date')->count();
            // $total_days = (strtotime($between[1])-strtotime($between[0]))/86400;
            $total_days = ((strtotime($between[1]) - strtotime($between[0])) / 86400) + 1;
            //Total Stars
            $diet_sum = 0;
            for ($dt = 0; $dt < $total_days; $dt++) {
                $date_d = date('Y-m-d', strtotime("+" . $dt . " days", strtotime($between[0])));
                $day_stars = MealPicture::where('date', $date_d)->where('user_id', $id)->where('is_approved', 1)->sum('star');
                if ($day_stars < 15) {
                    $diet_sum += $day_stars;
                } else {
                    $diet_sum += 15;
                }
            }
            // $diet_count = MealPicture::whereBetween('date',$between)->where('user_id',$loggdinUser->id)->where('is_approved',1)->count();

            $diet_count = $total_days * 15;
            $diet_count = $diet_count == 0 ? 100 : $diet_count;

            $custom_updates_diet = CustomUpdates::whereBetween('date', $between)->where('type', 'diet')->where('user_id', $userDetail->id)->first();

            if (!empty($custom_updates_diet)) {
                $diet_follow = [
                    "follow_days" => $diet_logs,
                    "not_follow" => ($total_days - $diet_logs),
                    "follow_percent" => $custom_updates_diet->value,//round(($diet_logs/$total_days)*100),
                    "not_follow_percent" => ($custom_updates_diet->value - 100),//round((($total_days-$diet_logs)/$total_days)*100),
                    "graph" => route('getChart', ['title' => "Diet Follow", "start" => round(($diet_logs / $total_days) * 100), "end" => round((($total_days - $diet_logs) / $total_days) * 100)])
                ];
            } else {
                $diet_follow = [
                    "follow_days" => $diet_logs,
                    "not_follow" => ($total_days - $diet_logs),
                    "follow_percent" => round(($diet_count > 0 ? ($diet_sum / $diet_count) : 0) * 100),//round(($diet_logs/$total_days)*100),
                    "not_follow_percent" => (round(($diet_count > 0 ? (($diet_count - $diet_sum) / $diet_count) : 0) * 100)),//round((($total_days-$diet_logs)/$total_days)*100),
                    "graph" => route('getChart', ['title' => "Diet Follow", "start" => round(($diet_logs / $total_days) * 100), "end" => round((($total_days - $diet_logs) / $total_days) * 100)])
                ];
            }
            // $diet_follow = [    
            //     "follow_days"=>$diet_logs,
            //     "not_follow"=>($total_days-$diet_logs),
            //     "follow_percent"=>round(($diet_count>0?($diet_sum/$diet_count):0)*100),//round(($diet_logs/$total_days)*100),
            //     "not_follow_percent"=>(round(($diet_count>0?(($diet_count-$diet_sum)/$diet_count):0)*100)),//round((($total_days-$diet_logs)/$total_days)*100),
            //     "graph"=>route('getChart',['title'=>"Diet Follow","start"=>round(($diet_logs/$total_days)*100),"end"=>round((($total_days-$diet_logs)/$total_days)*100)])
            // ];

            $workout_logs_days = WorkoutLog::whereBetween('created_at', $between)->where('user_id', $id)->get()->groupBy('created_at')->count();
            $workout_logs = 0;
            for ($dt = 0; $dt < $total_days; $dt++) {
                $date_d = date('Y-m-d', strtotime("+" . $dt . " days", strtotime($between[0])));
                $day_stars = WorkoutLog::whereDate('created_at', $date_d)->distinct('workout_days_uuid')->where('user_id', $id)->count();
                if ($day_stars < 5) {
                    $workout_logs += $day_stars;
                } else {
                    $workout_logs += 5;
                }
            }
            $workout_count = $total_days * 5;

            $custom_updates_workout = CustomUpdates::whereBetween('date', $between)->where('type', 'workout')->where('user_id', $userDetail->id)->first();
            if (!empty($custom_updates_workout)) {
                $workout_follow = [
                    "follow_days" => $workout_logs_days,
                    "not_follow" => ($total_days - $workout_logs_days),
                    "follow_percent" => $custom_updates_workout->value,
                    "not_follow_percent" => ($custom_updates_workout->value - 100),
                    "graph" => route('getChart', ['title' => "Workout Follow", "start" => round(($diet_logs / $workout_count) * 100), "end" => round((($workout_count - $workout_logs) / $workout_count) * 100)])
                ];
            } else {
                $workout_follow = [
                    "follow_days" => $workout_logs_days,
                    "not_follow" => ($total_days - $workout_logs_days),
                    "follow_percent" => round(($workout_count > 0 ? ($workout_logs / $workout_count) : 0) * 100),
                    "not_follow_percent" => (round(($workout_count > 0 ? (($workout_count - $workout_logs) / $workout_count) : 0) * 100)),
                    "graph" => route('getChart', ['title' => "Workout Follow", "start" => round(($diet_logs / $workout_count) * 100), "end" => round((($workout_count - $workout_logs) / $workout_count) * 100)])
                ];
            }


            $final_graph_sts = [
                "date_from" => $between[0],
                "date_to" => $between[1],
                "date_string" => date('d M Y', strtotime($between[0])) . " - " . date('d M Y', strtotime($between[1])),
                "total_days" => $total_days,
                "diet" => $diet_follow,
                "workout" => $workout_follow
            ];




            //Current BMR CALC
            $age = round(((strtotime('now') - strtotime($userDetail->dob)) / 86400) / 365);

            $getHeightCalc = explode('_', $userDetail->height);

            $cbmr = '';
            if (count($getHeightCalc) > 1) {
                if ($getHeightCalc[1] == 'cm') {
                    //  $getH = explode('.',round((floatval($getHeightCalc[0])/30.48),2));
                    $feet = 0;
                    $inches = $getHeightCalc[0];
                    $totalheight = $inches;

                } else if ($getHeightCalc[1] == 'ft') {
                    $getH = explode('.', $getHeightCalc[0]);
                    $feet = $getH[0];
                    $inches = $getH[1];
                    $totalheight = ($inches + ($feet * 12)) * 2.54;
                }

                $getWeightCl = explode('_', $userDetail->weight);
                //  return $getWeightCl;
                $weight = 0;
                if (count($getWeightCl) > 0) {
                    if ($getWeightCl[1] == "lbs") {
                        $weight = floatval($getWeightCl[0]) / 2.205;
                    } else {
                        $weight = (int) $getWeightCl[0];
                    }
                }

                $exercise = 0;
                if ($userDetail->activity_level == "intermediate") {
                    $exercise = 1.375;
                } else if ($userDetail->activity_level == "advanced") {
                    $exercise = 1.70;
                }


                $answer = 5 + (((10 * $weight) + (6.25 * $totalheight)) - (5 * $age));
                if ($exercise > 0) {
                    $answer = $answer * $exercise;
                }
                $cbmr = round($answer);
            }

            $takenCalories = getUserCalories(date('Y-m-d', strtotime('now')), $userDetail->id);//MealPicture::whereDate('date',date('Y-m-d',strtotime('now')))->where('is_approved',1)->where('user_id',$userDetail->id)->sum('calories');

            $recipeLogs = RecipeLog::where('user_id', $userDetail->id)->whereDate('date', date('Y-m-d'))->get();
            foreach ($recipeLogs as $list) {
                if ($list->log_type == 1) {
                    $list->recipe_list = RecipeList::whereIn('id', json_decode($list->recipes))->get();
                }
                if ($list->log_type == 2) {
                    $list->recipe_list = RecipeLogList::whereIn('id', json_decode($list->recipes))->get();
                }
            }

            // return $recipeLogs;
            // return $final_graph_sts;
            return view(
                'admin.appuser.statistics',
                compact(
                    'userDetail',
                    'sts',
                    'allplans',
                    'missedDays',
                    'myReminder',
                    'assignedWorkouts',
                    'formBuilderUpload',
                    'mealPictureApproval',
                    'weeklyUpdateForm',
                    'workoutLog',
                    'first',
                    'last',
                    'body_me',
                    'is_trainer',
                    'final_graph_sts',
                    'cbmr',
                    'takenCalories',
                    'recipeLogs'
                )
            );
            // } else {
            //     return redirect(route('app-users',['id'=>$id]))->with('error',"User not found");
            // }
            return redirect(route('app-users', ['id' => $id]))->with('error', "Something went wrong");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function saveUserBMR(Request $request)
    {
        $user = User::find($request->user);
        if (!empty($user)) {
            $user->bmr = $request->bmr;
            $user->save();
            return response()->json(["status" => "success", "message" => "BMR value updated"]);
        }
        return response()->json(["status" => "error", "message" => "Something went wrong!"]);
    }

    private function x_week_range2($date)
    {
        $ts = strtotime($date);
        $start = strtotime('monday this week', $ts);
        $end = strtotime('sunday this week', $ts);
        return array(date('Y-m-d', $start), date('Y-m-d', $end));
    }
    public function fetch_health_data($res_only = false, $is_new = false, $auth = '')
    {
        $is_new = true;
        if (!$is_new) {
            $user_id = auth()->user()->id;
            $user = User::find($user_id);
        }

        $user_session = [];

        $clientID = '898453737486-o4tt2pq2edmhvjk8lri1pcjbru9rf8fc.apps.googleusercontent.com';
        $clientSecret = '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';
        $redirectUri = env('APP_URL') . 'connect-google-account';

        $client = new \Google_Client();
        $client->setClientId($clientID);
        $client->setClientSecret($clientSecret);
        $client->setAccessType('offline');
        $client->setApplicationName('Fitness API');
        $client->setRedirectUri($redirectUri);
        $client->setState($auth);
        // $client->addScope("https://www.googleapis.com/auth/fitness.reproductive_health.read");
        // $client->addScope("https://www.googleapis.com/auth/fitness.activity.read");
        // $client->addScope("https://www.googleapis.com/auth/fitness.body.read");
        // $client->addScope("https://www.googleapis.com/auth/fitness.heart_rate.read");
        $client->addScope("profile");
        $client->addScope("email");

        $authUrl = $client->createAuthUrl();
        if ($is_new) {
            $url = $authUrl . "&user_id=new-account&temp_code=" . $auth;
        } else {
            $url = $authUrl . "&user_id=" . $user_id . '&temp_code=0';
        }


        if ($res_only) {
            return $url;
        }

        if ($is_new) {
            return response()->json($url);
        }
        return response()->json($url);
    }
    public function connect(Request $request)
    {

        $user_session = [];

        $clientID = '898453737486-o4tt2pq2edmhvjk8lri1pcjbru9rf8fc.apps.googleusercontent.com';
        $clientSecret = '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';
        $redirectUri = env('APP_URL') . 'connect-google-account';

        $client = new \Google_Client();
        $client->setApplicationName('Fitness API');
        $client->setClientId($clientID);
        $client->setClientSecret($clientSecret);
        $client->setAccessType('offline');
        $client->setAccessToken($request->code);
        $client->setRedirectUri($redirectUri);
        $client->authenticate($_GET['code']);

        $clientAccessToken = $client->getAccessToken();
        $clientRefreshToken = $client->getRefreshToken();

        $tokeninfo = $client->verifyIdToken();
        // return $tokeninfo;
        $user_id = $tokeninfo['email'];//auth()->user()->id;
        $user = User::where('email', $user_id)->first();
        if (!empty($user)) {
            $user->auth_google = 'existed';
            $user->auth_code = $request->state;
        } else {
            $user_inv = [
                'name' => $tokeninfo['name'],
                'email' => $tokeninfo['email'],
                'role' => 'appuser',
                'auth_google' => 'new',
                'auth_google' => $request->state,
                'password' => Hash::make(rand(12546, 99999))
            ];
            $user = User::create($user_inv);
        }

        $accessTokenStr = json_encode($clientAccessToken);

        $connect_url = ($this->fetch_health_data(true) ?? '#');
        if (!empty($clientAccessToken['access_token'])) {
            $user->google_access_token = $clientAccessToken['access_token'];
        }
        if (!empty($clientAccessToken['refresh_token'])) {
            $user->google_refresh_token = $clientAccessToken['refresh_token'];
        }
        if ($user->save()) {
            $username = $tokeninfo['name'];
            return view('public.gconnect1.success', compact('username'));
        }
        return view('public.gconnect1.error', compact('connect_url'));
    }
    public function getHealthData()
    {
        $user_id = auth()->user()->id;
        $user = User::find($user_id);
        $user_session = [];

        $clientID = '898453737486-o4tt2pq2edmhvjk8lri1pcjbru9rf8fc.apps.googleusercontent.com';
        $clientSecret = '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';
        $redirectUri = env('APP_URL') . 'connect-google-account';

        $client = new \Google_Client();
        $client->setApplicationName('Fitness API');
        $client->setClientId($clientID);
        $client->setClientSecret($clientSecret);
        $client->setAccessType('offline');
        $client->setAccessToken($user->google_access_token);
        $client->setRedirectUri($redirectUri);

        if ($client->isAccessTokenExpired()) {
            $clientRefreshToken = $client->refreshToken($user->google_refresh_token);
            if (!empty($clientRefreshToken)) {
                $newRefreshToken = $clientRefreshToken['refresh_token'];
                unset($clientRefreshToken['refresh_token']);
                $newAccessToken = json_encode($clientRefreshToken);
                $updateArray = array(
                    'google_auth_token' => $newAccessToken,
                    'refresh_token' => $newRefreshToken,
                );
                $user->google_access_token = $newAccessToken;
                $user->google_refresh_token = $newRefreshToken;
                $user->save();

            }
        }

        return $user->google_access_token;
        //https://s2.vstor.info/whlvid/1711473554/3nY9UdAAES3f8aOea1uEJQ/11000/11737/11737.mp4/11737.mp4

        $fitnessService = new \Google_Service_Fitness($client);
        // print_r(json_encode($fitnessService));die;
        // print_r(json_encode($fitnessService->users_dataSources->listUsersDataSources("me")));

        foreach ($fitnessService->users_dataSources->listUsersDataSources("me") as $list) {
            if (!empty($fitnessService->users_dataSources_datasets->get("me", "me", "com.google.step_count.delta:com.google.android.gms:estimated_steps"))) {
                print_r($fitnessService->users_dataSources_datasets->get("me", "me", $list->dataStreamId));
            }

        }
        die;
        $dataSources = $fitnessService->users_dataSources->listUsersDataSources("me");

        $dId = "derived:com.google.step_count.delta:com.google.android.gms:Xiaomi:Mi MIX 2:d862a1e4:derive_step_deltas<-raw:com.google.step_count.cumulative:Xiaomi:Mi MIX 2:d862a1e4:Step Counter";
        $dataSets = $fitnessService->users_dataSources_datasets->get("me", "me", $list->dataStreamId);
        print_r(json_encode($dataSets));
        return;
        $healthData = [];

        foreach ($dataSources as $dataSource) {
            $dataType = $dataSource->dataType->name;
            $dataStreamId = $dataSource->dataStreamId;
            print_r($dataStreamId);
            // print_r(json_encode($dataSource));
            try {
                $dataSets = $fitnessService->users_dataSources_datasets->get("me", "me", $dataStreamId);
                foreach ($dataSets->getPoint() as $dataPoint) {
                    $startTimeMillis = $dataPoint->getStartTimeNanos() / 1000000;
                    $endTimeMillis = $dataPoint->getEndTimeNanos() / 1000000;

                    $healthData[] = [
                        'user_id' => $user_id,
                        'data_type' => $dataType,
                        'start_time' => date('Y-m-d H:i:s', $startTimeMillis / 1000),
                        'end_time' => date('Y-m-d H:i:s', $endTimeMillis / 1000),
                        'value' => $dataPoint->getValue(),
                    ];
                }
                print_r(json_encode($dataSets));
            } catch (\Exception $e) {
                echo 'error|';
                continue;
            }

        }
        print_r($healthData);
        return $healthData;
    }

    public function connectGoogleTempAuth(Request $request)
    {
        $user_id = base64_decode(base64_decode($request->temp));
        if ($user_id == "new-account") {
            return redirect($this->fetch_health_data(true, true, $request->auth));
        }
        // $user = User::find($user_id);           
        if (Auth::loginUsingId($user_id)) {
            return redirect($this->fetch_health_data(true, false, ''));
        }
        echo "NoAuth";
    }

    public function workoutPlans()
    {
        if (permission('workout_plans', 'read')) {

            $users = User::whereRole('appuser')->get();
            $paid_users = User::whereIsSubscription('1')->get();
            return view('admin.workout.workout-plans', compact('users', 'paid_users'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function manageWorkoutPlans($id)
    {
        if (permission('workout_plans', 'read')) {
            $workoutplan = WorkoutPlan::with(['user', 'workout_days.workout_exersice'])->where('id', base64_decode($id))->first();
            if (empty($workoutplan)) {
                return redirect()->back()->with('error', "Something went wrong!");
            }
            // return $workoutplan;
            $users = User::whereRole('appuser')->get();
            $paid_users = User::whereIsSubscription('1')->get();
            $exercise_machines = ExerciseMachine::get();

            $workoutPlans = WorkoutPlan::whereNull('user_id')->whereStatus(1)->get();
            $userWorkout = WorkoutPlan::whereNotNull('user_id')->with('user')->whereStatus(1)->get();
            $getWorkout = array();
            foreach ($userWorkout as $list) {
                if (!empty($list->user)) {
                    array_push($getWorkout, $list);
                }
            }
            $userWorkoutPlans = $getWorkout;

            $allWorkoutPlans = WorkoutPlan::whereNot('id', $workoutplan->id)->whereStatus(1)->get();
            return view('admin.workout.manage-workout-plans', compact('users', 'paid_users', 'workoutplan', 'exercise_machines', 'workoutPlans', 'userWorkoutPlans', 'allWorkoutPlans'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function getWorkoutPlanDay(Request $request)
    {
        $getDays = WorkoutPlanDay::where('plans_uuid', $request->id)->get();
        $html = "<label for='importPlanDay'>Workout Plans Day </label>
                    <select id='importPlanDay' name='import_plan_day' class='form-control selectpicker' data-live-search='true' >
                        <option value='' selected disabled>Select Workout Day</option>";
        foreach ($getDays as $list) {
            $html .= " <option value='$list->uuid' >$list->title </option>";
        }
        $html .= '</select>';
        return $html;
    }

    public function importWorkoutPlanDay(Request $request)
    {
        // return $request;
        //Workout Plan Days
        $planDays = WorkoutPlanDay::where("uuid", $request->import_plan_day)->get();
        $planId = $request->workoutplan;
        if (count($planDays) >= 0) {
            foreach ($planDays as $plan_day) {
                $planEachDay = WorkoutDay::where('plan_days_uuid', $plan_day->uuid)->get();
                $planDaysId = Str::uuid();
                if (count($planEachDay) >= 0) {
                    foreach ($planEachDay as $each_day) {
                        //Workout Plan Single Days Detail
                        $arr_req2 = array(
                            "uuid" => Str::uuid(),
                            "plans_uuid" => $planId,
                            "user_id" => null,
                            "c_by" => Auth::user()->id,
                            "title" => $each_day->title,
                            "image" => $each_day->image,
                            "plan_days_uuid" => $planDaysId,
                            "take_time" => $each_day->take_time,
                            "no_of_reps" => $each_day->no_of_reps,
                            "default_weight" => $each_day->default_weight,
                            "no_of_sets" => $each_day->no_of_sets,
                            "video_type" => $each_day->video_type,
                            "video_url" => $each_day->video_url,
                            "exersice_type" => $each_day->exercise_type,
                            "is_paid" => $each_day->ispaid,
                        );
                        WorkoutDay::insert($arr_req2);
                    }
                }

                $arr_req1 = array(
                    "uuid" => $planDaysId,
                    "plans_uuid" => $planId,
                    "user_id" => null,
                    "c_by" => Auth::user()->id,
                    "title" => $plan_day->title,
                    "image" => $plan_day->image
                );
                WorkoutPlanDay::insert($arr_req1);

            }
            return redirect()->back()->with('success', "Imported Workout Day");
        }
        return redirect()->back()->with('success', "Workout Day No Records");
    }

    public function saveWorkoutPlans(Request $request)
    {
        if (permission('workout_plans', 'create')) {
            $paiduser = NULL;
            if ($request->is_user_selected == "yes") {
                $paiduser = $request->paiduser ?? $request->alluser;
            }
            $ispaid = 0;
            if ($request->ispaid == "yes") {
                $ispaid = 1;
            }

            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/workout/', $fileName);
            }

            $arr_req = array(
                "uuid" => Str::uuid(),
                "user_id" => $paiduser,
                "c_by" => Auth::user()->id,
                "title" => $request->title,
                "video_type" => $request->videotype,
                "video_url" => $request->videourl,
                "is_paid" => $ispaid,
                "image" => $fileName
            );
            WorkoutPlan::insert($arr_req);
            return redirect()->back()->with('success', "Workout Created");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function editWorkoutPlans(Request $request)
    {
        if (permission('workout_plans', 'update')) {
            $paiduser = NULL;
            if ($request->is_user_selected == "yes") {
                $paiduser = $request->paiduser ?? $request->alluser;
            }
            $ispaid = 0;
            if ($request->ispaid == "yes") {
                $ispaid = 1;
            }

            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/workout/', $fileName);
            }
            $arr_req = [];
            $arr_req["u_by"] = Auth::user()->id;
            $arr_req["is_paid"] = $ispaid;
            if ($paiduser != null) {
                $arr_req["user_id"] = $paiduser;
            }
            if ($request->has('title')) {
                $arr_req["title"] = $request->title;
            }
            if ($request->has('videotype')) {
                $arr_req["video_type"] = $request->videotype;
            }
            if ($request->has('videourl')) {
                $arr_req["video_url"] = $request->videourl;
            }
            if (!empty($fileName)) {
                $arr_req["image"] = $fileName;
            }


            WorkoutPlan::where('uuid', $request->uuid)->update($arr_req);
            return redirect()->back()->with('success', "Workout Updated");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function cloneWorkoutPlans(Request $request)
    {
        if (permission('workout_plans', 'create')) {
            $paiduser = NULL;
            if ($request->is_user_selected1 == "yes" || $request->has('alluser') || $request->has('paiduser')) {
                $paiduser = $request->paiduser ?? $request->alluser;
            }
            $ispaid = 0;
            if ($request->ispaid1 == "yes") {
                $ispaid = 1;
            }

            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/workout/', $fileName);
            }
            $existed_plan = WorkoutPlan::where('uuid', $request->uuid)->first();
            if (!empty($existed_plan)) {
                $planId = Str::uuid();
                $arr_req = array(
                    "uuid" => $planId,
                    "user_id" => $paiduser,
                    "c_by" => Auth::user()->id,
                    "title" => $request->title,
                    "video_type" => $request->videotype,
                    "video_url" => $request->videourl,
                    "is_paid" => $ispaid,
                    "image" => $fileName
                );
                WorkoutPlan::insert($arr_req);

                //Workout Plan Days
                $planDays = WorkoutPlanDay::where("plans_uuid", $existed_plan->uuid)->get();
                if (count($planDays) >= 0) {
                    foreach ($planDays as $plan_day) {
                        $planEachDay = WorkoutDay::where('plan_days_uuid', $plan_day->uuid)->get();
                        $planDaysId = Str::uuid();
                        if (count($planEachDay) >= 0) {
                            foreach ($planEachDay as $each_day) {
                                //Workout Plan Single Days Detail
                                $arr_req2 = array(
                                    "uuid" => Str::uuid(),
                                    "plans_uuid" => $planId,
                                    "user_id" => $paiduser,
                                    "c_by" => Auth::user()->id,
                                    "title" => $each_day->title,
                                    "image" => $each_day->image,
                                    "plan_days_uuid" => $planDaysId,
                                    "take_time" => $each_day->take_time,
                                    "no_of_reps" => $each_day->no_of_reps,
                                    "default_weight" => $each_day->default_weight,
                                    "no_of_sets" => $each_day->no_of_sets,
                                    "video_type" => $each_day->video_type,
                                    "video_url" => $each_day->video_url,
                                    "exersice_type" => $each_day->exercise_type,
                                    "is_paid" => $each_day->ispaid,
                                );
                                WorkoutDay::insert($arr_req2);
                            }
                        }

                        $arr_req1 = array(
                            "uuid" => $planDaysId,
                            "plans_uuid" => $planId,
                            "user_id" => $paiduser,
                            "c_by" => Auth::user()->id,
                            "title" => $plan_day->title,
                            "image" => $plan_day->image
                        );
                        WorkoutPlanDay::insert($arr_req1);
                    }
                }


            }

            return redirect()->back()->with('success', "Workout Created");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function workoutPlansDays()
    {
        if (permission('workout_plan_days', 'read')) {

            $workoutPlans = WorkoutPlan::whereNull('user_id')->whereStatus(1)->get();
            $userWorkout = WorkoutPlan::whereNotNull('user_id')->with('user')->whereStatus(1)->get();
            $getWorkout = array();
            foreach ($userWorkout as $list) {
                if (!empty($list->user)) {
                    array_push($getWorkout, $list);
                }
            }
            $userWorkoutPlans = $getWorkout;
            $users = User::whereRole('appuser')->get();
            return view('admin.workout.workout-plan-days', compact('workoutPlans', 'userWorkoutPlans', 'users'));
        }
        // if(permission('workout_plans','read')){

        //     $users = User::whereRole('appuser')->get();
        //     $paid_users =  User::whereIsSubscription('1')->get();
        //     return view('admin.workout.workout-plans',compact('users','paid_users'));
        // }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function saveWorkoutPlansDays(Request $request)
    {
        if (permission('workout_plan_days', 'create')) {

            if ($request->is_user_selected == "yes") {
                $paiduser = $request->user_workout_plan;
            } else {
                $paiduser = $request->workout_plan;
            }

            $workout_detail = WorkoutPlan::find($paiduser);


            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/workout/', $fileName);
            }

            $arr_req = array(
                "uuid" => Str::uuid(),
                "plans_uuid" => $workout_detail->uuid,
                "user_id" => $workout_detail->user_id,
                "c_by" => Auth::user()->id,
                "title" => $request->title,
                "image" => $fileName
            );

            WorkoutPlanDay::insert($arr_req);

            return redirect()->back()->with('success', "Workout Day Created");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateWorkoutPlansDays(Request $request)
    {
        if (permission('workout_plan_days', 'update')) {
            if ($request->is_user_selected == "yes") {
                $paiduser = $request->user_workout_plan;
            } else {
                $paiduser = $request->workout_plan;
            }

            $workout_detail = WorkoutPlan::find($paiduser);

            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/workout/', $fileName);
            }
            $arr_req = [];
            $arr_req["u_by"] = Auth::user()->id;
            if (!empty($workout_detail)) {
                $arr_req["plans_uuid"] = $workout_detail->uuid;
            }
            if (!empty($workout_detail)) {
                $arr_req["user_id"] = $workout_detail->user_id;
            }
            if ($request->has('title')) {
                $arr_req["title"] = $request->title;
            }
            if (!empty($fileName)) {
                $arr_req["image"] = $fileName;
            }

            WorkoutPlanDay::where('uuid', $request->uuid)->update($arr_req);
            return redirect()->back()->with('success', "Workout Updated");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function workoutDays()
    {
        if (permission('workout_days', 'read')) {
            $plans = WorkoutDay::orderBy('id', "desc")->paginate(10);
            foreach ($plans as $list) {
                if (!empty($list->user_id)) {
                    $list->user = User::find($list->user_id);
                }
                $list->workout_plan_days = WorkoutPlanDay::where('uuid', $list->plan_days_uuid)->first();
                $list->plan = WorkoutPlan::whereStatus(1)->where('uuid', $list->plans_uuid)->first();
            }
            $workoutPlans = WorkoutPlanDay::whereStatus(1)->orderBy('id', "desc")->with('user')->get();
            foreach ($workoutPlans as $list) {
                $list->plan = WorkoutPlan::whereStatus(1)->where('uuid', $list->plans_uuid)->first();
            }
            $exercise_machines = ExerciseMachine::get();
            return view('admin.workout.workout-days', compact('plans', 'workoutPlans', 'exercise_machines'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function saveWorkoutDays(Request $request)
    {
        if (permission('workout_days', 'create')) {
            // return $request;
            $paiduser = $request->workoutplanday;

            $workout_detail = WorkoutPlanDay::where('uuid', $request->workoutplanday)->first();


            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/workout/', $fileName);
            }

            $arr_req = array(
                "uuid" => Str::uuid(),
                "plans_uuid" => $workout_detail->plans_uuid,
                "user_id" => $workout_detail->user_id,
                "c_by" => Auth::user()->id,
                "title" => $request->title,
                "image" => $fileName,
                "plan_days_uuid" => $request->workoutplanday,
                "take_time" => $request->take_time,
                "no_of_reps" => $request->no_of_reps,
                "default_weight" => $request->default_weight,
                "no_of_sets" => $request->no_of_sets,
                "video_type" => $request->videotype,
                "video_url" => $request->videourl,
                "exersice_type" => $request->exercise_type,
                "is_paid" => ($request->ispaid == 'no' ? 0 : 1),
                "exercise_machine" => ($request->exercise_machine ?? '')
            );

            WorkoutDay::insert($arr_req);

            return redirect()->back()->with('success', "Workout Day Created");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function recipeList()
    {
        if (permission('recipe_list', 'read')) {
            $listing = RecipeList::orderBy('id', 'desc')->paginate(10);
            foreach ($listing as $list) {
                $list->ingredient = RecipeIngredient::whereIn('id', json_decode($list->recipe_ingredients))->pluck('name');
            }
            $isolated_ingredients = RecipeIngredient::orderBy('id', 'desc')->get();
            return view('admin.updates.recipe_list', compact('listing', 'isolated_ingredients'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function recipeStore(Request $request)
    {

        if (permission('recipe_list', 'create')) {
            $recipe_steps = array();
            foreach ($request->step_id as $index => $recipe) {
                array_push($recipe_steps, array(
                    "id" => $request->step_id[$index],
                    "name" => $request->step_name[$index],
                    "qty" => $request->step_qty[$index],
                    "type" => $request->step_type[$index],
                    "note" => $request->step_note[$index]
                ));
            }
            $ins_query = [
                "name" => $request->name,
                "type" => $request->type,
                "description" => $request->description,
                "recipe_ingredients" => json_encode($request->step_id),
                "recipe_steps" => json_encode($recipe_steps),
            ];
            RecipeList::insert($ins_query);
            return redirect(route("recipe-list"))->with("success", "Recipe Added");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateRecipe(Request $request, $id)
    {
        if (permission('recipe_list', 'update')) {
            $info = InfoContact::whereId($id)->first();
            if (!empty($info)) {
                $info->html = $request->html;
                $info->save();
                return redirect(route("contact-info"))->with("success", "Contact Information Updated");
            } else {
                return redirect(route("contact-info"))->with("error", "Contact information not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function recipeGuideList()
    {
        if (permission('recipe_list', 'read')) {
            $listing = RecipeGuideList::orderBy('id', 'desc')->paginate(10);
            // return $listing;

            $recipeCategories = RecipeCategories::where('status', 1)->get();
            return view('admin.recipe-guide.list', compact('listing', 'recipeCategories'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }


    public function saveRecipeGuide(Request $request)
    {
        if (permission('recipe_list', 'create')) {

            $ins_query = [
                "title" => $request->title,
                "short_title" => $request->shorttitle,
                "video_type" => $request->videotype,
                "video_url" => $request->videourl,
                "description" => $request->desc,
                "cat_uid" => $request->cat_uid
            ];

            RecipeGuideList::insert($ins_query);

            return redirect(route("recipe-guide-list"))->with("success", "Recipe Guide Added Successfully");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function recipeGuideStatus(Request $request, $id)
    {
        if (permission('recipe_list', 'update')) {
            $info = RecipeGuideList::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->save();
                return redirect(route("recipe-guide-list"))->with("success", "Recipe Guide Status Changed");
            } else {
                return redirect(route("recipe-guide-list"))->with("error", "Recipe Guide not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteRecipeGuide(Request $request, $id)
    {
        if (permission('recipe_list', 'delete')) {
            $info = RecipeGuideList::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("mediation"))->with("success", "Recipe Guide Deleted");
            } else {
                return redirect(route("mediation"))->with("error", "Recipe Guide not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateRecipeGuide(Request $request, $id)
    {
        if (permission('recipe_list', 'update')) {
            $info = RecipeGuideList::whereId($id)->first();

            if (!empty($info)) {
                $info->title = $request->title;
                $info->short_title = $request->shorttitle;
                $info->video_type = $request->videotype;
                $info->video_url = $request->videourl;
                $info->description = $request->desc;
                $info->cat_uid = $request->cat_uid;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Recipe Guide update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Recipe Guide not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }//

    public function recipeCategoryList()
    {
        if (permission('recipe_list', 'read')) {
            $listing = RecipeCategories::orderBy('id', 'desc')->paginate(10);
            return view('admin.recipe-category.list', compact('listing'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }


    public function saveRecipeCategory(Request $request)
    {
        if (permission('recipe_list', 'create')) {

            $ins_query = [
                "name" => $request->name,
                'status' => 1,
                'uuid' => Str::uuid()->toString()
            ];

            RecipeCategories::insert($ins_query);

            return redirect()->back()->with("success", "Recipe Category Added Successfully");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function recipeCategoryStatus(Request $request, $id)
    {
        if (permission('recipe_list', 'update')) {
            $info = RecipeCategories::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->save();
                return redirect()->back()->with("success", "Recipe Category Status Changed");
            } else {
                return redirect()->back()->with("error", "Recipe Category not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteRecipeCategory(Request $request, $id)
    {
        if (permission('recipe_list', 'delete')) {
            $info = RecipeCategories::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect()->back()->with("success", "Recipe Category Deleted");
            } else {
                return redirect()->back()->with("error", "Recipe Category not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateRecipeCategory(Request $request, $id)
    {
        if (permission('recipe_list', 'update')) {
            $info = RecipeCategories::whereId($id)->first();

            if (!empty($info)) {
                $info->name = $request->name;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Recipe Category update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Recipe Category not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }//


    public function meditationCategoryList()
    {
        if (permission('meditation', 'read')) {
            $listing = MeditationCategories::orderBy('id', 'desc')->paginate(10);
            return view('admin.meditation-category.list', compact('listing'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }


    public function saveMeditationCategory(Request $request)
    {
        if (permission('meditation', 'create')) {

            $ins_query = [
                "name" => $request->name,
                'status' => 1,
                'uuid' => Str::uuid()->toString()
            ];

            MeditationCategories::insert($ins_query);

            return redirect()->back()->with("success", "Meditation Category Added Successfully");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function meditationCategoryStatus(Request $request, $id)
    {
        if (permission('meditation', 'update')) {
            $info = MeditationCategories::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->save();
                return redirect()->back()->with("success", "Meditation Category Status Changed");
            } else {
                return redirect()->back()->with("error", "Meditation Category not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteMeditationCategory(Request $request, $id)
    {
        if (permission('meditation', 'delete')) {
            $info = MeditationCategories::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect()->back()->with("success", "Meditation Category Deleted");
            } else {
                return redirect()->back()->with("error", "Meditation Category not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updatemMditationCategory(Request $request, $id)
    {
        if (permission('meditation', 'update')) {
            $info = MeditationCategories::whereId($id)->first();

            if (!empty($info)) {
                $info->name = $request->name;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Meditation Category update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Meditation Category not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }//

    public function mediationList(Request $request)
    {
        if (permission('meditation', 'read')) {
            $listing = MeditationList::orderBy('id', 'desc')->paginate(10);
            $categories = MeditationCategories::where('status', 1)->get();
            return view('admin.meditation.list', compact('listing', 'categories'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function saveMediation(Request $request)
    {
        if (permission('meditation', 'create')) {

            $ins_query = [
                "title" => $request->title,
                "short_title" => $request->shorttitle,
                "video_type" => $request->videotype,
                "video_url" => $request->videourl,
                "cat_uid" => $request->cat_uid,
                "description" => $request->desc
            ];

            MeditationList::insert($ins_query);

            return redirect(route("mediation"))->with("success", "Mediation Created Successfully");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function meditationStatus(Request $request, $id)
    {
        if (permission('meditation', 'update')) {
            $info = MeditationList::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->save();
                return redirect(route("mediation"))->with("success", "Meditation Status Changed");
            } else {
                return redirect(route("mediation"))->with("error", "Meditation not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteMeditation(Request $request, $id)
    {
        if (permission('meditation', 'delete')) {
            $info = MeditationList::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("mediation"))->with("success", "Meditation Deleted");
            } else {
                return redirect(route("mediation"))->with("error", "Meditation not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function updateMeditation(Request $request, $id)
    {
        if (permission('meditation', 'update')) {
            $info = MeditationList::whereId($id)->first();

            if (!empty($info)) {
                $info->title = $request->title;
                $info->short_title = $request->shorttitle;
                $info->video_type = $request->videotype;
                $info->video_url = $request->videourl;
                $info->description = $request->desc;
                $info->cat_uid = $request->cat_uid;
                $info->save();

                return redirect()->back()
                    ->with('success', 'Mediation update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Mediation not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function mediationDeepSleepList(Request $request)
    {
        if (permission('meditation_deepsleep', 'read')) {
            $listing = MeditationDeepSleep::orderBy('id', 'desc')->paginate(10);
            return view('admin.meditation.meditation_deepsleep', compact('listing'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function saveDeepSleepMediation(Request $request)
    {
        if (permission('meditation_deepsleep', 'create')) {
            $fileName = '';
            if (request()->hasFile('file')) {
                $file = request()->file('file');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/meditation_deepsleep' . '/', $fileName);

            }

            $ins_query = [
                "name" => $request->title,
                "total_time" => $request->totaltile,
                "in_interval" => $request->in,
                "out_interval" => $request->out,
                "file_path" => $fileName
            ];

            MeditationDeepSleep::insert($ins_query);

            return redirect(route("meditation-deepsleep"))->with("success", "Mediation Created Successfully");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function meditationDeepSleepStatus(Request $request, $id)
    {
        if (permission('meditation_deepsleep', 'update')) {
            $info = MeditationDeepSleep::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->save();
                return redirect(route("meditation-deepsleep"))->with("success", "Meditation Status Changed");
            } else {
                return redirect(route("meditation-deepsleep"))->with("error", "Meditation not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteDeepSleepMeditation(Request $request, $id)
    {
        if (permission('meditation_deepsleep', 'delete')) {
            $info = MeditationDeepSleep::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("meditation-deepsleep"))->with("success", "Meditation Deleted");
            } else {
                return redirect(route("meditation-deepsleep"))->with("error", "Meditation not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function updateDeepSleepMeditation(Request $request, $id)
    {
        if (permission('meditation_deepsleep', 'update')) {
            $info = MeditationDeepSleep::whereId($id)->first();

            if (!empty($info)) {
                $info->name = $request->title;
                $info->total_time = $request->totaltile;
                $info->in_interval = $request->in;
                $info->out_interval = $request->out;

                if (request()->hasFile('file')) {
                    $file = request()->file('file');
                    $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                    $file->move(storage_path() . '/meditation_deepsleep' . '/', $fileName);
                    $info->file_path = $fileName;
                }

                $info->save();

                return redirect()->back()
                    ->with('success', 'Mediation update successfully.');
            } else {
                return redirect()->back()
                    ->with("error", "Mediation not found");
            }
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function formBuilderGuide(Request $request)
    {
        if (permission('form_builder_guide', 'read')) {
            $listing = FormBuilderWorkout::orderBy('id', 'desc')->paginate(10);
            return view('admin.updates.form-builder-guide', compact('listing'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function saveFormBuilderGuide(Request $request)
    {

        if (permission('form_builder_guide', 'create')) {
            $this->validate($request, [
                'name' => 'required',
                'duration' => 'required',
                'desc' => 'required',
                'image' => 'required',
                'videourl' => 'required',
            ]);
            $fileName = '';
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/exercise_vid_thumb' . '/', $fileName);
            }

            $ins_query = [
                "name" => $request->name,
                "duration" => $request->duration,
                "desc" => $request->desc,
                "video_type" => $request->videotype,
                "video_path" => $request->videourl,
                "image" => $fileName
            ];

            FormBuilderWorkout::insert($ins_query);

            return redirect(route("form-builder-guide"))->with("success", "Form Builder Workouts Added Successfully");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function updateFormBuilderGuide(Request $request, $id)
    {
        if (permission('form_builder_guide', 'create')) {
            $this->validate($request, [
                'name' => 'required',
                'duration' => 'required',
                'desc' => 'required',
                'videourl' => 'required',
            ]);
            $form = FormBuilderWorkout::where('id', $id)->first();
            if (empty($form)) {
                return redirect(route("form-builder-guide"))->with("error", "Form Builder Workouts Not Found");
            }

            $fileName = $form->image;
            if (request()->hasFile('image')) {
                $file = request()->file('image');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path() . '/exercise_vid_thumb' . '/', $fileName);
            }

            $ins_query = [
                "name" => $request->name,
                "duration" => $request->duration,
                "desc" => $request->desc,
                "video_type" => $request->videotype,
                "video_path" => $request->videourl,
                "image" => $fileName
            ];

            FormBuilderWorkout::where('id', $id)->update($ins_query);

            return redirect(route("form-builder-guide"))->with("success", "Form Builder Workouts Updated Successfully");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function adminRoles()
    {
        if (permission('admin_roles', 'read')) {
            $roles = Role::whereIsMain(0)->orderBy('id', 'desc')->paginate(10);
            return view('admin.role.list', compact('roles'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function createRole()
    {
        if (permission('admin_roles', 'create')) {
            $permission = Permission::where('role_id', 1)->get();
            foreach ($permission as $list) {
                $list->permissions = json_decode($list->permissions);
            }
            return view('admin.role.create', compact('permission'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function saveRole(Request $request)
    {
        $request->validate([
            "name" => "required|unique:roles,name"
        ]);

        if (permission('admin_roles', 'create')) {
            $input = $request->all();
            if (!empty($input['permissions'])) {
                $role = Role::create([
                    'name' => strtolower($request->name)
                ]);

                $permission = [];
                foreach ($input['permissions'] as $list) {
                    $splt = explode('^09N74^', $list);
                    if (!empty($permission[$splt[0]])) {
                        $permission[$splt[0]][count($permission[$splt[0]])] = $splt[1];
                    } else {
                        $permission[$splt[0]][0] = $splt[1];
                    }
                }
                foreach ($permission as $name => $list) {
                    Permission::insert([
                        "role_id" => $role->id,
                        "name" => $name,
                        "permissions" => json_encode($list)
                    ]);
                }
            }
            return redirect(route('admin-roles'))->with('success', "Role Created");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function editRole($role_id)
    {
        if (permission('admin_roles', 'update')) {
            $permission = Permission::where('role_id', 1)->get();
            foreach ($permission as $list) {
                $list->permissions = json_decode($list->permissions);
            }
            $role = Role::where('id', base64_decode($role_id))->first();
            if (empty($role)) {
                return redirect(route('admin-roles'))->with('error', "Unknown Role");
            }
            $oldpermission = Permission::where('role_id', $role->id)->get();
            $permission_old = [];
            foreach ($oldpermission as $list) {
                $permission_old[$list->name] = json_decode($list->permissions);
            }
            return view('admin.role.edit', compact('permission', 'role', 'permission_old'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function updateRole(Request $request, $role_id)
    {
        if (permission('admin_roles', 'update')) {

            $existed_role = Role::where('id', base64_decode($role_id))->first();

            if (empty($existed_role)) {
                return redirect(route('admin-roles'))->with('error', "Unknown Role");
            }
            if ($existed_role->name != $request->name) {
                $request->validate([
                    "name" => "required|unique:roles,name"
                ]);
            }

            //Remove Old  Data
            Permission::where('role_id', $existed_role->id)->delete();
            $existed_role->delete();

            //Recreate Role
            $input = $request->all();
            if (!empty($input['permissions'])) {
                $role = Role::create([
                    'name' => strtolower($request->name)
                ]);

                if ($existed_role->name != $request->name) {
                    User::where('role', $existed_role->name)->update([
                        'role' => strtolower($request->name)
                    ]);
                }

                $permission = [];
                foreach ($input['permissions'] as $list) {
                    $splt = explode('^09N74^', $list);
                    if (!empty($permission[$splt[0]])) {
                        $permission[$splt[0]][count($permission[$splt[0]])] = $splt[1];
                    } else {
                        $permission[$splt[0]][0] = $splt[1];
                    }
                }
                foreach ($permission as $name => $list) {
                    Permission::insert([
                        "role_id" => $role->id,
                        "name" => $name,
                        "permissions" => json_encode($list)
                    ]);
                }
            }
            return redirect(route('admin-roles'))->with('success', "Role Updated");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function requestPremium()
    {
        if (permission('request_premium', 'read')) {
            $listinga = RequestPremium::with('user', 'plan', 'u_by')->orderBy('id', 'desc')->paginate(10);
            $createList = array();
            foreach ($listinga as $list) {
                // if(!empty($list->plan)){
                //     // $list->plan->permissions = json_decode($list->plan->permissions);
                //     // $list->plan->features = json_decode($list->plan->features);
                //     // $list->plan->final_price = $list->plan->amount * ( (100-$list->plan->discount) / 100 );
                // }

                $list->last_update = User::find($list->u_by) ?? null;
                if (!empty($list->last_update)) {
                    $isExt = User::whereId($list->user_id)->first();
                    if (!empty($isExt)) {
                        $list->current_plan = Plan::whereId($isExt->plan_id)->first();
                    } else {
                        $list->current_plan = null;
                    }
                }
                if (!empty($list->user->name)) {
                    array_push($createList, $list);
                }
            }
            $listing = $createList;
            // return $listing;
            return view('admin.request-pro.pro', compact('listing', 'listinga'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function statusRequestPremium(Request $request)
    {
        if (permission('request_premium', 'update')) {
            $status = 0;
            if ($request->status == "call_pending") {
                $status = 1;
            }
            if ($request->status == "payment_pending") {
                $status = 2;
            }
            if ($request->status == "plan_activated") {
                $status = 3;
            }
            $listing = RequestPremium::where('id', $request->id)->first();
            if (!empty($listing)) {
                $listing->status = $status;
                $listing->u_by = Auth::user()->id;
                $listing->save();
                return response()->json(['status' => "success", "message" => "Status Updated"], 200);
            }
            return response()->json(['status' => "error", "message" => "Something went wrong"], 500);
        }
        return response()->json(['status' => "error", "message" => "Unauthroized"], 401);
    }
    public function statusFormBuilderGuide(Request $request, $id)
    {
        if (permission('form_builder_guide', 'update')) {
            $info = FormBuilderWorkout::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect(route("form-builder-guide"))->with("success", "Form Builder Workout Status Changed");
            } else {
                return redirect(route("form-builder-guide"))->with("error", "Form Builder Workout not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function statusWorkoutPlans(Request $request, $id)
    {
        if (permission('workout_plans', 'update')) {
            $info = WorkoutPlan::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect()->back()->with("success", "Status Changed");
            } else {
                return redirect(route("workout_plans"))->with("error", "workout plan not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function statusWorkoutPlansDays(Request $request, $id)
    {
        if (permission('workout_plan_days', 'update')) {
            $info = WorkoutPlanDay::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect()->back()->with("success", "Workout Status Changed");
            } else {
                return redirect(route("workout_plan_days"))->with("error", "Workout not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function statusWorkoutDays(Request $request, $id)
    {
        if (permission('workout_days', 'update')) {
            $info = WorkoutDay::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect()->back()->with("success", " Workout Status Changed");
            } else {
                return redirect(route("workout_days"))->with("error", " Workout not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function adminRoleDisable(Request $request)
    {
        if (permission('admin_roles', 'update')) {
            $role_id = base64_decode($request->id);
            $info = Role::whereId($role_id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }

                $info->save();
                return redirect(route("admin-roles"))->with("success", " Role Status Changed");
            } else {
                return redirect(route("admin-roles"))->with("error", " Role not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function deleteWorkoutPlans(Request $request, $id)
    {
        if (permission('workout_plans', 'delete')) {
            $info = WorkoutPlan::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->delete();
                return redirect(route("workout_plans"))->with("success", " Workout Deleted");
            } else {
                return redirect(route("workout_plans"))->with("error", " Workout not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function deleteWorkoutPlansDays(Request $request, $id)
    {
        if (permission('workout_plan_days', 'delete')) {
            $info = WorkoutPlanDay::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->delete();
                return redirect()->back()->with("success", " Workout Deleted");
            } else {
                return redirect(route("workout_plan_days"))->with("error", " Workout not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function deleteWorkoutDays(Request $request, $id)
    {
        if (permission('workout_days', 'delete')) {
            $info = WorkoutDay::whereId($id)->first();
            if (!empty($info)) {
                if ($info->status == 0) {
                    $info->status = 1;
                } else if ($info->status == 2) {
                    $info->status = 1;
                } else {
                    $info->status = 0;
                }
                $info->delete();
                return redirect()->back()->with("success", " Workout Deleted");
            } else {
                return redirect(route("workout_days"))->with("error", " Workout not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function deleteFormBuilderGuide(Request $request, $id)
    {
        if (permission('form_builder_guide', 'delete')) {
            $info = FormBuilderWorkout::whereId($id)->first();
            if (!empty($info)) {
                $info->delete();
                return redirect(route("form-builder-guide"))->with("success", "Workout Deleted");
            } else {
                return redirect(route("form-builder-guide"))->with("error", "Workout not found");
            }

        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function changeToPremium(Request $request)
    {
        if (permission('app_users', 'update')) {
            $plan = Plan::whereId($request->id)->first();
            if (empty($plan)) {
                return response()->json('Plan not found');
            }
            $user = User::where('id', $request->user_id)->first();
            if (!empty($user)) {
                $user->plan_id = $plan->id;
                $user->is_subscription = 1;
                $user->gateway_ref = json_encode(array(
                    'start' => date('Y-m-d', strtotime('now')),
                    'end' => date('Y-m-d', strtotime('+' . $plan->days . ' Days'))
                ));
                if ($user->save()) {
                    return response()->json('Plan Activate Successfully');
                }
            } else {
                return response()->json('User not found', 500);
            }
            return response()->json('Something went wrong', 500);
        }
        return response()->json("Unauthorized", 401);
    }
    public function sendNotification(Request $request)
    {
        try {
            notify_user($request->send_to, $request->title, $request->message);
            return redirect()->back()->with('success', "Notification Sent Successfully.");
        } catch (\Throwable $e) {
            // return $e;
            return redirect()->back()->with('error', "Error while sending notification.");
        }
    }
    //Chat
    public function getUserChat(Request $request)
    {
        $user_id = $request->trainer_id;
        $t_id = $request->user_id;
        $listChatDetail = Chat::where('chats.sender_id', $t_id)
            ->leftJoin('users as receiver', 'receiver.id', '=', 'chats.sender_id')
            ->leftJoin('users as sender', 'sender.id', '=', 'chats.user_id')
            ->select(
                'chats.*',
                'sender.id as sender_user_id',
                'sender.name as sender_name',
                'sender.email as sender_email',
                'sender.image as sender_profile',
                'receiver.id as receiver_user_id',
                'receiver.name as receiver_name',
                'receiver.email as receiver_email',
                'receiver.image as receiver_profile'
            )
            ->orWhere('chats.sender_id', $user_id)
            ->where('chats.user_id', $t_id)
            ->orWhere('chats.user_id', $user_id)
            ->orderBy("chats.id", "desc")
            ->paginate(10)
            ->reverse()
            ->values();
        foreach ($listChatDetail as $chat) {
            if ($chat->status === 0) {
                try {
                    Chat::where('chats.sender_id', $user_id)->orWhere('chats.user_id', $user_id)->where('status', 0)->update(['status' => 1]);
                } catch (\Exception $e) {

                }
            }
        }
        return response()->json($listChatDetail);
    }

    private function detectMimeFromBinary($binary)
    {
        $bytes = substr($binary, 0, 12);

        if (str_starts_with($bytes, "\x89PNG"))
            return 'image/png';
        if (str_starts_with($bytes, "\xFF\xD8\xFF"))
            return 'image/jpeg';
        if (str_starts_with($bytes, "GIF"))
            return 'image/gif';
        if (str_starts_with($bytes, "RIFF") && strpos($bytes, "WEBP") !== false)
            return 'image/webp';
        if (str_starts_with($bytes, "%PDF"))
            return 'application/pdf';
        if (str_starts_with($bytes, "PK"))
            return 'application/zip';
        if (strpos($bytes, "ftyp") !== false)
            return 'video/mp4';
        if (str_starts_with($bytes, "ID3"))
            return 'audio/mpeg';

        return 'application/octet-stream';
    }
    public function sendUserChat(Request $request)
    {
        $fileAttached = [];

        if (!empty($request->attached_image)) {
            $base64 = $request->attached_image;
            if (strpos($base64, 'base64,') !== false) {
                $base64 = explode('base64,', $base64)[1];
            }

            $binary = base64_decode($base64);
            $mime = $this->detectMimeFromBinary($binary);

            $mimeMap = [
                'image/png' => 'png',
                'image/jpeg' => 'jpg',
                'image/webp' => 'webp',
                'image/gif' => 'gif',
                'video/mp4' => 'mp4',
                'audio/mpeg' => 'mp3',
                'application/pdf' => 'pdf',
                'application/zip' => 'zip'
            ];

            $ext = $mimeMap[$mime] ?? 'bin';
            if (!isset($mimeMap[$mime])) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'File type not supported',
                    'mime' => $mime
                ], 422);
            }
            $fileName = md5(time() . rand()) . '.' . $ext;

            $path = storage_path('chat_attached/' . $fileName);
            file_put_contents($path, $binary);
            $fileAttached[] = $fileName;
        }
        $user_id = $request->trainer_id;
        $request_to = $request->user_id;
        $save_chat = [
            "user_id" => $user_id,
            "sender_id" => $request_to,
            "message" => $request->message,
            "is_from_id" => $user_id,
            "is_to_id" => $request_to,
            "attechments" => !empty($fileAttached) ? json_encode($fileAttached) : null
        ];
        Chat::insert($save_chat);
        return response()->json([
            "status" => true,
            "message" => "Message sent successfully"
        ]);
    }

    public function chatDashboard(Request $request)
    {
        $userLoggdin = Auth::user();
        $userid = $userLoggdin->id;
        $adminUsers = User::where('role', 'appuser')->whereIsSubscription(1)->whereStatus(1)->pluck('id');
        $getChatQuery = Chat::leftJoin('users', 'users.id', '=', 'chats.is_to_id')->select('chats.sender_id', 'users.name');
        if ($userLoggdin->role != 'admin') {
            $getChatQuery->where('chats.sender_id', $userid);
        } else {
            $getChatQuery->whereIn('chats.sender_id', $adminUsers);
        }
        if ($request->search) {
            $getChatQuery->where('users.name', 'LIKE', '%' . $request->search . '%');
        }
        $listChat = $getChatQuery->orderBy('chats.updated_at', 'desc')->distinct('chats.sender_id', 'users.name')->get();
        $listChatDetail = [];
        foreach ($listChat as $list) {
            $currentTrainer = UserTrainee::where('trainee_user_id', $list->sender_id)->with('user')->first();
            $list->sender = User::select('name', "image")->where('id', $list->sender_id)->first();
            $listChatDetail = Chat::where('sender_id', $list->sender_id)->orWhere('user_id', $list->sender_id)->orderBy("id", "desc")->first();
            $list->currentTrainer = $currentTrainer;
            $list->last_message = $listChatDetail;
        }

        $getChatListedUsers = $listChat->pluck('sender_id')->toArray();
        $adminArray = $adminUsers->toArray();
        $newChat = [];
        foreach ($adminArray as $key) {
            if (!in_array($key, $getChatListedUsers)) {
                $newChat[] = $key;
            }
        }

        $newChat = User::find($newChat);
        foreach ($newChat as $list) {
            $currentTrainer = UserTrainee::where('trainee_user_id', $list->id)->with('user')->first();
            $list->currentTrainer = $currentTrainer;
        }

        $is_chat = Chat::where('user_id', $userid)->orWhere('sender_id', $userid)->exists('user_id');

        $adminQuery = User::where('role', 'appuser')->whereIsSubscription(1)->whereStatus(1);
        $adminUsers = $adminQuery->pluck('id');

        $broadcast = ChatBroadcast::where('user_id', $userid)->with('user_list');
        if ($request->search) {
            $broadcast->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $broadcast = $broadcast->get();

        $resp = array(
            "list" => $listChat,
            "is_chat" => $is_chat,
            "newChat" => $newChat,
            "chat" => $listChatDetail,
            "user" => array(),
            "currentTrainer" => $currentTrainer,
            "all_users" => $adminQuery->get(),
            "broadcast" => $broadcast
        );
        // return $resp;
        return view('chat.dashboard', compact('resp'));
    }

    public function chatDashboardSingleChat(Request $request, $user)
    {
        $userLoggdin = Auth::user();
        $userid = $userLoggdin->id;
        $adminQuery = User::where('role', 'appuser')->whereIsSubscription(1)->whereStatus(1);
        $adminUsers = $adminQuery->pluck('id');
        $getChatQuery = Chat::leftJoin('users', 'users.id', '=', 'chats.is_to_id')->select('chats.sender_id', DB::raw('MAX(chats.created_at) as created_at'));

        if ($userLoggdin->role != 'admin') {
            $getChatQuery->where('chats.sender_id', $userid);
        } else {
            $getChatQuery->whereIn('chats.sender_id', $adminUsers);
        }
        if ($request->search) {
            $getChatQuery->where('users.name', 'LIKE', '%' . $request->search . '%');
        }

        $listChat = $getChatQuery
            ->groupBy('chats.sender_id')
            ->orderBy('chats.created_at', 'desc')
            ->get();

        foreach ($listChat as $list) {
            $currentTrainer = UserTrainee::where('trainee_user_id', $list->sender_id)->with('user')->first();
            $list->sender = User::select('name', "image")->where('id', $list->sender_id)->first();
            $listChatDetail = Chat::where('sender_id', $list->sender_id)->orWhere('user_id', $list->sender_id)->orderBy("id", "desc")->first();
            $list->currentTrainer = $currentTrainer;
            $list->last_message = $listChatDetail;
            try {
                $list->unread_count = Chat::where('user_id', $list->sender_id)->where('status', 0)->count();
            } catch (\Exception $e) {
                $list->unread_count = 0;
            }
        }

        $getChatListedUsers = $listChat->pluck('sender_id')->toArray();
        $adminArray = $adminUsers->toArray();
        $newChat = [];
        foreach ($adminArray as $key) {
            if (!in_array($key, $getChatListedUsers)) {
                $newChat[] = $key;
            }
        }

        $newChat = User::find($newChat);
        foreach ($newChat as $list) {
            $currentTrainer = UserTrainee::where('trainee_user_id', $list->id)->with('user')->first();
            $list->currentTrainer = $currentTrainer;
        }

        $is_chat = Chat::where('user_id', $userid)->orWhere('sender_id', $userid)->exists('user_id');

        if ($this->is_base64($user)) {
            $user_id = openssl_decrypt(base64_decode($user), 'AES-128-CTR', 'kulwindermatharu', 0, 'kulwindermatharu');
        } else {
            $user_id = openssl_decrypt($user, 'AES-128-CTR', 'kulwindermatharu', 0, 'kulwindermatharu');
        }


        $chatQuery = Chat::where('sender_id', $user_id)->orWhere('user_id', $user_id);
        $listChatDetail = $chatQuery->orderBy("id", "desc")->paginate(10)->reverse()->values();
        $userDetail = User::find($user_id);
        $currentTrainer = UserTrainee::where('trainee_user_id', $user_id)->with('user')->first();

        $broadcast = ChatBroadcast::where('user_id', $userid)->with('user_list');
        if ($request->search) {
            $broadcast->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $broadcast = $broadcast->get();
        $resp = array(
            // "sender"=>User::find($t_id),
            "list" => $listChat,
            "is_chat" => $is_chat,
            "chat" => $listChatDetail,
            "user" => $userDetail,
            "currentTrainer" => $currentTrainer,
            "newChat" => $newChat,
            "all_users" => $adminQuery->get(),
            "broadcast" => $broadcast
        );
        // return $resp;
        return view('chat.chat-detail', compact('resp'));
    }
    public function is_base64($s)
    {
        return (bool) preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $s);
    }

    public function chatBroadCastCreate(Request $request)
    {
        $user_id = Auth::user()->id;
        $findExist = ChatBroadcast::where('user_id', $user_id)->where('name', $request->name)->first();

        if (!empty($findExist)) {
            return redirect()->back()->with('error', 'Broadcast already created with same name');
        }
        ChatBroadcast::insert([
            'name' => $request->name,
            'user_list' => json_encode($request->assignuser),
            'tag' => json_encode($request->tags),
            'user_id' => $user_id
        ]);
        return redirect()->back()->with('success', 'Broadcast Created Successfully.');
    }

    public function chatBroadCastUpdate(Request $request)
    {
        $findExist = ChatBroadcast::where('id', $request->uid)->first();

        if (empty($findExist)) {
            return redirect()->back()->with('error', 'Broadcast not found');
        }
        $findExist->name = $request->name;
        $findExist->user_list = json_encode($request->assignuser);
        $findExist->tag = json_encode($request->tags);
        $findExist->save();

        return redirect()->back()->with('success', 'Broadcast Updated.');
    }

    public function chatBroadCastDetails(Request $request, $key)
    {
        $userLoggdin = Auth::user();
        $userid = $userLoggdin->id;
        $adminQuery = User::where('role', 'appuser')->whereIsSubscription(1)->whereStatus(1);
        $adminUsers = $adminQuery->pluck('id');

        $key_id = openssl_decrypt($key, 'AES-128-CTR', 'kulwindermatharu', 0, 'kulwindermatharu');

        $getBroadcastInfo = ChatBroadcast::where('id', $key_id)->first();
        if (empty($getBroadcastInfo)) {
            $key_id = openssl_decrypt(base64_decode($key), 'AES-128-CTR', 'kulwindermatharu', 0, 'kulwindermatharu');
            $getBroadcastInfo = ChatBroadcast::where('id', $key_id)->first();
        }

        $getChatQuery = Chat::leftJoin('users', 'users.id', '=', 'chats.is_to_id')->select('chats.sender_id');
        if ($userLoggdin->role != 'admin') {
            $getChatQuery->where('chats.sender_id', $userid);
        } else {
            $getChatQuery->whereIn('chats.sender_id', $adminUsers);
        }

        if ($request->search) {
            $getChatQuery->where('users.name', 'LIKE', '%' . $request->search . '%');
        }


        $listChat = $getChatQuery->orderBy("chats.id", "desc")->distinct('chats.sender_id')->get();

        foreach ($listChat as $list) {
            $currentTrainer = UserTrainee::where('trainee_user_id', $list->sender_id)->with('user')->first();
            $list->sender = User::select('name', "image")->where('id', $list->sender_id)->first();
            $listChatDetail = Chat::where('sender_id', $list->sender_id)->orWhere('user_id', $list->sender_id)->orderBy("id", "desc")->first();
            $list->currentTrainer = $currentTrainer;
            $list->last_message = $listChatDetail;
        }

        $getChatListedUsers = $listChat->pluck('sender_id')->toArray();

        $adminArray = $adminUsers->toArray();
        $newChat = [];
        foreach ($adminArray as $key) {
            if (!in_array($key, $getChatListedUsers)) {
                $newChat[] = $key;
            }
        }

        $newChat = User::find($newChat);
        foreach ($newChat as $list) {
            $currentTrainer = UserTrainee::where('trainee_user_id', $list->id)->with('user')->first();
            $list->currentTrainer = $currentTrainer;
        }

        $is_chat = Chat::where('user_id', $userid)->orWhere('sender_id', $userid)->exists('user_id');

        // $chatQuery = Chat::where('sender_id',$user_id)->orWhere('user_id',$user_id);
        // $listChatDetail = $chatQuery->orderBy("id","desc")->paginate(10)->reverse()->values();
        // $userDetail = User::find($user_id);
        // $currentTrainer = UserTrainee::where('trainee_user_id',$user_id)->with('user')->first();

        $broadcast = ChatBroadcast::where('user_id', $userid)->with('user_list');
        if ($request->search) {
            $broadcast->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $broadcast = $broadcast->get();

        $resp = array(
            "list" => $listChat,
            "is_chat" => $is_chat,
            "newChat" => $newChat,
            "all_users" => $adminQuery->get(),
            "broadcast" => $broadcast,
            "broadcast_info" => $getBroadcastInfo,

        );
        // return $resp;
        return view('chat.chat-broadcast-detail', compact('resp'));
    }

    public function getBroadCastChat(Request $request)
    {
        $broadcast_chat = BroadcastMessage::where('broadcast_messages.chat_broadcast_id', $request->key_id)
            ->leftJoin('users as sender', 'sender.id', '=', 'broadcast_messages.user_id')
            ->select(
                'broadcast_messages.*',
                'sender.id as sender_user_id',
                'sender.name as sender_name',
                'sender.email as sender_email',
                'sender.image as sender_profile'
            )
            ->orderBy("id", "desc")
            ->paginate(10)
            ->reverse()
            ->values();
        return $broadcast_chat;
    }

    public function sentBroadCastChat(Request $request)
    {
        $fileAttached = [];

        if (!empty($request->attached_image)) {
            $base64 = $request->attached_image;
            if (strpos($base64, 'base64,') !== false) {
                $base64 = explode('base64,', $base64)[1];
            }

            $binary = base64_decode($base64);
            $mime = $this->detectMimeFromBinary($binary);

            $mimeMap = [
                'image/png' => 'png',
                'image/jpeg' => 'jpg',
                'image/webp' => 'webp',
                'image/gif' => 'gif',
                'video/mp4' => 'mp4',
                'audio/mpeg' => 'mp3',
                'application/pdf' => 'pdf',
                'application/zip' => 'zip'
            ];

            $ext = $mimeMap[$mime] ?? 'bin';
            if (!isset($mimeMap[$mime])) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'File type not supported',
                    'mime' => $mime
                ], 422);
            }
            $fileName = md5(time() . rand()) . '.' . $ext;

            $path = storage_path('chat_attached/' . $fileName);
            file_put_contents($path, $binary);
            $fileAttached[] = $fileName;
        }

        BroadcastMessage::insert([
            "user_id" => Auth::user()->id,
            "chat_broadcast_id" => $request->key_id,
            "message" => $request->message,
            "attechments" => !empty($fileAttached) ? json_encode($fileAttached) : NULL
        ]);
        return response()->json("Message sent successfully");
    }

    //Recipe
    public function recipeIngredients()
    {
        if (permission('recipe_list', 'read')) {
            $listing = RecipeIngredient::orderBy('id', 'desc')->paginate(10);
            return view('admin.updates.recipe_ingredients', compact('listing'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function recipeIngredientsDatatable(Request $request)
    {
        if (permission('recipe_list', 'read')) {
            $qry = [];
            $search = ['name', 'description'];
            $with = [];
            return dataTableCommon($request, RecipeIngredient::select('*'), $search, $qry, $with);
        }
        return "Unauthorized";
    }

    public function recipeIngredientsStore(Request $request)
    {

        if (permission('recipe_list', 'create')) {
            $ins_query = [
                "name" => $request->name,
                "type" => $request->type,
                "calories" => $request->calories,
                "protein" => $request->protein,
                "crabs" => $request->crabs,
                "qty" => $request->qty,
                "fats" => $request->fat,
                "description" => $request->description
            ];
            RecipeIngredient::insert($ins_query);
            return redirect(route("recipe-ingredients"))->with("success", "Recipe Added");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function recipeIngredientsRemove(Request $request)
    {
        if (permission('recipe_list', 'delete')) {
            $listing = RecipeIngredient::where('id', $request->id)->first();
            $listing->delete();
            return redirect(route("recipe-ingredients"))->with("success", "Ingredient Deleted");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function recipeRemove(Request $request)
    {
        if (permission('recipe_list', 'delete')) {
            $listing = RecipeList::where('id', $request->id)->first();
            $listing->delete();
            return redirect(route("recipe-list"))->with("success", "Recipe Deleted");
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }

    public function userDietPlan(Request $request, $id)
    {
        $userDetail = User::where('id', $id)->with('plan')->first();
        if ($userDetail->role != "appuser") {
            return redirect(route('app-users', ['id' => $id]))->with('error', "Internal Users not shows app users statistics");
        }
        $all_user = UserrAlter::select('id', 'diet_plan', 'name', 'email')->where('role', 'appuser')->get();
        return view('admin.appuser.dietplan', compact('userDetail', 'all_user'));
    }

    // public function userDietPlan(Request $request,$id)
    //     {
    //         $userDetail = User::where('id',$id)->with('plan')->first();
    //         if($userDetail->role!="appuser"){
    //             return redirect(route('app-users',['id'=>$id]))->with('error',"Internal Users not shows app users statistics");
    //         }
    //         $all_user = User::where('role','appuser')->get();
    //         return view('admin.appuser.dietplan',compact('userDetail','all_user'));
    //     }

    public function updateDietPlan(Request $request, $id)
    {
        $userDetail = User::where('id', $id)->with('plan')->first();
        if ($userDetail->role != "appuser") {
            return redirect(route('app-users', ['id' => $id]))->with('error', "Internal Users not shows app users statistics");
        }
        $userDetail->diet_plan = base64_encode($request->html);
        if ($userDetail->save()) {
            return response()->json(['status' => 'error', 'message' => 'Diet Plan Saved.'], 200);
        }
        return response()->json(['status' => 'error', 'message' => 'Something went wrong!'], 400);
    }

    // public function appUserDatatable(Request $request)
    //     {
    //         if(permission('app_users','read')){
    //             $userQry = User::where('role','appuser');
    //             $total = $userQry->count();
    //             if(!empty($request['search']['value'])){
    //                 $serachQ = $request['search']['value'];
    //                 $userQry->where('name','like','%'.$serachQ.'%');
    //                 $userQry->orWhere('email','like','%'.$serachQ.'%');
    //                 $userQry->orWhere('phone','like','%'.$serachQ.'%');
    //             }
    //             if(!empty($request['order'][0]['column'])){
    //                 $colID = $request['order'][0]['column'];
    //                 $colName = ($request['columns'][$colID]['data']??'');
    //                 if(!empty($colName)){
    //                     $userQry->orderBy($colName, $request['order'][0]['dir']);
    //                 }
    //             }
    //             $user = $userQry->offset($request->start)->limit($request->length)->get();
    //             $getRes = [
    //                 "recordsTotal"=>$total,
    //                 "recordsFiltered"=> $total,
    //                 "data"=>$user,
    //             ];
    //             return $getRes;
    //         }
    //         return "Unauthorized";
    //     }

    public function appUserDatatable(Request $request)
    {
        if (permission('app_users', 'read')) {
            $qry = ['role,appuser'];
            $search = ['name', 'email', 'phone'];
            $with = [];
            return dataTableCommon($request, User::select('*'), $search, $qry, $with);
            // $userQry = User::where('role','appuser');
            // $total = $userQry->count();
            // if(!empty($request['search']['value'])){
            //     $serachQ = $request['search']['value'];
            //     $userQry->where('name','like','%'.$serachQ.'%');
            //     $userQry->orWhere('email','like','%'.$serachQ.'%');
            //     $userQry->orWhere('phone','like','%'.$serachQ.'%');
            // }
            // if(!empty($request['order'][0]['column'])){
            //     $colID = $request['order'][0]['column'];
            //     $colName = ($request['columns'][$colID]['data']??'');
            //     if(!empty($colName)){
            //         $userQry->orderBy($colName, $request['order'][0]['dir']);
            //     }
            // }
            // $user = $userQry->offset($request->start)->limit($request->length)->get();
            // $getRes = [
            //     "recordsTotal"=>$total,
            //     "recordsFiltered"=> $total,
            //     "data"=>$user,
            // ];
            // return $getRes;
        }
        return "Unauthorized";
    }

    public function weeklyUpdateDatatable(Request $request)
    {
        if (permission('weekly_update', 'read')) {
            $qry = [];
            $search = ['descibe_diet', 'date', 'describe_workout', 'suggestion', 'weight'];
            $with = ['user:id,name,email'];
            if (!empty($request->startDate) && !empty($request->endDate)) {
                $qry[] = "wherebetween,date,''," . base64_encode('["' . $request->startDate . '","' . $request->endDate . '"]');
                // $qry[] = "wheredate,date,>=,".base64_encode($request->startDate);
                // $qry[] = "wheredate,date,<=,".base64_encode($request->endDate);
            }
            if (!empty($request->selectedUser)) {
                if ($request->selectedUser != 'all') {
                    $qry[] = "user_id," . $request->selectedUser;
                }
            }
            // return $qry;
            return dataTableCommon($request, WeeklyUpdate::select('*'), $search, $qry, $with);
        }
        return "Unauthorized";
    }

    public function mealPictureDatatable(Request $request)
    {
        if (permission('meal_picture', 'read')) {
            $qry = [];
            $search = ['date', 'description'];
            $with = ['user:id,name,email'];
            if (!empty($request->startDate) && !empty($request->endDate)) {
                $qry[] = "wherebetween,date,''," . base64_encode('["' . $request->startDate . '","' . $request->endDate . '"]');
                // $qry[] = "wheredate,date,>=,".base64_encode($request->startDate);
                // $qry[] = "wheredate,date,<=,".base64_encode($request->endDate);
            }
            if (!empty($request->selectedUser)) {
                if ($request->selectedUser != 'all') {
                    $qry[] = "user_id," . $request->selectedUser;
                }
            }
            // return $qry;
            return dataTableCommon($request, MealPicture::select('*'), $search, $qry, $with);
        }
        return "Unauthorized";
    }

    public function wrokoutPlansDatatable(Request $request)
    {
        if (permission('workout_plans', 'read')) {
            $qry = [];
            $search = ['title'];
            $with = ['user:name,email,id'];
            // if(!empty($request->startDate) && !empty($request->endDate)){
            //     $qry[] = "wherebetween,date,'',".base64_encode('["'.$request->startDate.'","'.$request->endDate.'"]');
            //     // $qry[] = "wheredate,date,>=,".base64_encode($request->startDate);
            //     // $qry[] = "wheredate,date,<=,".base64_encode($request->endDate);
            // }
            if (!empty($request->selectedUser)) {
                if ($request->selectedUser != 'all') {
                    $qry[] = "user_id," . $request->selectedUser;
                }
            }
            // return $qry;
            return dataTableCommon($request, WorkoutPlan::select('*'), $search, $qry, $with);
        }
        return "Unauthorized";
    }
    public function wrokoutPlansDayDatatable(Request $request)
    {
        if (permission('workout_plan_days', 'read')) {
            $qry = [];
            $search = ['title'];
            $with = ['user:id,name,email', 'plans_uuid'];
            // if(!empty($request->startDate) && !empty($request->endDate)){
            //     $qry[] = "wherebetween,date,'',".base64_encode('["'.$request->startDate.'","'.$request->endDate.'"]');
            //     // $qry[] = "wheredate,date,>=,".base64_encode($request->startDate);
            //     // $qry[] = "wheredate,date,<=,".base64_encode($request->endDate);
            // }
            if (!empty($request->selectedUser)) {
                if ($request->selectedUser != 'all') {
                    $qry[] = "user_id," . $request->selectedUser;
                }
            }
            // return $qry;
            return dataTableCommon($request, WorkoutPlanDay::select('*'), $search, $qry, $with);
        }
        return "Unauthorized";
    }

    public function getCaloriesInfo(Request $request)
    {

        $userDetail = User::find($request->user);
        //Current BMR CALC
        $age = round(((strtotime('now') - strtotime($userDetail->dob)) / 86400) / 365);

        $getHeightCalc = explode('_', $userDetail->height);

        $cbmr = '';
        if (count($getHeightCalc) > 1) {
            if ($getHeightCalc[1] == 'cm') {
                //  $getH = explode('.',round((floatval($getHeightCalc[0])/30.48),2));
                $feet = 0;
                $inches = $getHeightCalc[0];
                $totalheight = $inches;

            } else if ($getHeightCalc[1] == 'ft') {
                $getH = explode('.', $getHeightCalc[0]);
                $feet = $getH[0];
                $inches = $getH[1];
                $totalheight = ($inches + ($feet * 12)) * 2.54;
            }

            $getWeightCl = explode('_', $userDetail->weight);
            //  return $getWeightCl;
            $weight = 0;
            if (count($getWeightCl) > 0) {
                if ($getWeightCl[1] == "lbs") {
                    $weight = floatval($getWeightCl[0]) / 2.205;
                } else {
                    $weight = (int) $getWeightCl[0];
                }
            }

            $exercise = 0;
            if ($userDetail->activity_level == "intermediate") {
                $exercise = 1.375;
            } else if ($userDetail->activity_level == "advanced") {
                $exercise = 1.70;
            }


            $answer = 5 + (((10 * $weight) + (6.25 * $totalheight)) - (5 * $age));
            if ($exercise > 0) {
                $answer = $answer * $exercise;
            }
            $cbmr = round($answer);
        }

        $date = date('Y-m-d', strtotime($request->date ?? 'now'));
        $takenCalories = getUserCalories($date, $userDetail->id);//MealPicture::whereDate('date',$date)->where('is_approved',1)->where('user_id',$userDetail->id)->sum('calories');

        $calories = "<b>Intake</b>: $takenCalories";
        $calories .= "&#160;&#160;<b>Remaining</b>: " . ($userDetail->bmr ? ($userDetail->bmr - $takenCalories ?? '') : ($cbmr ? ($cbmr - $takenCalories) ?? '' : 0));
        $calories .= "&#160;&#160;<b>Total</b>: " . ($userDetail->bmr ? ($userDetail->bmr ?? '') : ($cbmr ? ($cbmr) ?? '' : 0));

        return response()->json(['status' => "success", "message" => "Calories Updated", "date" => date("d F Y", strtotime($date)), "final" => $calories]);
    }

    public function exerciseMachines(Request $request)
    {
        return view('admin.exercise.machines');
    }

    public function exerciseMachineDatatable(Request $request)
    {
        $search = ['name'];
        return dataTableCommon($request, ExerciseMachine::select('*'), $search, [], []);
    }
    public function deleteExerciseMachine(Request $request, $id)
    {
        $info = ExerciseMachine::whereId($id)->first();
        if (!empty($info)) {
            $is_includes = WorkoutDay::where('exercise_machine', $info->uuid)->exists();
            if ($is_includes) {
                return redirect()->back()->with("error", "Exercise machine already include in workout exercise");
            }
            $info->delete();
            return redirect()->back()->with("success", "Exercise Machine Deleted");
        } else {
            return redirect()->back()->with("error", "Exercise Machine not found");
        }
    }
    public function saveExerciseMachine(Request $request)
    {
        $exercise = [
            "name" => $request->name,
            "exercise_type" => $request->exercise_type
        ];
        $is_includes = ExerciseMachine::where('name', $request->name)->exists();
        if ($is_includes) {
            return redirect()->back()->with("error", "Exercise machine already exists with same name");
        }
        ExerciseMachine::create($exercise);
        return redirect()->back()->with('success', 'Exercise Machine Added Successfully.');
    }

    public function getLanguageFile($file)
    {
        $file_path = base_path('storage/app/i18n/' . $file);
        $file = File::get($file_path);
        $file_convert = json_decode($file, true);
        return $file_convert;
    }

    public function editAppLanguagesView($id)
    {
        $lang = Language::find($id);
        if (empty($lang)) {
            return redirect()->back()->with('error', "Something went wrong");
        }
        $file_path = base_path('storage/app/i18n/' . $lang->file_path);
        $file = File::get($file_path);
        $file_convert = json_decode($file, true);
        return view('languages.edit', compact('lang', 'file_convert', 'file'));
    }

    public function workoutPlansDayView(Request $request, $id)
    {
        if (permission('workout_days', 'read')) {
            $workoutplan = WorkoutPlanDay::whereStatus(1)->where('id', base64_decode($id))->first();

            if (empty($workoutplan)) {
                return redirect()->back()->with('error', "Not Found");
            }
            $plans = WorkoutDay::where('plan_days_uuid', $workoutplan->uuid)->orderBy('id', "desc")->paginate(10);
            foreach ($plans as $list) {
                if (!empty($list->user_id)) {
                    $list->user = User::find($list->user_id);
                }
                $list->workout_plan_days = WorkoutPlanDay::where('uuid', $list->plan_days_uuid)->first();
                $list->plan = WorkoutPlan::whereStatus(1)->where('uuid', $list->plans_uuid)->first();
            }
            $workoutPlans = WorkoutPlanDay::whereStatus(1)->orderBy('id', "desc")->with('user')->get();
            foreach ($workoutPlans as $list) {
                $list->plan = WorkoutPlan::whereStatus(1)->where('uuid', $list->plans_uuid)->first();
            }
            $exercise_machines = ExerciseMachine::get();
            return view('admin.workout.workout-days-v2', compact('plans', 'workoutPlans', 'exercise_machines', 'workoutplan'));
        }
        return redirect(route('dashboard'))->with('error', "Unauthorized");
    }
    public function updateWeight(Request $request)
    {
        $user = User::find($request->uid);
        $user->weight = (string) $request->value . "_kg";
        $user->save();
        WeightLog::insert([
            "weight" => $request->value,
            "user_id" => $user->id,
            "date" => date('Y-m-d', strtotime('now'))
        ]);
        return response()->json(["status" => "success", "message" => " Weight Update Successfully"], 200);
    }

    public function saveUpdates(REquest $request)
    {
        $user = User::find($request->uid);
        $currentDateTo = date('Y-m-d', strtotime('now'));
        $between = $this->x_week_range2($currentDateTo);
        $isExist = CustomUpdates::whereBetween('date', $between)->where('type', $request->type)->where('user_id', $user->id)->first();
        if (empty($isExist)) {
            CustomUpdates::insert([
                "type" => $request->type,
                "value" => $request->value,
                "user_id" => $user->id,
                "date" => $currentDateTo
            ]);
        } else {
            $isExist->type = $request->type;
            $isExist->value = $request->value;
            $isExist->save();
        }

        return response()->json(["status" => "success", "message" => " Update Successfully"], 200);
    }
}
