<?php

namespace App\Http\Controllers;
use App\Models\Plan;
use Razorpay\Api\Api;

use Illuminate\Http\Request;

class PaymentController extends Controller
{
    //
    // purchaseAPlan
    public function purchaseAPlan(Request $request,$id)
        {
            $is_exist = Plan::find($id);
            if(empty($is_exist)){
                return response()->json(["status"=>"error","message"=>"Invalid Plan ID"]);
            }
            $final_price = $is_exist->amount * ( (100-$is_exist->discount) / 100 );
            if($final_price<=0){
                return response()->json(["status"=>"error","message"=>"Free Plan"]);
            }
            $api = new Api (env('RAZORPAY_KEY'), env('RAZORPAY_SECRET'));
            $user =  auth()->user();

            if(empty($user->gateway_customer_id)){
                $customer = $api->customer->create([
                    "name"=> $user->name,
                    "contact"=> $user->mobile_no,
                    "email"=> $user->email
                ]);
                $user->gateway_customer_id = $customer->id;
                $user->save();
            }
           
            return $user->gateway_customer_id;
        }
    public function handlePayment(Request $request)
        {
            $input = $request->all();
            $api = new Api(env('RAZORPAY_KEY'), env('RAZORPAY_SECRET'));
            $payment = $api->payment->fetch($input['razorpay_payment_id']);
            if (count($input) && !empty($input['razorpay_payment_id'])) {
                try {
                    $response = $api->payment->fetch($input['razorpay_payment_id'])->capture([
                        'amount' => $payment['amount']
                    ]);
                    // $payment = Payment::create([
                    //     'r_payment_id' => $response['id'],
                    //     'method' => $response['method'],
                    //     'currency' => $response['currency'],
                    //     'user_email' => $response['email'],
                    //     'amount' => $response['amount'] / 100,
                    //     'json_response' => json_encode((array)$response)
                    // ]);
                } catch (Exception $e) {
                    Log::info($e->getMessage());
                    return back()->withError($e->getMessage());
                }
            }
            return back()->withSuccess('Payment done.');
        }
}
