<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;

class RecipeGuideList extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'recipe_guide_lists';

    public $fillable = ['title','short_title','video_type','video_url','description','status','sequence','cat_uid'];

    public function getVideoUrlAttribute($e)
        {
            $erd = ("https://img.youtube.com/vi/".$e."/0.jpg"??"");
            $this->video_image = $erd;
            return $e;
            // return $e;
        }

    public function getCatUidAttribute($e)
        {
            // cat_uid
            return RecipeCategories::where('uuid',$e)->first();
        }

}
