<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;

class UserrAlter extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable;


    protected $table = "users";
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'gateway_customer_id',
        'gateway_plan_id',
        'gateway_ref',
        'gateway_sub_id',
        'role',
        'plan_id',
        'diet_plan'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'gateway_customer_id',
        'gateway_plan_id',
        'gateway_ref',
        'gateway_sub_id',
        'role',
        'plan_id',
        'google_access_token',
        'google_refresh_token'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
     /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function scopeDesc()
    {
        return $this->orderBy('id','desc');
    }
    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }

    public function language()
        {
            return $this->belongsTo(Language::class,'language','id');
        }

    public function getImageAttribute($e)
        {
            return env("APP_URL_STR").'users/default.jpg';
        }

    public function getNotificationSettingsAttribute($e) 
        {
            return json_decode($e);
        }

        
}
