<!DOCTYPE html>
<html lang="en">

<head>
    <title>App Languages</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            <!-- @if(permission('language','create'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Language File</button>@endif -->
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >App Languages</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>App Languages</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Status</th>
                                            @if(permission('language','update') || permission('language','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($language as $index => $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{{$list->name}}</td>
                                            <td>
                                                @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                @if($list->status==0)<span class="badge bg-gradient-danger">Inactive</span>@endif
                                            </td>
                                            @if(permission('language','update') || permission('language','delete'))
                                            <td>
                                            @if(permission('language','update'))
                                                <a href="{{route('status-app-languages',['id'=>$list->id])}}" onclick="return confirm('Change Status?')">
                                                    <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-refresh-cw"></i></button>
                                                </a>
                                                <a href="{{route('edit-app-languages',['id'=>$list->id])}}" >
                                                    <button class="btn btn-sm bg-gradient-info pr" ><i class="feather icon-edit"></i></button>
                                                </a>
                                            @endif
                                            @if(permission('language','delete'))
                                                <!-- <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button> data-toggle="modal" data-target="#exampleModalLive{{$index}}q"-->
                                            @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5"> Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $language->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Language</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form action="{{route('store-app-languages')}}"  method="post" enctype='multipart/form-data'>
                    <div class="modal-body">
                        <div class="row">
                                <div class="col-md-12">
                                    @csrf
                                    <div class="form-group">
                                        <label for="name_p">Name</label>
                                        <input type="text" class="form-control" id="name_p" name="name" placeholder="Enter name" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="file_p">JSON Language File</label>
                                        <input type="file" class="form-control" name="lang_file" id="file_p" required >
                                    </div>
                                
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                            </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @forelse($language as $index => $list)
        <div id="exampleModalLive{{$index}}q" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Add a New Language</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <form action="{{route('update-app-languages',['id'=>$list->id])}}"  method="post" enctype='multipart/form-data'>
                        <div class="modal-body">
                            <div class="row">
                                    <div class="col-md-12">
                                        @csrf
                                        <div class="form-group">
                                            <label for="name_p">Name</label>
                                            <input type="text" class="form-control" id="name_p" value="{{$list->name}}" name="name" placeholder="Enter name" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="file_p">JSON Language File</label>
                                            <input type="file" class="form-control" name="lang_file" id="file_p" @if(empty($list->file_path)) required @endif >
                                        </div>
                                    
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                                </div>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    @endforeach
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>
</body>

</html>