<!DOCTYPE html>
<html lang="en">

<head>
    <title>Exercise Machines</title>
    @include('includes.header')
    <script src="{{asset('assets/js/bs/bootstrap.min.css')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.css')}}"></script> 
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            <button class="m-b-10 btn bg-gradient-info pr " data-toggle="modal" data-target="#exampleModalLive">Add Exercise Machine</button>
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Exercise Machines</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Exercise Machines</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                            <table id="getUserData" class="table table-striped" style="width:100%">
                            </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add Exercise Machines</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save-exercise-machine')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" >
                                
                            </div>
                            <div class="form-group">
                                <label for="exercise_type">Exercise Type <span class="text-danger">*</span></label>
                                <select class="form-control" name="exercise_type" required>
                                    <option value=""  disabled>Select</option>
                                    <option value="strength" selected >Strength</option>
                                </select>
                            </div>
                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div> 
        </div>
    </div>
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    <script src="{{asset('assets/js/bs/dataTables.js')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.js')}}"></script>
    

    <script>
    
            // $('#example').DataTable({
            new DataTable('#getUserData', {
                "ajax": {
                    "url": "{{route('exercise_machines_data')}}",
                    "data": function ( d ) {
                            d.additionalFilter='';
                        },
                    "dataSrc": function ( json ) {
                        return json.data;
                    }
                },
                fixedHeader: true,
                responsive: true,
                processing: true,
                serverSide: true,
                columns: [
                    { data: 'id',title:"#",
                        render:function(data,type,row){
                            var statusURL = "{{ route('app-users-sts', ['id' => ':id']) }}";
                            statusURL = statusURL.replace(':id', data);
                           
                            var deleteURL = "{{ route('delete-exercise-machine', ['id' => ':id']) }}";
                            deleteURL = deleteURL.replace(':id', data);

                            // <a href="`+statusURL+`" onclick="return confirm('Change Status?')">
                            //             <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-refresh-cw"></i></button>
                            //     </a>
                            //     <button class="btn btn-sm bg-gradient-info pr"  data-toggle="modal" data-target="#exampleModalLive`+data+`q"><i class="feather icon-edit"></i></button>
                            return `
                                <a href="`+deleteURL+`" onclick="return confirm('Are you sure? Delete')">
                                    <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                </a>
                            `;
                        }
                    },
                    { data: 'name',title:"Name",
                        "render":function(data,type,row){
                            var name = data;
                            if(row['status']==1){
                                return name+`<br><span class="badge bg-gradient-success">Active</span>`;
                            } else if(row['status']==0){
                                return name+`<br><span class="badge bg-gradient-danger">Disabled</span>`;
                            }
                            
                        }
                    },
                    { data: 'exercise_type',title:"Exercise Type" }
                   
                ],
                language: {
                    searchPlaceholder: "By Name"
                }
            });


    </script>
</body>

</html>