<!DOCTYPE html>
<html lang="en">

<head>
    <title>Contact Info </title>
    @include('includes.header')
    <script src="https://cdn.tiny.cloud/1/vzsbabl41dquoqb8uiq1co621duklluitrrj6akhlplahhqx/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
    tinymce.init({
        selector: 'textarea',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link table mergetags | align lineheight | tinycomments | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
        ai_request: (request, respondWith) => respondWith.string(() => Promise.reject("See docs to implement AI Assistant")),
    });
    </script>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('contact_info','update'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Contact Info</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Contact Info</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Contact Info</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>HTML</th>
                                            <th>Status</th>
                                            @if(permission('contact_info','update') || permission('contact_info','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($cont as $index => $list )
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td> {!! $list->html !!}</td>
                                            <td>
                                                @if($list->is_active==0)<span class="badge bg-gradient-warning">Draft</span>@endif
                                                @if($list->is_active==1)<span class="badge bg-gradient-success">Active</span>@endif
                                            </td>
                                            @if(permission('contact_info','update') || permission('contact_info','delete'))
                                            <td>
                                                @if(permission('contact_info','update'))
                                                    <a href="{{route('status-contact-info',['id'=>$list->id])}}" onclick="return confirm('Change Status?')">
                                                        <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-refresh-cw"></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-success" data-toggle="modal" data-target="#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button>
                                               
                                                @endif
                                                @if(permission('contact_info','delete'))
                                                    <a href="{{route('delete-contact-info',['id'=>$list->id])}}">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5" class="text-center"> Empty</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $cont->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Contact Info</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <form action="{{route('store-contact-info')}}" id="storeUser" method="post">
                        <div class="row">
                            @csrf
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="myname">HTML <span class="text-danger">*</span></label>
                                    <textarea name="html" id="getHTML" >Enter Contact Information</textarea>
                                </div>
                            </div>
                        
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @foreach($cont as $index => $list )
    <div id="exampleModalLive{{$index}}q" class="modal fade"  role="dialog" aria-labelledby="exampleModalLive1Labe{{$index}}q" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Edit Contact Info</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <form action="{{route('update-contact-info',['id'=>$list->id])}}" id="storeUser{{$index}}q" data-id="getHTML{{$index}}q" method="post">
                        <div class="row">
                            @csrf
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="myname">HTML <span class="text-danger">*</span></label>
                                    <textarea name="html" id="getHTML{{$index}}q" >{{$list->html}}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>
    @foreach($cont as $index => $list )
    <script>
       
        $(document).on('submit','#storeUser{{$index}}q',()=>{
            var cont = tinymce.get("getHTML{{$index}}q").getContent();
            $('#getHTML{{$index}}q').html(cont);
            $('#storeUser{{$index}}q').submit();
        });
    </script>
    @endforeach
    <script>
       
       $(document).on('submit','#storeUser',()=>{
           var cont = tinymce.get("getHTML").getContent();
           $('#getHTML').html(cont);
           $('#storeUser').submit();
       });
   </script>
</body>

</html>