<!DOCTYPE html>
<html lang="en">

<head>
    <title>Meditation List</title>
    @include('includes.header')
    <script src="https://cdn.tiny.cloud/1/vzsbabl41dquoqb8uiq1co621duklluitrrj6akhlplahhqx/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
    tinymce.init({
        selector: 'textarea',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link table mergetags | align lineheight | tinycomments | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
        ai_request: (request, respondWith) => respondWith.string(() => Promise.reject("See docs to implement AI Assistant")),
    });
    </script>
</head>
<body>  
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('meditation_deepsleep','create')) <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Mediation</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Mediation Deep Sleep</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Mediation Deep Sleep</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Total Time</th>
                                            <th>In Time</th>
                                            <th>Out Time</th>
                                            <th>Is Fie Added</th>
                                            <th>Status</th>
                                            @if(permission('meditation_deepsleep','update') || permission('meditation_deepsleep','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($listing as $index=> $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{!! $list->name !!}</td>
                                            <td>{!! $list->total_time !!}</td>
                                            <td>{!! $list->in_interval !!}</td>
                                            <td>{!! $list->out_interval !!}</td>
                                            <td>
                                                @if(!empty($list->file_path))<span class="badge bg-gradient-success">Added</span>
                                                @else <span class="badge bg-gradient-warning"> Not Added</span>@endif
                                            </td>
                                            <td>
                                                @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                @if($list->status==2)<span class="badge bg-gradient-warning">Draft</span>@endif
                                                @if($list->status==0)<span class="badge bg-gradient-danger">Inactive</span>@endif
                                            </td>
                                            @if(!permission('meditation_deepsleep','update') || permission('meditation_deepsleep','delete'))
                                            <td>
                                                @if(permission('meditation_deepsleep','update'))
                                                    <a href="{{route('status-deepsleep-meditation',['id'=>$list->id])}}" onclick="return confirm('Change Status?')">
                                                        <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-refresh-cw"></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button>
                                                @endif
                                                @if(permission('meditation_deepsleep','delete'))
                                                    <a href="{{route('delete-deepsleep-meditation',['id'=>$list->id])}}" onclick="return confirm('Are you sure? Delete Meditation')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5">Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $listing->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Meditation Deep Sleep</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save-deepsleep-meditation')}}" method="post" enctype='multipart/form-data'>
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="title_p">Name</label>
                                <input type="text" class="form-control" name="title" id="title_p" required placeholder="Name">
                            </div>
                            <div class="form-group">
                                <label for="totaltile_p">Total Time <em>(Add time in seconds)</em></label>
                                <input type="number" class="form-control" name="totaltile" id="totaltile_p" required placeholder="Total Time">
                            </div>
                            <div class="form-group">
                                <label for="in_p">In Interval <em>(Add time in seconds)</em></label>
                                <input type="text" class="form-control" name="in" id="in_p" required placeholder="In Interval">
                            </div>
                            <div class="form-group">
                                <label for="out_p">Out Interval <em>(Add time in seconds)</em></label>
                                <input type="text" class="form-control" name="out" id="out_p" required placeholder="Out Interval">
                            </div>
                            <div class="form-group">
                                <label for="getHTML">Audio File</label>
                                <input type="file" name="file" class="form-control"  >
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    @forelse($listing as $index=> $list)
    <div id="exampleModalLive{{$index}}q" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Update Mediation Deep Sleep</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('update-deepsleep-meditation',['id'=>$list->id])}}" method="post" enctype='multipart/form-data' >
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="title_p">Name</label>
                                <input type="text" class="form-control" value="{{$list->name}}" name="title" id="title_p" aria-describedby="emailHelp" required placeholder="Title">
                            </div>
                            <div class="form-group">
                                <label for="totaltile_p">Total Time <em>(Add time in seconds)</em></label>
                                <input type="number" class="form-control"  value="{{$list->total_time}}" name="totaltile" id="totaltile_p" required placeholder="Total Time">
                            </div>
                            <div class="form-group">
                                <label for="in_p">In Interval <em>(Add time in seconds)</em></label>
                                <input type="text" class="form-control" name="in"  value="{{$list->in_interval}}" id="in_p" required placeholder="In Interval">
                            </div>
                            <div class="form-group">
                                <label for="out_p">Out Interval <em>(Add time in seconds)</em></label>
                                <input type="text" class="form-control" name="out"  value="{{$list->out_interval}}" id="out_p" required placeholder="Out Interval">
                            </div>
                            <div class="form-group">
                                <label for="getHTML">Audio File</label>
                                <input type="file" name="file" class="form-control"  >
                                <audio  src="{{$list->file_path}}"></audio>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach

    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    @foreach($listing as $index => $list )
    <script>
       
        $(document).on('submit','#storeUser{{$index}}q',()=>{
            var cont = tinymce.get("getHTML{{$index}}q").getContent();
            $('#getHTML{{$index}}q').html(cont);
            $('#storeUser{{$index}}q').submit();
        });
    </script>
    @endforeach
    <script>
       
       $(document).on('submit','#storeUser',()=>{
           var cont = tinymce.get("getHTML").getContent();
           $('#getHTML').html(cont);
           $('#storeUser').submit();
       });
   </script>
</body>

</html>