<!DOCTYPE html>
<html lang="en">

<head>
    <title>Requests Premium</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                           
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Requests Premium</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Requests Premium</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>User</th>
                                            <th>Current Plan</th>
                                            <th>Requested For Plan</th>
                                            <th>Requested On</th>
                                            <th>Status</th>
                                            @if(permission('request_premium','update') || permission('request_premium','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($listing as $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{{$list->user->name}}
                                                <a target="_blank" href="{{route('app-users-sts',['id'=>$list->user->id])}}"><span class="btn btn-sm bg-gradient-dark"><i class="feather icon-external-link"></i></span></a><br>
                                                <a href="tel:{{$list->user->phone}}"> <span class="btn btn-sm bg-gradient-warning"><i class="feather icon-phone"></i></span></a>
                                                <a href="mailto:{{$list->user->email}}"><span class="btn btn-sm bg-gradient-success"><i class="feather icon-mail"></i></span></a>
                                            </td>
                                            <td style="background:#e2e2e2">Plan: 
                                                @if(!empty($list->current_plan->name))
                                                    {{$list->current_plan->name}}<br>
                                                    Duration: {{$list->current_plan->duration}}<br>
                                                    Price: @if($list->current_plan->amount>0)<span class="badge bg-gradient-warning">&#8377; {{$list->current_plan->amount}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif <br>
                                                    Final Price :@if($list->current_plan->final_price>0)<span class="badge bg-gradient-info">&#8377; {{$list->current_plan->final_price}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif <br>
                                                    Discount @if($list->current_plan->discount>0)<span class="badge bg-gradient-info pr">{{$list->current_plan->discount}}%</span> @endif 
                                                    @if($list->current_plan->amount>0)<br> Expiry : {{date('d M Y',strtotime((json_decode($list->user->gateway_ref)->end)??''))}} @endif
                                                @else
                                                <span class="badge bg-gradient-success">Free</span>
                                                @endif
                                            </td>
                                            <td style="background:#b4ddc5">Plan: 
                                                @if(!empty($list->plan->name)) {{$list->plan->name}}<br>
                                                    Duration: {{$list->plan->duration}}<br>
                                                    Price: @if($list->plan->amount>0)<span class="badge bg-gradient-warning">&#8377; {{$list->plan->amount}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif <br>
                                                    Final Price :@if($list->plan->final_price>0)<span class="badge bg-gradient-info">&#8377; {{$list->plan->final_price}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif <br>
                                                    Discount @if($list->plan->discount>0)<span class="badge bg-gradient-info pr">{{$list->plan->discount}}%</span> @endif
                                                @else
                                                <span class="badge bg-gradient-success">Free</span>
                                                @endif
                                            </td>
                                            <td>{{date('d M Y',strtotime($list->created_at))}}</td>
                                            <td>@if($list->status==0)
                                                    <span class="badge bg-gradient-secondary">Draft</span>
                                                @elseif($list->status==1)
                                                    <span class="badge bg-gradient-warning">Call Pending</span>
                                                @elseif($list->status==2)
                                                    <span class="badge bg-gradient-info pr">Payment Pending</span>
                                                @elseif($list->status==3)
                                                    <span class="badge bg-gradient-success">Plan Activated</span>
                                                @endif
                                                @if(!empty($list->last_update))
                                                    <br>
                                                    Last Update: {{$list->last_update->name}}<br>
                                                    Role: {{$list->last_update->role}}<br>
                                                    Email: {{substr_replace($list->last_update->email, str_repeat('*', strlen($list->last_update->email)-8), 2, -8)}}
                                                @endif
                                            </td>
                                            @if(permission('request_premium','update') || permission('request_premium','delete'))
                                            <td>
                                                @if(permission('request_premium','update'))
                                                    <button class="btn btn-sm bg-gradient-dark" onclick="changeStatus('{{$list->id}}')" ><i class="feather icon-refresh-cw"></i>  Status</button>
                                                @endif
                                                <!-- @if(permission('request_premium','delete'))
                                                    <a href="{{route('app-users-delete',['id'=>$list->id])}}" title="Delete Account " onclick="return confirm('Are you sure? Delete User')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                @endif -->
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td @if(permission('request_premium','update') || permission('request_premium','delete')) colspan="6" @else colspan="6" @endif class="text-center">No Requests</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $listinga->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

 
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>
    <script>

        function changeStatus(myid){
            Swal.fire({
            title: "Change Status",
            input: "select",
            inputOptions: {
                draft: "Draft",
                call_pending: "Call Pending",
                payment_pending: "Payment Pending",
                plan_activated: "Plan Activated",
            },
            inputPlaceholder: "Select a status",
            showCancelButton: true,
            confirmButtonText: "Save",
            showLoaderOnConfirm: true,
            preConfirm: async (login) => {
                try {
                    if(login==""){
                        return Swal.showValidationMessage(`Select Status`);
                    }
                    const response = await fetch('{{route("status-request-premium")}}',{
                        headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                        },
                        method: "POST",
                        body: JSON.stringify({id:myid,status:login,_token:"{{csrf_token()}}"})
                    });
                    if (!response.ok) {
                        let jsv = await response.json();
                       
                        return Swal.showValidationMessage(jsv.message);
                    } 
                    return response.json();
                } catch (error) {
                    console.log(error)
                    Swal.showValidationMessage(`
                        Request failed: ${error}
                    `);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                console.log(result)
            if (result.isConfirmed) {
                Swal.fire({
                    position: "top-end",
                    icon: "success",
                    title: "Status Updated",
                    showConfirmButton: false,
                    timer: 1500
                }).then(()=>{
                    window.location.reload();
                });
            }
            });
           
        }
       
    </script>
</body>

</html>