<!DOCTYPE html>
<html lang="en">

<head>
    <title>Form Builder Workout List</title>
    @include('includes.header')
    <script src="https://cdn.tiny.cloud/1/vzsbabl41dquoqb8uiq1co621duklluitrrj6akhlplahhqx/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
    tinymce.init({
        selector: 'textarea',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link table mergetags | align lineheight | tinycomments | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
        ai_request: (request, respondWith) => respondWith.string(() => Promise.reject("See docs to implement AI Assistant")),
    });
    </script>
</head>
<body>  
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('form_builder_guide','create')) <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add Form Builder Workouts</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Form Builder Workouts</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Form Builder Workouts</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Duration</th>
                                            <th>Desc</th>
                                            <th>Image</th>
                                            <th>Is Video Added</th>
                                            <th>Status</th>
                                            @if(permission('form_builder_guide','update') || permission('form_builder_guide','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($listing as $index=> $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{!! $list->name !!}</td>
                                            <td>{!! $list->duration !!}</td>
                                            <td>{!! mb_strimwidth($list->desc,0,15,'....') !!}</td>
                                            <td><img src="{{env('APP_URL_STR').'exercise_vid_thumb/'}}{{$list->image}}" height="70" width="70"> </td>
                                            <td>
                                                @if(!empty($list->video_path))<span class="badge bg-gradient-success">Added</span>
                                                @else <span class="badge bg-gradient-warning"> Not Added</span>@endif
                                            </td>
                                            <td>
                                                @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                @if($list->status==2)<span class="badge bg-gradient-warning">Draft</span>@endif
                                                @if($list->status==0)<span class="badge bg-gradient-danger">Inactive</span>@endif
                                            </td>
                                            @if(!permission('form_builder_guide','update') || permission('form_builder_guide','delete'))
                                            <td>
                                                @if(permission('form_builder_guide','update'))
                                                    <form style="float:left" action="{{route('status-formbuilder-workout',['id'=>$list->id])}}" method="post" onsubmit="return confirm('Change Status')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-dark mr-1"><i class="feather icon-refresh-cw"></i></button>
                                                    </form>
                                                    <button style="float:left" class="btn btn-sm bg-gradient-info pr mr-1"  data-toggle="modal" data-target="#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button>
                                                @endif
                                                @if(permission('form_builder_guide','delete'))
                                                    <form style="float:left" action="{{route('delete-formbuilder-workout',['id'=>$list->id])}}" method="post" onsubmit="return confirm('Are you sure? Delete')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-danger mr-1"><i class="feather icon-trash-2"></i></button>
                                                    </form>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5">Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $listing->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Form Builder Workout</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save-formbuilder-workout')}}" method="post" enctype='multipart/form-data'>
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name_p">Name</label>
                                <input type="text" class="form-control" name="name" id="name_p" required placeholder="Name">
                            </div>
                            <div class="form-group">
                                <label for="duration_p">Duration <em>(Add time in seconds)</em></label>
                                <input type="number" class="form-control" name="duration" id="duration_p" required placeholder="Duration">
                            </div>
                            <div class="form-group">
                                <label for="desc_p">Description</label>
                                <input type="text" class="form-control" name="desc" id="desc_p" required placeholder="Description">
                            </div>
                            <div class="form-group">
                                <label for="image_p">Image </label>
                                <input type="file" class="form-control" name="image" id="image_p" required accept="image/*" >
                            </div>
                            <div class="form-group">
                                <label for="videotype_p">Video Type</label>
                                <select type="text" class="form-control" name="videotype"  value="{{$list->video_type}}" id="videotype_p" required placeholder="Video Type">
                                    <option value="" selected disabled>Select Video Type</option>
                                    <option value="youtube" selected>Youtube</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="videourl_p">Video URL</label>
                                <input type="text" class="form-control" name="videourl"  value="{{$list->video_url}}" id="videourl_p" required placeholder="Video URL">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    @forelse($listing as $index=> $list)
    <div id="exampleModalLive{{$index}}q" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Update Form Builder Workouts</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('update-formbuilder-workout',['id'=>$list->id])}}" method="post" enctype='multipart/form-data'>
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name_p">Name</label>
                                <input type="text" class="form-control" value="{{$list->name}}" name="name" id="name_p" required placeholder="Name">
                            </div>
                            <div class="form-group">
                                <label for="duration_p">Duration <em>(Add time in seconds)</em></label>
                                <input type="number" class="form-control" value="{{$list->duration}}" name="duration" id="duration_p" required placeholder="Duration">
                            </div>
                            <div class="form-group">
                                <label for="desc_p">Description</label>
                                <input type="text" class="form-control" value="{{$list->desc}}" name="desc" id="desc_p" required placeholder="Description">
                            </div>
                            <div class="form-group">
                                <label for="image_p">Image </label><br>
                                <img src="{{env('APP_URL_STR').'exercise_vid_thumb/'}}{{$list->image}}" height="100" width="100">
                                <input type="file" class="form-control" name="image" id="image_p" accept="image/*" >
                            </div>
                            <div class="form-group">
                                <label for="videotype_p">Video Type</label>
                                <select type="text" class="form-control" name="videotype"  value="{{$list->video_type}}" id="videotype_p" required placeholder="Video Type">
                                    <option value="" selected disabled>Select Video Type</option>
                                    <option value="youtube" @if($list->video_type)selected @endif >Youtube</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="videourl_p">Video URL</label>
                                <input type="text" class="form-control" name="videourl"  value="{{$list->video_path}}" id="videourl_p" required placeholder="Video URL">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach

   
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    @foreach($listing as $index => $list )
    <script>
        $(document).on('submit','#storeUser{{$index}}q',()=>{
            var cont = tinymce.get("getHTML{{$index}}q").getContent();
            $('#getHTML{{$index}}q').html(cont);
            $('#storeUser{{$index}}q').submit();
        });
    </script>
    @endforeach
    <script>
       
       $(document).on('submit','#storeUser',()=>{
           var cont = tinymce.get("getHTML").getContent();
           $('#getHTML').html(cont);
           $('#storeUser').submit();
       });
   </script>
</body>

</html>