<!DOCTYPE html>
<html lang="en">

<head>
    <title>Workout Plans</title>
    @include('includes.header')
    <script src="{{asset('assets/js/bs/bootstrap.min.css')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.css')}}"></script> 
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <style>
        .select2-dropdown{
            z-index:99999 !important;
        }
    </style>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('workout_plans','update'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Workout Plan</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Workout Plans</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Workout Plans</h5>
                            <div class="row">
                                <div class="col-xl-5"></div>
                                <div class="col-xl-3"> </div>
                                <div class="col-xl-3">
                                    <div >User</div>
                                    <select class="form-control getUser"  id="single-select-field"  >
                                        <option value="all">All users</option>
                                        @foreach($users as $user)
                                        <option value="{{$user->id}}">{{$user->name}} - {{$user->email}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-xl-1">
                                    <button class="mt-4 p-2 btn bg-gradient-dark" id="reloadData"><i class="fa fa-refresh"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                            <table id="getUserData" class="table table-striped" style="width:100%">
                            </table>
                              
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    <script src="{{asset('assets/js/bs/dataTables.js')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.js')}}"></script>


<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Workout Plans</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save_workout_plans')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                           
                            <div class="form-group">
                                <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="Title" name="title" required>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="image" required>
                            </div>
                            <div class="form-group">
                                <label for="videotype">Video Type <span class="text-danger">*</span></label>
                                <select class="form-control" id="videotype" name="videotype" required>
                                    <option value="" selected disabled>Select Video Type</option>
                                    <option value="youtube">Youtube</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="videourl">Video URL <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="videourl" id="videourl" required placeholder="Enter url">
                            </div>
                            <div class="form-group">
                                <label for="myname">Is Paid <span class="text-danger">*</span></label>
                                <div class="form-group">
                                    <span style="padding: 0px 25px">
                                        <input type="radio" name="ispaid" id="ispaidyes" value="yes" required >
                                        <label for="ispaidyes">Yes</label>
                                    </span>
                                    <span  style="padding: 0px 25px">
                                        <input type="radio" name="ispaid" id="ispaidno" value="no" checked required >
                                        <label for="ispaidno">No</label>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="myname">Is User Spacific <span class="text-danger">*</span></label>
                                <div class="form-group">
                                    <span style="padding: 0px 25px">
                                        <input type="radio" name="is_user_selected" value="yes" id="is_user_selectedyes" required >
                                        <label for="is_user_selectedyes">Yes</label>
                                    </span>
                                    <span  style="padding: 0px 25px">
                                        <input type="radio" name="is_user_selected" value="no" id="is_user_selectedno" checked required >
                                        <label for="is_user_selectedno">No</label>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group allUserSelect" style="display:none">
                                <label for="myname">User <span class="text-danger">*</span></label>
                                <select  name="alluser" class="form-control selectpicker w-100" data-live-search="true" id="single-select-field1" >
                                    <option value="" selected disabled>Select User</option>
                                    @foreach($users as $list)
                                    <option value="{{$list->id}}">{{$list->name}} - {{$list->email}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group paidUserSelect" style="display:none">
                                <label for="myname">User <span class="text-danger">*</span></label>
                                <select name="paiduser" class="form-control selectpicker w-100" data-live-search="true" id="single-select-field2" >
                                    <option value="" selected disabled>Select Paid User</option>
                                    @foreach($paid_users as $list)
                                    <option value="{{$list->id}}">{{$list->name}} - {{$list->email}}</option>
                                    @endforeach
                                </select>
                            </div>


                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    <div id="exampleModalLiveclone" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLivecloneLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLivecloneLabel">Clone Workout</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body ">
                <form action="{{route('clone_workout_plans')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        @method('PUT')
                        <div class="col-md-12">
                            <div class="row">
                                <div class="form-group col-6">
                                    <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control cloneTitle"  placeholder="Title" name="title" required>
                                    <input type="hidden" class="form-control cloneUUID"  name="uuid" >
                                </div>

                                <div class="form-group col-6">
                                    <label for="videotype">Video Type <span class="text-danger">*</span></label>
                                    <select class="form-control" id="videotype" name="videotype" required>
                                        <option value="" selected disabled>Select Video Type</option>
                                        <option value="youtube" >Youtube</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-6">
                                    <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" name="image" >
                                    <br>
                                    <img src="{{env('APP_URL_STR').'workout/'}}" class="cloneImage" height="70" width="70">
                                </div>
                                <div class="form-group col-6">
                                    <label for="videourl">Video URL <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="videourl" value="" id="cloneVideourl" required placeholder="Enter url">
                                    <iframe width="300" height="160" class="cloneVideourl"
                                        src="https://www.youtube.com/embed/">
                                    </iframe>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <label for="myname">Is Paid <span class="text-danger">*</span></label>
                                    <div class="form-group">
                                        <span style="padding: 0px 25px">
                                            <input type="radio" name="ispaid1" id="cloneispaid1yes" value="yes" required >
                                            <label for="ispaid1yes">Yes</label>
                                        </span>
                                        <span  style="padding: 0px 25px">
                                            <input type="radio" name="ispaid1" id="cloneispaid1no" value="no" checked required >
                                            <label for="ispaid1no">No</label>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="myname">Is User Spacific <span class="text-danger">*</span></label>
                                    <div class="form-group">
                                        <span style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selected1" value="yes" id="is_user_selected1yes" required >
                                            <label for="is_user_selected1yes">Yes</label>
                                        </span>
                                        <span  style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selected1" value="no" id="is_user_selected1no" checked required >
                                            <label for="is_user_selected1no">No</label>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group allUserSelect" style="display:none">
                                <label for="myname">User <span class="text-danger">*</span></label>
                                <select name="alluser" class="form-control selectpicker w-100" id="single-select-field3" data-live-search="true" >
                                    <option value="" selected disabled>Select User</option>
                                    @foreach($users as $list)
                                    <option value="{{$list->id}}">{{$list->name}} - {{$list->email}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group paidUserSelect" style="display:none">
                                <label for="myname">User <span class="text-danger">*</span></label>
                                <select  name="paiduser" class="form-control selectpicker w-100" id="single-select-field4" data-live-search="true" >
                                    <option value="" selected disabled>Select Paid User</option>
                                    @foreach($paid_users as $list)
                                    <option value="{{$list->id}}">{{$list->name}} - {{$list->email}}</option>
                                    @endforeach
                                </select>
                            </div>


                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-success">Clone Workout</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    <div id="exampleModalLiveq" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLivecloneLabelq" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLivecloneLabelq">Edit Workout</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body ">
                <form action="{{route('edit-workout_plans')}}" id="editW" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        @method('PUT')
                        <div class="col-md-12">
                            <div class="row">
                                <div class="form-group col-12">
                                    <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control editTitle"  placeholder="Title" name="title" required>
                                    <input type="hidden" class="form-control editUUID"  name="uuid" >
                                </div>

                                <div class="form-group col-6">
                                    <label for="videotype">Video Type <span class="text-danger">*</span></label>
                                    <select class="form-control" id="editVideotype" name="videotype" required>
                                        <option value="" selected disabled>Select Video Type</option>
                                        <option value="youtube" >Youtube</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" name="image" >
                                    <br>
                                    <img src="{{env('APP_URL_STR').'workout/'}}" class="editImage" height="70" width="70">
                                </div>
                                <div class="form-group col-6">
                                    <label for="videourl">Video URL <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="videourl" value="" id="editVideourl" required placeholder="Enter url">
                                    <iframe width="300" height="160" class="editVideourl"
                                        src="https://www.youtube.com/embed/">
                                    </iframe>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <label for="myname">Is Paid <span class="text-danger">*</span></label>
                                    <div class="form-group">
                                        <span style="padding: 0px 25px">
                                            <input type="radio" name="ispaid1" id="ispaid1yes" value="yes" required >
                                            <label for="ispaid1yes">Yes</label>
                                        </span>
                                        <span  style="padding: 0px 25px">
                                            <input type="radio" name="ispaid1" id="ispaid1no" value="no" checked required >
                                            <label for="ispaid1no">No</label>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="myname">Is User Spacific <span class="text-danger">*</span></label>
                                    <div class="form-group">
                                        <span style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selectededit" value="yes" id="editis_user_selected1yes" required >
                                            <label for="is_user_selected1yes">Yes</label>
                                        </span>
                                        <span  style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selectededit" value="no" id="editis_user_selected1no" checked required >
                                            <label for="is_user_selected1no">No</label>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group allUserSelectEdit" style="display:none">
                                <label for="myname">User <span class="text-danger">*</span></label>
                                <select id="allUserEdit" name="alluser" class="form-control selectpicker" data-live-search="true" >
                                    <option value="" selected disabled>Select User</option>
                                    @foreach($users as $list)
                                    <option value="{{$list->id}}">{{$list->name}} - {{$list->email}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group paidUserSelectEdit" style="display:none">
                                <label for="myname">User <span class="text-danger">*</span></label>
                                <select id="paidUser" name="paiduser" class="form-control selectpicker" data-live-search="true" >
                                    <option value="" selected disabled>Select Paid User</option>
                                    @foreach($paid_users as $list)
                                    <option value="{{$list->id}}">{{$list->name}} - {{$list->email}}</option>
                                    @endforeach
                                </select>
                            </div>


                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info">Update</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(document).on('click','#reloadData',(res)=>{
            getData();
        });

        function getData(){
            $(document).ready(()=>{
                $('#getUserData').DataTable( {
                    "ajax": {
                        "url": "{{route('get-wrokoutplans-datatable')}}",
                        "data": function ( d ) {
                                d.selectedUser=$('.getUser').val();
                            },
                            "dataSrc": function ( json ) {
                                return json.data;
                            }
                    },
                    order: [[0, 'desc']],
                    fixedHeader: true,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    columns: [
                        { data: 'id',title:"#" },
                        { data: 'user',title:"User",orderable:false,"render":function(data,type,row){
                            if(data=="" || data==null){
                                return `Available All Users`;
                            } else {
                                return data.name+"<br>"+data.email;
                            }
                            
                            }},
                        { data: 'title',title:"Title" },
                        { data: 'image',orderable:false,title:"Image" ,
                            "render":function(data,type,row){
                            return `<img src="{{env('APP_URL_STR').'workout/'}}`+data+`" height="70" width="70">`;
                            }
                        },
                        { data: 'video_url',title:"Video",
                            "render":function(data,type,row){
                                if(data==""){
                                    return `<span class="badge bg-gradient-danger">Not Added</span>`;
                                } else{
                                    return `<span class="badge bg-gradient-success">Added</span>`;
                                }
                            }
                        },
                        { data: 'is_paid',title:"Is PAID",
                            "render":function(data,type,row){
                                if(data==""){
                                    return `<span class="badge bg-gradient-danger">No</span>`;
                                } else {
                                    return `<span class="badge bg-gradient-success">Yes</span>`;
                                }
                                
                            }
                        },
                        { data: 'status',title:"Status",
                            "render":function(data,type,row){
                                if(data==1){
                                    return `<span class="badge bg-gradient-success">Active</span>`;
                                } else if(data==0){
                                    return `<span class="badge bg-gradient-danger">Inactive</span>`;
                                } else if(data==2){
                                    return `<span class="badge bg-gradient-warning">Draft</span>`;
                                }
                            }
                        },
                        { data: 'id',title:"Action",orderable:false,
                            "render":function(data,type,row){
                                var statusUrl = "{{ route('status-workout_plans', ['id' => ':id']) }}";
                                    statusUrl = statusUrl.replace(':id', data);
                                    var deletePlanURL = "{{ route('delete-workout_plans', ['id' => ':id']) }}";
                                    deletePlanURL = deletePlanURL.replace(':id', data);
                                    // var userDeleteURL = "{{ route('app-users-delete', ['id' => ':id']) }}";
                                    // userDeleteURL = userDeleteURL.replace(':id', data);
                                    var listPage = "{{ route('manage-workout_plans', ['id' => ':id']) }}";
                                    listPage = listPage.replace(':id', btoa(data));
                                    return ` @if(permission('workout_plans','update') || permission('workout_plans','delete'))    
                                                @if(permission('workout_plans','update'))
                                                    <a href="`+listPage+`" target="_blank">
                                                        <button class="btn btn-sm bg-gradient-dark mr-1 cloneModel" style="float:left" title="Manage Plan" ><i class="fa fa-list" ></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-secondary mr-1 cloneModel" style="float:left" title="Clone" data-toggle="modal" data-target="#exampleModalLiveclone" data-array="`+btoa(JSON.stringify(row))+`"><i class="fa fa-clone" data-array="`+btoa(JSON.stringify(row))+`"></i></button>
                                                    <form style="float:left" action="`+statusUrl+`" method="post" onsubmit="return confirm('Change Status')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-warning mr-1"><i class="feather icon-refresh-cw"></i></button>
                                                    </form>
                                                    <button class="btn btn-sm bg-gradient-info mr-1 editModel" style="float:left"  data-toggle="modal" data-target="#exampleModalLiveq" data-array="`+btoa(JSON.stringify(row))+`"><i class="feather icon-edit" data-array="`+btoa(JSON.stringify(row))+`"></i></button> 
                                                @endif
                                                @if(permission('workout_plans','delete'))
                                                    <form style="float:left" action="`+deletePlanURL+`" method="post" onsubmit="return confirm('Are you sure? Delete')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </form>
                                                @endif
                                            
                                            @endif`;
                            
                            }
                        },
                    ],
                    language: {
                        searchPlaceholder: "By Title"
                    },
                    retrieve: true,
                }).ajax.reload();
            });
            
        }
        this.getData();
        $(document).on('click','.cloneModel',(e)=>{
            var data = JSON.parse(atob($(e.target).data('array')));
            $('.cloneTitle').val(data.title);
            $('.cloneUUID').val(data.uuid);
            $('#videotype option[value='+data.video_type+']').attr('selected','selected');
            $('.cloneImage').attr("src","{{env('APP_URL_STR').'workout/'}}"+data.image);
            $('#cloneVideourl').val(data.video_url);
            $('.cloneVideourl').attr("src","https://www.youtube.com/embed/"+data.video_url);
        });
        $(document).on('click','.editModel',(e)=>{
            var data = JSON.parse(atob($(e.target).data('array')));
          
            $('.editTitle').val(data.title);
            $('.editUUID').val(data.uuid);
            $('#editVideotype option[value='+data.video_type+']').attr('selected','selected');
  
            $('.editImage').attr("src","{{env('APP_URL_STR').'workout/'}}"+data.image);
            $('#editVideourl').val(data.video_url);

            $('.editVideourl').attr("src","https://www.youtube.com/embed/"+data.video_url);
            if(data.is_paid==1){
                $('#ispaid1yes').attr("checked","true");
                $('#ispaid1no').removeAttr("checked");
            } else {
                $('#ispaid1no').attr("checked","true");
                $('#ispaid1yes').removeAttr("checked");
            }
            if(data.user_id!=null){
                $('#editis_user_selected1yes').prop("checked","true");
                $('#editis_user_selected1no').removeAttr("checked");
                $('select[name="alluser"]').find('option[value="'+data.user_id+'"]').attr("selected",true);
                var type = $('input[name=ispaid]:checked').val();
                var is_user_selected = $('input[name=is_user_selectededit]:checked').val();
                if(is_user_selected=='yes'){
                    if(type=="yes"){
                        $('.allUserSelectEdit').hide();
                        $('.paidUserSelectEdit').show();
                    }
                    if(type=="no"){
                        $('.allUserSelectEdit').show();
                        $('.paidUserSelectEdit').hide();
                    }
                } else {
                    $('.allUserSelectEdit').hide();
                    $('.paidUserSelectEdit').hide();
                }
            } else {
                $('.allUserSelectEdit').hide();
                $('.paidUserSelectEdit').hide();
                $('#editis_user_selected1yes').removeAttr("checked");
                $('#editis_user_selected1no').prop("checked","true");
                
            }
            
        });

        $(document).on('change','input[name=is_user_selectededit]',(res)=>{
            var type = $('input[name=ispaid]:checked').val();
            var is_user_selected = $('input[name=is_user_selectededit]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelectEdit').hide();
                    $('.paidUserSelectEdit').show();
                }
                if(type=="no"){
                    $('.allUserSelectEdit').show();
                    $('.paidUserSelectEdit').hide();
                }
            } else {
                $('.allUserSelectEdit').hide();
                $('.paidUserSelectEdit').hide();
            }
           
        });

        $(document).on('change','input[name=ispaid]',(res)=>{
            var type = $('input[name=ispaid]:checked').val();
            var is_user_selected = $('input[name=is_user_selected]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });
        $(document).on('change','input[name=is_user_selected]',(res)=>{
            var type = $('input[name=ispaid]:checked').val();
            var is_user_selected = $('input[name=is_user_selected]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });
        $(document).on('change','input[name=ispaid1]',(res)=>{
            var type = $('input[name=ispaid1]:checked').val();
            var is_user_selected = $('input[name=is_user_selected1]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });
        $(document).on('change','input[name=is_user_selected1]',(res)=>{
            var type = $('input[name=ispaid1]:checked').val();
            var is_user_selected = $('input[name=is_user_selected1]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });
  
      
    </script>

    <script>
         $( '#single-select-field' ).select2({
                width: "100%",
                placeholder: $( this ).data( 'placeholder' ),
            } );
            $( '#single-select-field1' ).select2({
                width: "100%",
                placeholder: $( this ).data( 'placeholder' ),
            } );
            $( '#single-select-field2' ).select2({
                width: "100%",
                placeholder: $( this ).data( 'placeholder' ),
            } );
            $( '#single-select-field3' ).select2({
                width: "100%",
                placeholder: $( this ).data( 'placeholder' ),
            } );
            $( '#single-select-field4' ).select2({
                width: "100%",
                placeholder: $( this ).data( 'placeholder' ),
            } );
    </script>
</body>

</html>