<!DOCTYPE html>
<html lang="en">

<head>
    <title>Master Settings</title>
    @include('includes.header')
    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
    <style>
        .pcoded-content {
            position: relative;
            display: block;
            padding: 25px 10px 20px 48px;
        }
        .checkbox label .toggle, .checkbox-inline .toggle {
            margin-left: 0 !important;
            margin-right: .35rem;
        }
    </style>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')


    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="page-header-title">
                                <h5 class="m-b-10">Master Settings</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
            <!-- [ Main Content ] start -->
            <form action="{{route('settings')}}" method="post" >
                @csrf
                <div class="row">
                    @foreach($master as $field)
                        <div class="col-md-6 col-sm-12 col-xl-6">
                            @php $title = ucwords(str_replace('_',' ',$field->name)) @endphp
                            @if($field->type=="bool")
                            <div class="checkbox">
                                <br>{{$title}}
                                <label> 
                                    <input name="{{$field->id}}" type="checkbox" @if($field->value)checked @endif  data-toggle="toggle">
                                </label>
                            </div>
                            @elseif($field->type=="text")
                            <div>
                                <label> {{$title}}</label>
                                <input type="text" name="{{$field->id}}" value="{{$field->value}}" class="form-control" placeholder="{{$title}}">
                            </div>
                            @elseif($field->type=="number")
                            <div>
                                <label> {{$title}}</label>
                                <input type="number" name="{{$field->id}}" value="{{$field->value}}" class="form-control" placeholder="{{$title}}">
                            </div>
                            @endif
                        </div>
                    @endforeach
                </div>
                <button class="btn bg-gradient-success mt-3" >Save</button>
            </form>
            <!-- [ Main Content ] end -->
        </div>
    </div>
    @include('includes.footer')
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
</body>

</html>