<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\MainController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\MasterSettingController;
use App\Jobs\WeeklyAlert;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('/login');
})->name('login');

// Route::get('/kulwinder',[LoginController::class,'showEntriesForm'])->name('entry_view');
// Route::post('/kulwinder',[LoginController::class,'createEntriesForm'])->name('entry_create');
// // Route::get('/kulwinder/{uuid}/regenerate',[LoginController::class,'entriesReload'])->name('entry_regenerate');
// Route::get('/kulwinder/{uuid}',[LoginController::class,'entries'])->name('view_entries');
// Route::get('/kulwinder/{uuid}/export/{type}',[LoginController::class,'exportEntries'])->name('export_entries');
Route::get('/test', function () {
    WeeklyAlert::dispatch();
})->name('test');


Route::get('/login', [LoginController::class, 'login'])->name('get.login');

Route::post('/login', [LoginController::class, 'doLogin'])->name('post.login');
Route::get('/logout', [LoginController::class, 'logout'])->name('logout');

Route::name('razorpay.')
    ->controller(PaymentController::class)
    ->prefix('razorpay')
    ->group(function () {
        Route::view('payment', 'test-payment')->name('create.payment');
        Route::post('handle-payment', 'handlePayment')->name('make.payment');
    });

Route::get('/email_verify/{email}', [LoginController::class, 'emailVerify'])->name('email_verify');

Route::group(['middleware' => ['auth']], function () {

    //Send Notification 
    Route::put('send-notification', [MainController::class, 'sendNotification'])->name('send-notification');
    //Admin Dashboard 
    Route::get('/dashboard', [LoginController::class, 'dashboard'])->name('dashboard');
    //Admin Users
    Route::get('/users', [MainController::class, 'adminUsersView'])->name('admin-users');
    Route::post('/users', [MainController::class, 'storeNewAdminUser'])->name('store-admin-user');
    Route::post('/update-users', [MainController::class, 'updateNewAdminUser'])->name('update-admin-user');
    Route::get('/users/{id}', [MainController::class, 'usersDisable'])->name('users-disable');
    Route::get('/users/{id}/_d', [MainController::class, 'usersDelete'])->name('users-delete');
    Route::post('/users/password', [MainController::class, 'usersPassword'])->name('users-password');
    Route::get('/users/{id}/assigned-users', [MainController::class, 'assignedUsers'])->name('assigned-users');
    Route::post('/users/{id}/add-assigned-users', [MainController::class, 'addAssignedUsers'])->name('add-assigned-users');
    Route::get('/users/{id}/unassign-users', [MainController::class, 'unassignUsers'])->name('unassign-users');

    //Auth Routes
    Route::get('/roles', [MainController::class, 'adminRoles'])->name('admin-roles');
    Route::get('/role/create', [MainController::class, 'createRole'])->name('create-role');
    Route::post('/role/create', [MainController::class, 'saveRole'])->name('save-role');
    Route::get('/roles-edit/{id}', [MainController::class, 'editRole'])->name('roles-edit');
    Route::post('/roles-edit/{id}', [MainController::class, 'updateRole'])->name('update-role');
    Route::get('/role-disable', [MainController::class, 'adminRoleDisable'])->name('roles-disable');
    Route::get('/role-disable-delete/{id}', [MainController::class, 'adminRoleDelete'])->name('app-role-delete');

    //App Users
    Route::get('/app-users', [MainController::class, 'appUsersView'])->name('app-users');
    Route::post('/app-users', [MainController::class, 'storeAppAdminUser'])->name('store-app-user');
    Route::get('/app-users/{id}', [MainController::class, 'appUsersDisable'])->name('app-users-disable');
    Route::get('/app-users/{id}/_d', [MainController::class, 'appUsersDelete'])->name('app-users-delete');
    Route::get('/app-users/{id}/sts', [MainController::class, 'appUsersSts'])->name('app-users-sts');

    Route::get('/app-users/{id}/diet-plan', [MainController::class, 'userDietPlan'])->name('user_diet_plan');
    Route::put('/app-users/{id}/diet-plan', [MainController::class, 'updateDietPlan'])->name('update-diet-plan');

    //View Plans
    Route::get('/plans', [MainController::class, 'appPlansView'])->name('app-plans');
    Route::get('/plans/{id}', [MainController::class, 'appPlansDisable'])->name('app-plans-disable');
    Route::post('/plans/{id}', [MainController::class, 'appPlansUpdate'])->name('app-plans-update');

    //Dashboard Sliders
    Route::get('/app-slides', [MainController::class, 'appSlidesView'])->name('app-slides');
    Route::post('/app-slides', [MainController::class, 'saveSliderImage'])->name('save-slide');
    Route::get('/app-slides/{id}/s_', [MainController::class, 'statusAppSlides'])->name('status-app-slides');
    Route::get('/app-slides/{id}/d_', [MainController::class, 'deleteAppSlides'])->name('delete-app-slides');
    Route::post('/app-slides/{id}/u_', [MainController::class, 'updateAppSlides'])->name('update-slide');

    //Application Languages
    Route::get('/app-languages', [MainController::class, 'appLanguagesView'])->name('app-languages');
    Route::get('/app-languages/{id}/s_', [MainController::class, 'statusAppLanguage'])->name('status-app-languages');
    Route::post('/app-languages/{id}/u_', [MainController::class, 'updateAppLanguage'])->name('update-app-languages');
    Route::post('/app-languages', [MainController::class, 'storeAppLanguage'])->name('store-app-languages');

    Route::get('/edit-app-languages/{id}', [MainController::class, 'editAppLanguagesView'])->name('edit-app-languages');

    //Manage Exercise Related
    Route::get('/exercise-categories', [MainController::class, 'exerciseCategories'])->name('exercise-categories');
    Route::post('/exercise-categories', [MainController::class, 'saveExerciseCategory'])->name('save-exercise-categories');
    Route::get('/exercise-categories/{id}/d_', [MainController::class, 'deleteExerciseCategory'])->name('delete-exercise-categories');
    Route::get('/exercise-categories/{id}/s_', [MainController::class, 'statusExerciseCategory'])->name('status-exercise-categories');
    Route::post('/exercise-categories/{id}/u_', [MainController::class, 'updateExerciseCategory'])->name('update-exercise-categories');

    Route::get('/exercise-videos', [MainController::class, 'exerciseVideos'])->name('exercise-videos');
    Route::post('/exercise-videos', [MainController::class, 'saveExerciseVideos'])->name('save-exercise-videos');
    Route::get('/exercise-videos/{id}/s_', [MainController::class, 'statusExerciseVideos'])->name('status-exercise-videos');
    Route::get('/exercise-videos/{id}/d_', [MainController::class, 'deleteExerciseVideos'])->name('delete-exercise-videos');
    Route::post('/exercise-videos/{id}/u_', [MainController::class, 'updateExerciseVideos'])->name('update-exercise-videos');

    //Requests
    Route::get('/consultation-requests', [MainController::class, 'consultationRequests'])->name('consultation-request');
    Route::get('/consultation-requests/changestatus/{status}/{uid}', [MainController::class, 'consultationRequestsChangeStatus'])->name('consultation-request-status');
    Route::get('/call-requests', [MainController::class, 'callRequests'])->name('call-request');
    Route::get('/call-requests/changestatus/{status}/{uid}', [MainController::class, 'callRequestsChangeStatus'])->name('call-request-status');

    //Manage Meal uploaded data
    Route::get('/meal-pictures', [MainController::class, 'mealPictures'])->name('meal-picture');
    Route::get('/meal-pictures/changestatus/{status}/{uid}', [MainController::class, 'mealPicturesChangeStatus'])->name('meal-picture-status');
    Route::get('/meal-pictures/{status}/{uid}', [MainController::class, 'mealPicturesApprove'])->name('meal-picture-approve');

    //Manage Weekly Form
    Route::get('/weekly-updates', [MainController::class, 'weeklyUpdates'])->name('weekly-update');
    Route::get('/weekly-updates/changestatus/{status}/{uid}', [MainController::class, 'weeklyUpdatesChangeStatus'])->name('weekly-update-status');

    //Manage Help & Support
    Route::get('/help-queries', [MainController::class, 'helpQueries'])->name('help-queries');
    Route::get('/help-queries/changestatus/{status}/{uid}', [MainController::class, 'helpQueriesChangeStatus'])->name('help-query-status');

    Route::get('/contact-info', [MainController::class, 'contactInfo'])->name('contact-info');
    Route::post('/contact-info', [MainController::class, 'storeContactInfo'])->name('store-contact-info');
    Route::get('/contact-info/{id}/d_', [MainController::class, 'deleteContactInfo'])->name('delete-contact-info');
    Route::get('/contact-info/{id}/s_', [MainController::class, 'statusContactInfo'])->name('status-contact-info');
    Route::post('/contact-info/{id}/u_', [MainController::class, 'updateContactInfo'])->name('update-contact-info');

    Route::get('/fetch_health_data', [MainController::class, 'fetch_health_data'])->name('fetch_health_data');

    Route::get('/get_health_data', [MainController::class, 'getHealthData'])->name('get_health_data');

    //Manage Workout Related 
    Route::get('/workout-plans', [MainController::class, 'workoutPlans'])->name('workout_plans');
    Route::post('/workout-plans', [MainController::class, 'saveWorkoutPlans'])->name('save_workout_plans');
    Route::put('/workout-plans', [MainController::class, 'cloneWorkoutPlans'])->name('clone_workout_plans');
    Route::put('/workout-plans/status/{id}', [MainController::class, 'statusWorkoutPlans'])->name('status-workout_plans');
    Route::put('/workout-plans/edit/uuid', [MainController::class, 'editWorkoutPlans'])->name('edit-workout_plans');
    Route::put('/workout-plans/{id}', [MainController::class, 'deleteWorkoutPlans'])->name('delete-workout_plans');
    Route::get('/workout-plans/{id}', [MainController::class, 'manageWorkoutPlans'])->name('manage-workout_plans');
    // get_exercise_details
    Route::post('/workout-plans/get/days', [MainController::class, 'getWorkoutPlanDay'])->name('get_exercise_details');
    Route::post('/workout-plans/import/days', [MainController::class, 'importWorkoutPlanDay'])->name('import_exercise_details');
    // view_workout_plan_days
    Route::get('/workout-plan/days/{id}', [MainController::class, 'workoutPlansDayView'])->name('view_workout_plan_days');

    Route::get('/exercise-machines', [MainController::class, 'exerciseMachines'])->name('exercise_machines');
    Route::post('/exercise-machines', [MainController::class, 'saveExerciseMachine'])->name('save-exercise-machine');
    Route::get('/exercise-machines-delete/{id}', [MainController::class, 'deleteExerciseMachine'])->name('delete-exercise-machine');
    Route::get('/exercise-machines-data', [MainController::class, 'exerciseMachineDatatable'])->name('exercise_machines_data');

    // Route::get('/exercise-categories/{id}/d_', [MainController::class,'deleteExerciseCategory'])->name('delete-exercise-categories');
    // Route::get('/exercise-categories/{id}/s_', [MainController::class,'statusExerciseCategory'])->name('status-exercise-categories');
    // Route::post('/exercise-categories/{id}/u_', [MainController::class,'updateExerciseCategory'])->name('update-exercise-categories');

    Route::get('/workout-plan-days', [MainController::class, 'workoutPlansDays'])->name('workout_plan_days');
    Route::post('/workout-plan-days', [MainController::class, 'saveWorkoutPlansDays'])->name('save_workout_plan_days');
    Route::post('/update-workout-plan-days', [MainController::class, 'updateWorkoutPlansDays'])->name('update_workout_plan_days');

    Route::put('/workout-plan-days/status/{id}', [MainController::class, 'statusWorkoutPlansDays'])->name('status-workout_plan_days');
    Route::put('/workout-plan-days/{id}', [MainController::class, 'deleteWorkoutPlansDays'])->name('delete-workout_plan_days');

    Route::get('/workout-days', [MainController::class, 'workoutDays'])->name('workout_days');
    Route::post('/workout-days', [MainController::class, 'saveWorkoutDays'])->name('save_workout_days');
    Route::put('/workout-days/status/{id}', [MainController::class, 'statusWorkoutDays'])->name('status-workout_days');
    Route::put('/workout-days/{id}', [MainController::class, 'deleteWorkoutDays'])->name('delete-workout_days');

    Route::get('/recipe-list', [MainController::class, 'recipeList'])->name('recipe-list');
    Route::post('/recipe-list', [MainController::class, 'recipeStore'])->name('store-recipe-list');
    Route::put('/recipe-list', [MainController::class, 'recipeRemove'])->name('delete-recipe-list');

    Route::get('/recipe-guide-list', [MainController::class, 'recipeGuideList'])->name('recipe-guide-list');
    Route::post('/recipe-guide-list', [MainController::class, 'saveRecipeGuide'])->name('save-recipe-guide');
    Route::get('/recipe-guide-list-status/{id}', [MainController::class, 'recipeGuideStatus'])->name('status-recipe-guide');
    Route::get('/recipe-guide-list-delete/{id}', [MainController::class, 'deleteRecipeGuide'])->name('delete-recipe-guide');
    Route::post('/recipe-guide-list-update/{id}', [MainController::class, 'updateRecipeGuide'])->name('update-recipe-guide');

    Route::get('/recipe-category-list', [MainController::class, 'recipeCategoryList'])->name('recipe-category-list');
    Route::post('/recipe-category-list', [MainController::class, 'saveRecipeCategory'])->name('save-recipe-category');
    Route::get('/recipe-category-list-status/{id}', [MainController::class, 'recipeCategoryStatus'])->name('status-recipe-category');
    Route::get('/recipe-category-list-delete/{id}', [MainController::class, 'deleteRecipeCategory'])->name('delete-recipe-category');
    Route::post('/recipe-category-list-update/{id}', [MainController::class, 'updateRecipeCategory'])->name('update-recipe-category');

    Route::get('/meditation-category-list', [MainController::class, 'meditationCategoryList'])->name('meditation-category-list');
    Route::post('/meditation-category-list', [MainController::class, 'saveMeditationCategory'])->name('save-meditation-category');
    Route::get('/meditation-category-list-status/{id}', [MainController::class, 'meditationCategoryStatus'])->name('status-meditation-category');
    Route::get('/meditation-category-list-delete/{id}', [MainController::class, 'deleteMeditationCategory'])->name('delete-meditation-category');
    Route::post('/meditation-category-list-update/{id}', [MainController::class, 'updateMeditationCategory'])->name('update-meditation-category');

    // recipe-ingredients
    Route::get('/recipe-ingredients', [MainController::class, 'recipeIngredients'])->name('recipe-ingredients');
    Route::get('/recipe-ingredients-datatable', [MainController::class, 'recipeIngredientsDatatable'])->name('recipe-ingredients-datatable');
    Route::post('/recipe-ingredients', [MainController::class, 'recipeIngredientsStore'])->name('store-recipe-ingredients');
    Route::post('/recipe-ingredients/remove', [MainController::class, 'recipeIngredientsRemove'])->name('delete-recipe-ingredients');

    // mediation
    Route::get('/meditation', [MainController::class, 'mediationList'])->name('mediation');
    Route::post('/meditation', [MainController::class, 'saveMediation'])->name('save-meditation');
    Route::get('/meditation-status/{id}', [MainController::class, 'meditationStatus'])->name('status-meditation');
    Route::get('/meditation-delete/{id}', [MainController::class, 'deleteMeditation'])->name('delete-meditation');
    Route::post('/meditation-update/{id}', [MainController::class, 'updateMeditation'])->name('update-meditation');

    // mediation deepsleep
    Route::get('/mediation-deepsleep', [MainController::class, 'mediationDeepSleepList'])->name('meditation-deepsleep');
    Route::post('/mediation-deepsleep', [MainController::class, 'saveDeepSleepMediation'])->name('save-deepsleep-meditation');
    Route::get('/mediation-deepsleep-status/{id}', [MainController::class, 'meditationDeepSleepStatus'])->name('status-deepsleep-meditation');
    Route::get('/mediation-deepsleep-delete/{id}', [MainController::class, 'deleteDeepSleepMeditation'])->name('delete-deepsleep-meditation');
    Route::post('/mediation-deepsleep-update/{id}', [MainController::class, 'updateDeepSleepMeditation'])->name('update-deepsleep-meditation');

    Route::get('/form-builder-guide', [MainController::class, 'formBuilderGuide'])->name('form-builder-guide');
    Route::post('/form-builder-guide', [MainController::class, 'saveFormBuilderGuide'])->name('save-formbuilder-workout');
    Route::put('/form-builder-guide-status/status/{id}', [MainController::class, 'statusFormBuilderGuide'])->name('status-formbuilder-workout');
    Route::post('/form-builder-guide/update/{id}', [MainController::class, 'updateFormBuilderGuide'])->name('update-formbuilder-workout');
    Route::put('/form-builder-guide-status/{id}', [MainController::class, 'deleteFormBuilderGuide'])->name('delete-formbuilder-workout');

    //request-premium
    Route::get('/request-premium', [MainController::class, 'requestPremium'])->name('request-premium');
    Route::post('/request-premium', [MainController::class, 'statusRequestPremium'])->name('status-request-premium');
    Route::put('/change-user-plan', [MainController::class, 'changeToPremium'])->name('change-user-plan');

    //Chat
    Route::put('/get-user-chat', [MainController::class, 'getUserChat'])->name('get-user-chat');
    Route::put('/send-user-chat', [MainController::class, 'sendUserChat'])->name('send-user-chat');


    //Chat Interface 
    Route::get('/chat-dashboard', [MainController::class, 'chatDashboard'])->name('chat-dashboard');
    Route::get('/chat-details/{user}', [MainController::class, 'chatDashboardSingleChat'])->name('chat-details');

    //Broadcast
    Route::post('/chat-broadcast/create', [MainController::class, 'chatBroadCastCreate'])->name('chat-broadcast-create');
    Route::post('/chat-broadcast/update', [MainController::class, 'chatBroadCastUpdate'])->name('chat-broadcast-update');
    Route::get('/chat-broadcast-details/{key}', [MainController::class, 'chatBroadCastDetails'])->name('chat-broadcast-details');
    Route::put('/get-broadcast-chat', [MainController::class, 'getBroadCastChat'])->name('get-broadcast-chat');
    Route::put('/send-broadcast-chat', [MainController::class, 'sentBroadCastChat'])->name('send-broadcast-chat');

    //BMR
    Route::get('/save-user-bmr', [MainController::class, 'saveUserBMR'])->name('save-user-bmr');
    Route::get('/save-user-weight', [MainController::class, 'updateWeight'])->name('save-user-weight');

    //updates
    Route::get('/save-user-updates', [MainController::class, 'saveUpdates'])->name('save-user-updates');
    Route::get('/get-calories-info', [MainController::class, 'getCaloriesInfo'])->name('get-calories-info');

    //Master Settings
    Route::get('/settings', [MasterSettingController::class, 'getSettings'])->name('settings');
    Route::post('/settings', [MasterSettingController::class, 'saveSettings'])->name('settings');

    //Datatable
    Route::get('/get-app-user-datatable', [MainController::class, 'appUserDatatable'])->name('get-app-user-datatable');
    Route::get('/get-weekly-datatable', [MainController::class, 'weeklyUpdateDatatable'])->name('get-weekly-datatable');
    Route::get('/get-mealpick-datatable', [MainController::class, 'mealPictureDatatable'])->name('get-mealpick-datatable');
    Route::get('/get-wrokoutplans-datatable', [MainController::class, 'wrokoutPlansDatatable'])->name('get-wrokoutplans-datatable');
    Route::get('/get-wrokoutplansday-datatable', [MainController::class, 'wrokoutPlansDayDatatable'])->name('get-wrokoutplansday-datatable');
});

Route::get('/connect-google-account', [MainController::class, 'connect'])->name('connect_health_data');
Route::get('/temp-google-account', [MainController::class, 'connectGoogleTempAuth'])->name('temp_health_data');

//http://localhost/dev_vismaad/fitness-junction/webview/form-builder-guide/upload?tempid=TVRBPQ==&temptoken=TVRBPQ==
Route::get('/webview/form-builder-guide/upload', [LoginController::class, 'renderFormBuilderGuideVideo']);
Route::post('/webview/form-builder-guide/upload', [LoginController::class, 'uploadFormBuilderGuideVideo'])->name('save-form-builder-video');
Route::get('/webview/form-builder-guide/success', function () {
    return view('public.success');
})->name('success-form-builder-video');

