<!DOCTYPE html>
<html lang="en">

<head>
    <title>Admin Roles</title>
    <?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
<?php echo $__env->make('includes.flash-sms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            <?php if(permission('admin_roles','create')): ?>
                                <a href="<?php echo e(route('create-role')); ?>">
                                    <button class="m-b-10 btn bg-gradient-info pr" >Add a New Role</button>
                                </a>
                            <?php endif; ?>
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Admin Roles</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Admin Roles</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Status</th>
                                            <?php if(permission('admin_roles','update') || permission('admin_roles','delete')): ?>
                                            <th>Action</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($list->id); ?></td>
                                            <td> <?php if($list->name=='user'): ?><span class="badge bg-gradient-info">Trainer</span>
                                                <?php elseif($list->name=='admin'): ?><span class="badge bg-gradient-dark">Admin</span>
                                                <?php elseif($list->name=='subadmin'): ?><span class="badge bg-gradient-secondary">Sub Admin</span>
                                                <?php else: ?><span class="badge bg-gradient-secondary"><?php echo e($list->name); ?></span>
                                                <?php endif; ?></td>
                                            <td><?php if($list->status==1): ?>
                                                    <span class="badge bg-gradient-success">Active</span>
                                                <?php elseif($list->status==0): ?>
                                                    <span class="badge bg-gradient-danger">Disabled</span>
                                                <?php endif; ?>
                                            </td>
                                            <?php if((permission('admin_roles','update') || permission('admin_roles','delete')) && $list->is_main == 0): ?>
                                            <td>
                                                <?php if(permission('admin_roles','update')): ?>
                                                    <a href="<?php echo e(route('roles-edit',['id'=>base64_encode($list->id)])); ?>" title="Edit Role">
                                                        <button class="btn btn-sm bg-gradient-info pr" title="Edit Details"><i class="feather icon-edit"></i></button>
                                                    </a>
                                                    <a href="<?php echo e(route('roles-disable',['id'=>base64_encode($list->id)])); ?>" title="Enable/Disable Role" onclick="return confirm('Change Status?')">
                                                        <button class="btn btn-sm bg-gradient-secondary"><i class="feather icon-slash"></i></button>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if(permission('admin_roles','delete')): ?>
                                                    <?php if($list->name!="user"): ?>
                                                        <a href="<?php echo e(route('app-role-delete',['id'=>$list->id])); ?>" title="Delete Role " onclick="return confirm('Are you sure? Delete User')">
                                                            <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                        </a>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4"> Empty</td>
                                        </tr>
                                        <?php endif; ?>
                                        
                                    </tbody>
                                </table>
                                <?php echo e($roles->links('pagination.simple')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    <?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Apex Chart -->
    <script src="<?php echo e(asset('assets/js/plugins/apexcharts.min.js')); ?>"></script>
    <!-- custom-chart js -->
    <script src="<?php echo e(asset('assets/js/pages/dashboard-main.js')); ?>"></script>
    <script>

        function changePassword(id){
            Swal.fire({
                title: "Enter new password",
                input: "password",
                inputLabel: "New Password",
                inputPlaceholder: "Enter new password",
                inputAttributes: {
                    maxlength: "10",
                    autocapitalize: "off",
                    autocorrect: "off"
                },
                showCancelButton: true,
                confirmButtonText: "Submit",
                showLoaderOnConfirm: true,
                preConfirm: async (login) => {
                    if(login==""){
                        return Swal.showValidationMessage(`Enter Password`);
                    }
                    try {
                    const response = await fetch('<?php echo e(route("users-password")); ?>',{
                        headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                        },
                        method: "POST",
                        body: JSON.stringify({id:id,password:login,_token:$("input[name=_token]").val()})
                    });
                    if (!response.ok) {
                        return Swal.showValidationMessage(`
                        ${JSON.stringify(await response.json())}
                        `);
                    }
                    return response.json();
                    } catch (error) {
                    Swal.showValidationMessage(`
                        Request failed: ${error}
                    `);
                    
                    }
                },
                allowOutsideClick: () => !Swal.isLoading()
                }).then((result) => {
                if (result.isConfirmed) {
                    ToastK.fire({
                        icon: result.value.type ,
                        title: result.value.message 
                    });
                }
            });
        }
        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>
</body>

</html><?php /**PATH D:\xampp\htdocs\fitness-junction-main\ftj\resources\views/admin/role/list.blade.php ENDPATH**/ ?>