<!DOCTYPE html>
<html lang="en">

<head>
    <title>Chat Dashboard</title>
    <?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.css" />
</head>

<body>
    <?php echo $__env->make('includes.flash-sms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <div id="frame">
                <?php echo $__env->make('chat.chat-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="content">
                    <div class="contact-profile">
                        <img onerror="this.onerror=null;this.src='<?php echo e(asset('ftj/storage/app/default-user.jpg')); ?>'"
                            src="<?php echo e(($resp['user']->image ?? '')); ?>" alt="" />
                        <p style="float:left"><?php echo e(($resp['user']->name ?? '')); ?> </p> &#160;&#160;&#160;<small>(
                            <strong>Trainer:</strong>
                            <?php echo e(($resp['currentTrainer']->user->name ?? 'Trainer not assigned')); ?> <i
                                class="fa fa-link text-primary"></i> )</small>
                        <div class="social-media d-none">
                            <i class="fa fa-facebook" aria-hidden="true"></i>
                            <i class="fa fa-twitter" aria-hidden="true"></i>
                            <i class="fa fa-instagram" aria-hidden="true"></i>
                        </div>
                    </div>
                    <div class="messages">
                        <ul class="thisChat">

                        </ul>
                    </div>
                    <div class="message-input">
                        <div class="wrap">
                            <i onclick="onClickFileIcon()" class="fa fa-paperclip attachment" aria-hidden="true"
                                title="Attach Files"></i>
                            <input type="text" name="send_message" placeholder="Write your message..." />
                            <input type="file" name="send_file" class="d-none" onchange="fileAttachment()">
                            <button class="submit" title="Send Message">
                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('chat.chat-common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        var attached_image = "";
        var authUserId = "<?php echo e(Auth::id()); ?>";
        function fileAttachment() {
            var file = $('input[name=send_file]')[0].files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    attached_image = e.target.result.split(',')[1];
                    sendMessage();
                };
                reader.readAsDataURL(file);
            }
        }

        function onClickFileIcon() {
            $('input[name=send_file]').trigger('click');
        }

        $(".messages").animate({ scrollTop: $(document).height() }, "fast");
        $('.submit').click(function () {
            sendMessage();
        });

        $(window).on('keydown', function (e) {
            if (e.which == 13) {
                sendMessage();
                return false;
            }
        });

    </script>
    <script>
        window.onload = function (e) {
            newMessage();
            setInterval(() => {
                newMessage();
            }, 10000);
        }

        function sendMessage() {
            var message = $('input[name=send_message]').val();

            if ((message == "" || message == undefined) && attached_image != "") {
                message = "attached_image";
            }

            if ((message == "" || message == undefined) && attached_image == "") {
                $('input[name=send_message]').css('border', 'red 1px solid');
                return;
            }

            $("#gen-loading").show();

            $.ajax({
                url: '<?php echo e(route("send-user-chat")); ?>',
                type: 'PUT',
                data: {
                    message: message,
                    attached_image: attached_image,
                    trainer_id: '<?php echo e($resp["currentTrainer"]->user->id ?? 0); ?>',
                    user_id: '<?php echo e($resp["user"]->id ?? 0); ?>',
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (result) {
                    $("#gen-loading").hide();
                    attached_image = "";
                    $('.attachment').css('color', '');
                    $('input[name=send_file]').val('');
                    $('input[name=send_message]').val('');
                    Swal.fire({
                        position: "top-end",
                        icon: "success",
                        title: "Message sent",
                        showConfirmButton: false,
                        timer: 1500
                    }).then(() => {
                        newMessage()
                    });
                },
                error: function (request, msg, error) {
                    $("#gen-loading").hide();
                    Swal.fire({
                        position: "top-end",
                        icon: "error",
                        title: request.responseJSON.message,
                        showConfirmButton: false,
                        timer: 1500
                    });
                }
            });
        }
        $(document).on('input', 'input[name=send_message]', (res) => {
            if (res.target.value == '') {
                $('input[name=send_message]').css('border', 'red 1px solid');
            } else {
                $('input[name=send_message]').css('border', '#d9d9d9 1px solid');
            }
        });
        function newMessage() {
            var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric', hour: "numeric", minute: "numeric", dayPeriod: "narrow" };
            $.ajax({
                url: '<?php echo e(route("get-user-chat")); ?>', type: 'PUT', data: { trainer_id: '<?php echo e($resp["currentTrainer"]->user->id ?? 0); ?>', user_id: '<?php echo e($resp["user"]->id ?? 0); ?>', _token: "<?php echo e(csrf_token()); ?>" },
                success: function (result) {
                    var dataHtml = '';
                    result.forEach(function (obj) {
                        var today = new Date(obj.created_at);
                        var attachments = "";
                        if (obj.attechments) {
                            try {
                                var files = JSON.parse(obj.attechments);
                                if (Array.isArray(files)) {
                                    attachments += `<div class="attachment-container">`;
                                    files.forEach(function (f) {
                                        var fileUrl = `<?php echo e(asset('ftj/storage/chat_attached')); ?>/` + f;
                                        var ext = f.split('.').pop().toLowerCase();
                                        var isImage = ['jpg', 'jpeg', 'png', 'gif', 'webp'].includes(ext);

                                        if (isImage) {
                                            attachments += `
                                                <div class="attachment-item image-attachment">
                                                    <img onerror="this.onerror=null;this.src='<?php echo e(asset('ftj/storage/app/default-user.jpg')); ?>'" src="${fileUrl}" />
                                                    <a href="${fileUrl}" download="${f}" class="download-btn" title="Download Image">
                                                        <i class="fa fa-download"></i>
                                                    </a>
                                                </div>`;
                                        } else {
                                            var icon = 'fa-file-alt';
                                            if (ext === 'pdf') icon = 'fa-file-pdf';
                                            else if (['doc', 'docx'].includes(ext)) icon = 'fa-file-word';
                                            else if (['xls', 'xlsx'].includes(ext)) icon = 'fa-file-excel';
                                            else if (['zip', 'rar'].includes(ext)) icon = 'fa-file-archive';

                                            attachments += `
                                                <div class="attachment-item doc-attachment">
                                                    <div class="doc-info">
                                                        <i class="fa ${icon} file-icon"></i>
                                                        <span class="file-name" title="${f}">${f}</span>
                                                    </div>
                                                    <a href="${fileUrl}" download="${f}" class="download-btn" title="Download Document">
                                                        <i class="fa fa-download"></i>
                                                    </a>
                                                </div>`;
                                        }
                                    });
                                    attachments += `</div>`;
                                }
                            } catch (e) {
                                console.error("Attachment parsing error:", e);
                            }
                        }

                        var isMe = (obj.sender_id !== <?php echo e(isset($resp["currentTrainer"]->user->id) ? $resp["currentTrainer"]->user->id : 0); ?>);
                        var chatClass = isMe ? 'me' : 'other';
                        var displayName = isMe ? 'You' : (obj.sender_name);

                        var profileImg = obj.sender_profile;
                        if (!profileImg) {
                            profileImg = `https://ui-avatars.com/api/?name=${encodeURIComponent(displayName)}&background=8e44ad&color=fff`;
                        }
                        var displayMsg = (obj.message && obj.message !== "null") ? obj.message : "";
                        var timeString = '';
                        if (obj?.created_at) {
                            const fixedDate = new Date(obj.created_at.replace('Z', ''));
                            timeString = fixedDate.toLocaleString('en-IN', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric',
                                hour: '2-digit',
                                minute: '2-digit',
                                hour12: true
                            }).toLowerCase();
                        }
                        if (isMe) {
                            dataHtml += `
                                <div class="chat-row me">
                                    <div class="chat-bubble-wrapper">
                                        <div class="chat-bubble">
                                            ${displayMsg}
                                            ${attachments}
                                        </div>
                                        <div class="chat-meta">
                                            ${timeString}
                                        </div>
                                    </div>
                                </div>
                            `;
                        } else {
                            dataHtml += `
                                <div class="chat-row other">
                                    <img onerror="this.onerror=null;this.src='<?php echo e(asset('ftj/storage/app/default-user.jpg')); ?>'" src="${profileImg}" class="chat-avatar" alt="${displayName}">
                                    <div class="chat-bubble-wrapper">
                                        <div class="chat-user-name">${displayName}</div>
                                        <div class="chat-bubble">
                                            ${displayMsg}
                                            ${attachments}
                                            <div class="chat-footer-info">
                                                <span class="small">${timeString}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
                        }
                    });
                    $('.thisChat').html(dataHtml);
                    var messagesDiv = document.querySelector(".messages");
                    if (messagesDiv) messagesDiv.scrollTop = messagesDiv.scrollHeight;
                },
                error: function (request, msg, error) { }
            });
        }
        $(document).on('click', '.getNew', () => {
            Swal.fire({
                title: "Start new chat",
                html: `
                <div class="form-group" style="height:50vh;">
                    <select id="getNewChat" name="getNewChat" class="form-control selectpicker"  data-live-search="true" required>
                        <?php $__currentLoopData = $resp['newChat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option class="getNewChatID" value="<?php echo e(route('chat-details', ['user' => base64_encode(openssl_encrypt($list->id, 'AES-128-CTR', 'kulwindermatharu', 0, 'kulwindermatharu'))])); ?>"><?php echo e($list->name); ?> - <?php echo e($list->email); ?> Trainer: <?php echo e($list->currentTrainer->user->name ?? ''); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                               `,
                showConfirmButton: false,
                width: "80%",

            });
            setTimeout(() => {
                var adf = $(document).find('#getNewChat')[0];
                $(adf).selectpicker();
            }, 500);
        });

        $(document).on('click', '.getNewChatID', (e) => {
            open($('#getNewChat').val(), '_self')
        });
    </script>

</body>

</html><?php /**PATH D:\xampp\htdocs\fitness-junction-main\ftj\resources\views/chat/chat-detail.blade.php ENDPATH**/ ?>