import React, { useState, Suspense, useEffect } from 'react';
import { Outlet } from 'react-router-dom';
import { Sidebar } from '../components/Sidebar';
import { Header } from '../components/Header';
import PageLoading from '../components/common/PageLoading';

const MainLayout: React.FC = () => {
    const [isSidebarLocked, setIsSidebarLocked] = useState(() => {
        const saved = localStorage.getItem('sidebarLocked');
        return saved !== null ? JSON.parse(saved) : true;
    });

    useEffect(() => {
        localStorage.setItem('sidebarLocked', JSON.stringify(isSidebarLocked));
    }, [isSidebarLocked]);

    return (
        <div className="flex h-screen w-full overflow-hidden text-white">
            <Sidebar isLocked={isSidebarLocked} setIsLocked={setIsSidebarLocked} />

            <main className="flex-1 flex flex-col min-w-0 overflow-hidden relative">
                <Header />
                <div className="flex-1 overflow-auto relative">
                    <Suspense fallback={<PageLoading />}>
                        <Outlet />
                    </Suspense>
                </div>
            </main>
        </div>
    );
};

export default MainLayout;
