import React from 'react';
import { BarChart3, TrendingUp, Users, Target } from 'lucide-react';

const DashboardPage: React.FC = () => {
    const stats = [
        { title: 'Total Deals', value: '1,284', change: '+12%', icon: Target, color: 'text-blue-400' },
        { title: 'Active Clients', value: '842', change: '+5%', icon: Users, color: 'text-purple-400' },
        { title: 'Revenue', value: '$428.5k', change: '+18%', icon: TrendingUp, color: 'text-emerald-400' },
        { title: 'Conversion', value: '24.2%', change: '+2%', icon: BarChart3, color: 'text-amber-400' },
    ];

    return (
        <div className="p-8 max-w-7xl mx-auto">
            <div className="mb-10">
                <h1 className="text-3xl font-bold mb-2">Dashboard Overview</h1>
                <p className="text-white/50">Welcome back! Here's what's happening today.</p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
                {stats.map((stat, i) => (
                    <div key={i} className="bg-white/5 border border-white/10 p-6 rounded-2xl backdrop-blur-sm hover:border-white/20 transition-all group">
                        <div className="flex justify-between items-start mb-4">
                            <div className={`p-3 rounded-xl bg-white/5 ${stat.color} group-hover:scale-110 transition-transform`}>
                                <stat.icon size={24} />
                            </div>
                            <span className="text-emerald-400 text-sm font-bold bg-emerald-400/10 px-2.5 py-1 rounded-full">
                                {stat.change}
                            </span>
                        </div>
                        <h3 className="text-white/60 text-sm font-medium mb-1">{stat.title}</h3>
                        <p className="text-2xl font-bold">{stat.value}</p>
                    </div>
                ))}
            </div>

            <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <div className="bg-white/5 border border-white/10 p-8 rounded-3xl">
                    <h2 className="text-xl font-bold mb-6">Recent Activity</h2>
                    <div className="space-y-6">
                        {[1, 2, 3, 4].map((_, i) => (
                            <div key={i} className="flex gap-4 items-start">
                                <div className="w-2 h-2 rounded-full bg-blue-400 mt-2" />
                                <div>
                                    <p className="text-sm font-medium">New deal created for <span className="text-blue-400">Quantum Systems</span></p>
                                    <p className="text-xs text-white/40 mt-1">2 hours ago</p>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>

                <div className="bg-white/5 border border-white/10 p-8 rounded-3xl">
                    <h2 className="text-xl font-bold mb-6">Performance Matrix</h2>
                    <div className="h-48 flex items-end gap-3 justify-between">
                        {[40, 70, 45, 90, 65, 80, 50].map((h, i) => (
                            <div key={i} className="flex-1 bg-white/10 rounded-t-lg transition-all hover:bg-white/20 relative group" style={{ height: `${h}%` }}>
                                <div className="absolute -top-8 left-1/2 -translate-x-1/2 bg-white text-black text-[10px] font-bold px-1.5 py-0.5 rounded opacity-0 group-hover:opacity-100 transition-opacity">
                                    {h}%
                                </div>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </div>
    );
};

export default DashboardPage;
